package software.amazon.awscdk.services.wisdom;

/**
 * Properties for defining a <code>CfnQuickResponse</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * CfnQuickResponseProps cfnQuickResponseProps = CfnQuickResponseProps.builder()
 *         .content(QuickResponseContentProviderProperty.builder()
 *                 .content("content")
 *                 .build())
 *         .knowledgeBaseArn("knowledgeBaseArn")
 *         .name("name")
 *         // the properties below are optional
 *         .channels(List.of("channels"))
 *         .contentType("contentType")
 *         .description("description")
 *         .groupingConfiguration(GroupingConfigurationProperty.builder()
 *                 .criteria("criteria")
 *                 .values(List.of("values"))
 *                 .build())
 *         .isActive(false)
 *         .language("language")
 *         .shortcutKey("shortcutKey")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-08-06T18:14:47.534Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnQuickResponseProps")
@software.amazon.jsii.Jsii.Proxy(CfnQuickResponseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnQuickResponseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The content of the quick response.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-content">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-content</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getContent();

    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-knowledgebasearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-knowledgebasearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKnowledgeBaseArn();

    /**
     * The name of the quick response.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The Amazon Connect contact channels this quick response applies to.
     * <p>
     * The supported contact channel types include <code>Chat</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-channels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-channels</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getChannels() {
        return null;
    }

    /**
     * The media type of the quick response content.
     * <p>
     * <ul>
     * <li>Use <code>application/x.quickresponse;format=plain</code> for quick response written in plain text.</li>
     * <li>Use <code>application/x.quickresponse;format=markdown</code> for quick response written in richtext.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-contenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-contenttype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
        return null;
    }

    /**
     * The description of the quick response.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The configuration information of the user groups that the quick response is accessible to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-groupingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-groupingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGroupingConfiguration() {
        return null;
    }

    /**
     * Whether the quick response is active.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-isactive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-isactive</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIsActive() {
        return null;
    }

    /**
     * The language code value for the language in which the quick response is written.
     * <p>
     * The supported language codes include <code>de_DE</code> , <code>en_US</code> , <code>es_ES</code> , <code>fr_FR</code> , <code>id_ID</code> , <code>it_IT</code> , <code>ja_JP</code> , <code>ko_KR</code> , <code>pt_BR</code> , <code>zh_CN</code> , <code>zh_TW</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-language">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-language</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLanguage() {
        return null;
    }

    /**
     * The shortcut key of the quick response.
     * <p>
     * The value should be unique across the knowledge base.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-shortcutkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-shortcutkey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getShortcutKey() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-quickresponse.html#cfn-wisdom-quickresponse-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnQuickResponseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnQuickResponseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnQuickResponseProps> {
        java.lang.Object content;
        java.lang.String knowledgeBaseArn;
        java.lang.String name;
        java.util.List<java.lang.String> channels;
        java.lang.String contentType;
        java.lang.String description;
        java.lang.Object groupingConfiguration;
        java.lang.Object isActive;
        java.lang.String language;
        java.lang.String shortcutKey;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnQuickResponseProps#getContent}
         * @param content The content of the quick response. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(software.amazon.awscdk.IResolvable content) {
            this.content = content;
            return this;
        }

        /**
         * Sets the value of {@link CfnQuickResponseProps#getContent}
         * @param content The content of the quick response. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(software.amazon.awscdk.services.wisdom.CfnQuickResponse.QuickResponseContentProviderProperty content) {
            this.content = content;
            return this;
        }

        /**
         * Sets the value of {@link CfnQuickResponseProps#getKnowledgeBaseArn}
         * @param knowledgeBaseArn The Amazon Resource Name (ARN) of the knowledge base. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseArn(java.lang.String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnQuickResponseProps#getName}
         * @param name The name of the quick response. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnQuickResponseProps#getChannels}
         * @param channels The Amazon Connect contact channels this quick response applies to.
         *                 The supported contact channel types include <code>Chat</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channels(java.util.List<java.lang.String> channels) {
            this.channels = channels;
            return this;
        }

        /**
         * Sets the value of {@link CfnQuickResponseProps#getContentType}
         * @param contentType The media type of the quick response content.
         *                    <ul>
         *                    <li>Use <code>application/x.quickresponse;format=plain</code> for quick response written in plain text.</li>
         *                    <li>Use <code>application/x.quickresponse;format=markdown</code> for quick response written in richtext.</li>
         *                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentType(java.lang.String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Sets the value of {@link CfnQuickResponseProps#getDescription}
         * @param description The description of the quick response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnQuickResponseProps#getGroupingConfiguration}
         * @param groupingConfiguration The configuration information of the user groups that the quick response is accessible to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupingConfiguration(software.amazon.awscdk.IResolvable groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnQuickResponseProps#getGroupingConfiguration}
         * @param groupingConfiguration The configuration information of the user groups that the quick response is accessible to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupingConfiguration(software.amazon.awscdk.services.wisdom.CfnQuickResponse.GroupingConfigurationProperty groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnQuickResponseProps#getIsActive}
         * @param isActive Whether the quick response is active.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isActive(java.lang.Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        /**
         * Sets the value of {@link CfnQuickResponseProps#getIsActive}
         * @param isActive Whether the quick response is active.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isActive(software.amazon.awscdk.IResolvable isActive) {
            this.isActive = isActive;
            return this;
        }

        /**
         * Sets the value of {@link CfnQuickResponseProps#getLanguage}
         * @param language The language code value for the language in which the quick response is written.
         *                 The supported language codes include <code>de_DE</code> , <code>en_US</code> , <code>es_ES</code> , <code>fr_FR</code> , <code>id_ID</code> , <code>it_IT</code> , <code>ja_JP</code> , <code>ko_KR</code> , <code>pt_BR</code> , <code>zh_CN</code> , <code>zh_TW</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder language(java.lang.String language) {
            this.language = language;
            return this;
        }

        /**
         * Sets the value of {@link CfnQuickResponseProps#getShortcutKey}
         * @param shortcutKey The shortcut key of the quick response.
         *                    The value should be unique across the knowledge base.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shortcutKey(java.lang.String shortcutKey) {
            this.shortcutKey = shortcutKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnQuickResponseProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnQuickResponseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnQuickResponseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnQuickResponseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnQuickResponseProps {
        private final java.lang.Object content;
        private final java.lang.String knowledgeBaseArn;
        private final java.lang.String name;
        private final java.util.List<java.lang.String> channels;
        private final java.lang.String contentType;
        private final java.lang.String description;
        private final java.lang.Object groupingConfiguration;
        private final java.lang.Object isActive;
        private final java.lang.String language;
        private final java.lang.String shortcutKey;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.knowledgeBaseArn = software.amazon.jsii.Kernel.get(this, "knowledgeBaseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.channels = software.amazon.jsii.Kernel.get(this, "channels", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.groupingConfiguration = software.amazon.jsii.Kernel.get(this, "groupingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.isActive = software.amazon.jsii.Kernel.get(this, "isActive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.language = software.amazon.jsii.Kernel.get(this, "language", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.shortcutKey = software.amazon.jsii.Kernel.get(this, "shortcutKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.content = java.util.Objects.requireNonNull(builder.content, "content is required");
            this.knowledgeBaseArn = java.util.Objects.requireNonNull(builder.knowledgeBaseArn, "knowledgeBaseArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.channels = builder.channels;
            this.contentType = builder.contentType;
            this.description = builder.description;
            this.groupingConfiguration = builder.groupingConfiguration;
            this.isActive = builder.isActive;
            this.language = builder.language;
            this.shortcutKey = builder.shortcutKey;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getContent() {
            return this.content;
        }

        @Override
        public final java.lang.String getKnowledgeBaseArn() {
            return this.knowledgeBaseArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<java.lang.String> getChannels() {
            return this.channels;
        }

        @Override
        public final java.lang.String getContentType() {
            return this.contentType;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getGroupingConfiguration() {
            return this.groupingConfiguration;
        }

        @Override
        public final java.lang.Object getIsActive() {
            return this.isActive;
        }

        @Override
        public final java.lang.String getLanguage() {
            return this.language;
        }

        @Override
        public final java.lang.String getShortcutKey() {
            return this.shortcutKey;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("content", om.valueToTree(this.getContent()));
            data.set("knowledgeBaseArn", om.valueToTree(this.getKnowledgeBaseArn()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getChannels() != null) {
                data.set("channels", om.valueToTree(this.getChannels()));
            }
            if (this.getContentType() != null) {
                data.set("contentType", om.valueToTree(this.getContentType()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getGroupingConfiguration() != null) {
                data.set("groupingConfiguration", om.valueToTree(this.getGroupingConfiguration()));
            }
            if (this.getIsActive() != null) {
                data.set("isActive", om.valueToTree(this.getIsActive()));
            }
            if (this.getLanguage() != null) {
                data.set("language", om.valueToTree(this.getLanguage()));
            }
            if (this.getShortcutKey() != null) {
                data.set("shortcutKey", om.valueToTree(this.getShortcutKey()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnQuickResponseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnQuickResponseProps.Jsii$Proxy that = (CfnQuickResponseProps.Jsii$Proxy) o;

            if (!content.equals(that.content)) return false;
            if (!knowledgeBaseArn.equals(that.knowledgeBaseArn)) return false;
            if (!name.equals(that.name)) return false;
            if (this.channels != null ? !this.channels.equals(that.channels) : that.channels != null) return false;
            if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.groupingConfiguration != null ? !this.groupingConfiguration.equals(that.groupingConfiguration) : that.groupingConfiguration != null) return false;
            if (this.isActive != null ? !this.isActive.equals(that.isActive) : that.isActive != null) return false;
            if (this.language != null ? !this.language.equals(that.language) : that.language != null) return false;
            if (this.shortcutKey != null ? !this.shortcutKey.equals(that.shortcutKey) : that.shortcutKey != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.content.hashCode();
            result = 31 * result + (this.knowledgeBaseArn.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.channels != null ? this.channels.hashCode() : 0);
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.groupingConfiguration != null ? this.groupingConfiguration.hashCode() : 0);
            result = 31 * result + (this.isActive != null ? this.isActive.hashCode() : 0);
            result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
            result = 31 * result + (this.shortcutKey != null ? this.shortcutKey.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
