package software.amazon.awscdk;

/**
 * This is a collection of ProjectInjectors assigned to this scope.
 * <p>
 * It is keyed by constructUniqueId.  There can be only one ProjectInjector for a constructUniqueId.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * PropertyInjectors propertyInjectors = PropertyInjectors.of(this);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:09.015Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.PropertyInjectors")
public class PropertyInjectors extends software.amazon.jsii.JsiiObject {

    protected PropertyInjectors(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PropertyInjectors(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Return whether the given object has a PropertyInjectors property.
     * <p>
     * We do attribute detection since we can't reliably use 'instanceof'.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean hasPropertyInjectors(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.PropertyInjectors.class, "hasPropertyInjectors", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Returns the <code>PropertyInjectors</code> object associated with a construct scope.
     * <p>
     * If <code>PropertyInjectors</code> object doesn't exist on this scope, then it creates one and attaches it to scope.
     * <p>
     * @param scope The scope for which these PropertyInjectors will apply. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.PropertyInjectors of(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct scope) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.PropertyInjectors.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.PropertyInjectors.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Add a list of  IPropertyInjectors to this collection of PropertyInjectors.
     * <p>
     * @param propsInjectors <ul><li>a list of IPropertyInjector.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void add(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IPropertyInjector... propsInjectors) {
        software.amazon.jsii.Kernel.call(this, "add", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(propsInjectors).toArray(Object[]::new));
    }

    /**
     * Get the PropertyInjector that is registered to the Construct's uniqueId.
     * <p>
     * @return <ul>
     * <li>the IPropertyInjector for that construct uniqueId</li>
     * </ul>
     * @param uniqueId <ul><li>the construct uniqueId.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.IPropertyInjector doFor(final @org.jetbrains.annotations.NotNull java.lang.String uniqueId) {
        return software.amazon.jsii.Kernel.call(this, "for", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IPropertyInjector.class), new Object[] { java.util.Objects.requireNonNull(uniqueId, "uniqueId is required") });
    }

    /**
     * This returns a list of the Constructs that are supporting by this PropertyInjectors.
     * <p>
     * @return a list of string showing the supported Constructs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> supportedClasses() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "supportedClasses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The scope attached to Injectors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.constructs.IConstruct getScope() {
        return software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(software.constructs.IConstruct.class));
    }
}
