package software.amazon.awscdk.cloud_assembly_schema;

/**
 * Represents an integration test case.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloud_assembly_schema.*;
 * TestCase testCase = TestCase.builder()
 *         .stacks(List.of("stacks"))
 *         // the properties below are optional
 *         .allowDestroy(List.of("allowDestroy"))
 *         .assertionStack("assertionStack")
 *         .assertionStackName("assertionStackName")
 *         .cdkCommandOptions(CdkCommands.builder()
 *                 .deploy(DeployCommand.builder()
 *                         .args(DeployOptions.builder()
 *                                 .all(false)
 *                                 .app("app")
 *                                 .assetMetadata(false)
 *                                 .caBundlePath("caBundlePath")
 *                                 .changeSetName("changeSetName")
 *                                 .ci(false)
 *                                 .color(false)
 *                                 .concurrency(123)
 *                                 .context(Map.of(
 *                                         "contextKey", "context"))
 *                                 .debug(false)
 *                                 .ec2Creds(false)
 *                                 .exclusively(false)
 *                                 .execute(false)
 *                                 .force(false)
 *                                 .ignoreErrors(false)
 *                                 .json(false)
 *                                 .lookups(false)
 *                                 .notices(false)
 *                                 .notificationArns(List.of("notificationArns"))
 *                                 .output("output")
 *                                 .outputsFile("outputsFile")
 *                                 .parameters(Map.of(
 *                                         "parametersKey", "parameters"))
 *                                 .pathMetadata(false)
 *                                 .profile("profile")
 *                                 .proxy("proxy")
 *                                 .requireApproval(RequireApproval.NEVER)
 *                                 .reuseAssets(List.of("reuseAssets"))
 *                                 .roleArn("roleArn")
 *                                 .rollback(false)
 *                                 .stacks(List.of("stacks"))
 *                                 .staging(false)
 *                                 .strict(false)
 *                                 .toolkitStackName("toolkitStackName")
 *                                 .trace(false)
 *                                 .usePreviousParameters(false)
 *                                 .verbose(false)
 *                                 .versionReporting(false)
 *                                 .build())
 *                         .enabled(false)
 *                         .expectedMessage("expectedMessage")
 *                         .expectError(false)
 *                         .build())
 *                 .destroy(DestroyCommand.builder()
 *                         .args(DestroyOptions.builder()
 *                                 .all(false)
 *                                 .app("app")
 *                                 .assetMetadata(false)
 *                                 .caBundlePath("caBundlePath")
 *                                 .color(false)
 *                                 .context(Map.of(
 *                                         "contextKey", "context"))
 *                                 .debug(false)
 *                                 .ec2Creds(false)
 *                                 .exclusively(false)
 *                                 .force(false)
 *                                 .ignoreErrors(false)
 *                                 .json(false)
 *                                 .lookups(false)
 *                                 .notices(false)
 *                                 .output("output")
 *                                 .pathMetadata(false)
 *                                 .profile("profile")
 *                                 .proxy("proxy")
 *                                 .roleArn("roleArn")
 *                                 .stacks(List.of("stacks"))
 *                                 .staging(false)
 *                                 .strict(false)
 *                                 .trace(false)
 *                                 .verbose(false)
 *                                 .versionReporting(false)
 *                                 .build())
 *                         .enabled(false)
 *                         .expectedMessage("expectedMessage")
 *                         .expectError(false)
 *                         .build())
 *                 .build())
 *         .diffAssets(false)
 *         .hooks(Hooks.builder()
 *                 .postDeploy(List.of("postDeploy"))
 *                 .postDestroy(List.of("postDestroy"))
 *                 .preDeploy(List.of("preDeploy"))
 *                 .preDestroy(List.of("preDestroy"))
 *                 .build())
 *         .regions(List.of("regions"))
 *         .stackUpdateWorkflow(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:25.992Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.TestCase")
@software.amazon.jsii.Jsii.Proxy(TestCase.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TestCase extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.cloud_assembly_schema.TestOptions {

    /**
     * Stacks that should be tested as part of this test case The stackNames will be passed as args to the cdk commands so dependent stacks will be automatically deployed unless <code>exclusively</code> is passed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getStacks();

    /**
     * The node id of the stack that contains assertions.
     * <p>
     * This is the value that can be used to deploy the stack with the CDK CLI
     * <p>
     * Default: - no assertion stack
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssertionStack() {
        return null;
    }

    /**
     * The name of the stack that contains assertions.
     * <p>
     * Default: - no assertion stack
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssertionStackName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TestCase}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TestCase}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TestCase> {
        java.util.List<java.lang.String> stacks;
        java.lang.String assertionStack;
        java.lang.String assertionStackName;
        java.util.List<java.lang.String> allowDestroy;
        software.amazon.awscdk.cloud_assembly_schema.CdkCommands cdkCommandOptions;
        java.lang.Boolean diffAssets;
        software.amazon.awscdk.cloud_assembly_schema.Hooks hooks;
        java.util.List<java.lang.String> regions;
        java.lang.Boolean stackUpdateWorkflow;

        /**
         * Sets the value of {@link TestCase#getStacks}
         * @param stacks Stacks that should be tested as part of this test case The stackNames will be passed as args to the cdk commands so dependent stacks will be automatically deployed unless <code>exclusively</code> is passed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stacks(java.util.List<java.lang.String> stacks) {
            this.stacks = stacks;
            return this;
        }

        /**
         * Sets the value of {@link TestCase#getAssertionStack}
         * @param assertionStack The node id of the stack that contains assertions.
         *                       This is the value that can be used to deploy the stack with the CDK CLI
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assertionStack(java.lang.String assertionStack) {
            this.assertionStack = assertionStack;
            return this;
        }

        /**
         * Sets the value of {@link TestCase#getAssertionStackName}
         * @param assertionStackName The name of the stack that contains assertions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assertionStackName(java.lang.String assertionStackName) {
            this.assertionStackName = assertionStackName;
            return this;
        }

        /**
         * Sets the value of {@link TestCase#getAllowDestroy}
         * @param allowDestroy List of CloudFormation resource types in this stack that can be destroyed as part of an update without failing the test.
         *                     This list should only include resources that for this specific
         *                     integration test we are sure will not cause errors or an outage if
         *                     destroyed. For example, maybe we know that a new resource will be created
         *                     first before the old resource is destroyed which prevents any outage.
         *                     <p>
         *                     e.g. ['AWS::IAM::Role']
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowDestroy(java.util.List<java.lang.String> allowDestroy) {
            this.allowDestroy = allowDestroy;
            return this;
        }

        /**
         * Sets the value of {@link TestCase#getCdkCommandOptions}
         * @param cdkCommandOptions Additional options to use for each CDK command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdkCommandOptions(software.amazon.awscdk.cloud_assembly_schema.CdkCommands cdkCommandOptions) {
            this.cdkCommandOptions = cdkCommandOptions;
            return this;
        }

        /**
         * Sets the value of {@link TestCase#getDiffAssets}
         * @param diffAssets Whether or not to include asset hashes in the diff Asset hashes can introduces a lot of unneccessary noise into tests, but there are some cases where asset hashes <em>should</em> be included.
         *                   For example
         *                   any tests involving custom resources or bundling
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder diffAssets(java.lang.Boolean diffAssets) {
            this.diffAssets = diffAssets;
            return this;
        }

        /**
         * Sets the value of {@link TestCase#getHooks}
         * @param hooks Additional commands to run at predefined points in the test workflow.
         *              e.g. { postDeploy: ['yarn', 'test'] }
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hooks(software.amazon.awscdk.cloud_assembly_schema.Hooks hooks) {
            this.hooks = hooks;
            return this;
        }

        /**
         * Sets the value of {@link TestCase#getRegions}
         * @param regions Limit deployment to these regions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regions(java.util.List<java.lang.String> regions) {
            this.regions = regions;
            return this;
        }

        /**
         * Sets the value of {@link TestCase#getStackUpdateWorkflow}
         * @param stackUpdateWorkflow Run update workflow on this test case This should only be set to false to test scenarios that are not possible to test as part of the update workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackUpdateWorkflow(java.lang.Boolean stackUpdateWorkflow) {
            this.stackUpdateWorkflow = stackUpdateWorkflow;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TestCase}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TestCase build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TestCase}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TestCase {
        private final java.util.List<java.lang.String> stacks;
        private final java.lang.String assertionStack;
        private final java.lang.String assertionStackName;
        private final java.util.List<java.lang.String> allowDestroy;
        private final software.amazon.awscdk.cloud_assembly_schema.CdkCommands cdkCommandOptions;
        private final java.lang.Boolean diffAssets;
        private final software.amazon.awscdk.cloud_assembly_schema.Hooks hooks;
        private final java.util.List<java.lang.String> regions;
        private final java.lang.Boolean stackUpdateWorkflow;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stacks = software.amazon.jsii.Kernel.get(this, "stacks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.assertionStack = software.amazon.jsii.Kernel.get(this, "assertionStack", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assertionStackName = software.amazon.jsii.Kernel.get(this, "assertionStackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowDestroy = software.amazon.jsii.Kernel.get(this, "allowDestroy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cdkCommandOptions = software.amazon.jsii.Kernel.get(this, "cdkCommandOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.CdkCommands.class));
            this.diffAssets = software.amazon.jsii.Kernel.get(this, "diffAssets", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.hooks = software.amazon.jsii.Kernel.get(this, "hooks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.Hooks.class));
            this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.stackUpdateWorkflow = software.amazon.jsii.Kernel.get(this, "stackUpdateWorkflow", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stacks = java.util.Objects.requireNonNull(builder.stacks, "stacks is required");
            this.assertionStack = builder.assertionStack;
            this.assertionStackName = builder.assertionStackName;
            this.allowDestroy = builder.allowDestroy;
            this.cdkCommandOptions = builder.cdkCommandOptions;
            this.diffAssets = builder.diffAssets;
            this.hooks = builder.hooks;
            this.regions = builder.regions;
            this.stackUpdateWorkflow = builder.stackUpdateWorkflow;
        }

        @Override
        public final java.util.List<java.lang.String> getStacks() {
            return this.stacks;
        }

        @Override
        public final java.lang.String getAssertionStack() {
            return this.assertionStack;
        }

        @Override
        public final java.lang.String getAssertionStackName() {
            return this.assertionStackName;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowDestroy() {
            return this.allowDestroy;
        }

        @Override
        public final software.amazon.awscdk.cloud_assembly_schema.CdkCommands getCdkCommandOptions() {
            return this.cdkCommandOptions;
        }

        @Override
        public final java.lang.Boolean getDiffAssets() {
            return this.diffAssets;
        }

        @Override
        public final software.amazon.awscdk.cloud_assembly_schema.Hooks getHooks() {
            return this.hooks;
        }

        @Override
        public final java.util.List<java.lang.String> getRegions() {
            return this.regions;
        }

        @Override
        public final java.lang.Boolean getStackUpdateWorkflow() {
            return this.stackUpdateWorkflow;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stacks", om.valueToTree(this.getStacks()));
            if (this.getAssertionStack() != null) {
                data.set("assertionStack", om.valueToTree(this.getAssertionStack()));
            }
            if (this.getAssertionStackName() != null) {
                data.set("assertionStackName", om.valueToTree(this.getAssertionStackName()));
            }
            if (this.getAllowDestroy() != null) {
                data.set("allowDestroy", om.valueToTree(this.getAllowDestroy()));
            }
            if (this.getCdkCommandOptions() != null) {
                data.set("cdkCommandOptions", om.valueToTree(this.getCdkCommandOptions()));
            }
            if (this.getDiffAssets() != null) {
                data.set("diffAssets", om.valueToTree(this.getDiffAssets()));
            }
            if (this.getHooks() != null) {
                data.set("hooks", om.valueToTree(this.getHooks()));
            }
            if (this.getRegions() != null) {
                data.set("regions", om.valueToTree(this.getRegions()));
            }
            if (this.getStackUpdateWorkflow() != null) {
                data.set("stackUpdateWorkflow", om.valueToTree(this.getStackUpdateWorkflow()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.TestCase"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TestCase.Jsii$Proxy that = (TestCase.Jsii$Proxy) o;

            if (!stacks.equals(that.stacks)) return false;
            if (this.assertionStack != null ? !this.assertionStack.equals(that.assertionStack) : that.assertionStack != null) return false;
            if (this.assertionStackName != null ? !this.assertionStackName.equals(that.assertionStackName) : that.assertionStackName != null) return false;
            if (this.allowDestroy != null ? !this.allowDestroy.equals(that.allowDestroy) : that.allowDestroy != null) return false;
            if (this.cdkCommandOptions != null ? !this.cdkCommandOptions.equals(that.cdkCommandOptions) : that.cdkCommandOptions != null) return false;
            if (this.diffAssets != null ? !this.diffAssets.equals(that.diffAssets) : that.diffAssets != null) return false;
            if (this.hooks != null ? !this.hooks.equals(that.hooks) : that.hooks != null) return false;
            if (this.regions != null ? !this.regions.equals(that.regions) : that.regions != null) return false;
            return this.stackUpdateWorkflow != null ? this.stackUpdateWorkflow.equals(that.stackUpdateWorkflow) : that.stackUpdateWorkflow == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stacks.hashCode();
            result = 31 * result + (this.assertionStack != null ? this.assertionStack.hashCode() : 0);
            result = 31 * result + (this.assertionStackName != null ? this.assertionStackName.hashCode() : 0);
            result = 31 * result + (this.allowDestroy != null ? this.allowDestroy.hashCode() : 0);
            result = 31 * result + (this.cdkCommandOptions != null ? this.cdkCommandOptions.hashCode() : 0);
            result = 31 * result + (this.diffAssets != null ? this.diffAssets.hashCode() : 0);
            result = 31 * result + (this.hooks != null ? this.hooks.hashCode() : 0);
            result = 31 * result + (this.regions != null ? this.regions.hashCode() : 0);
            result = 31 * result + (this.stackUpdateWorkflow != null ? this.stackUpdateWorkflow.hashCode() : 0);
            return result;
        }
    }
}
