package software.amazon.awscdk.cxapi;

/**
 * Asset manifest is a description of a set of assets which need to be built and published.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloud_assembly_schema.*;
 * import software.amazon.awscdk.cxapi.*;
 * Object assumeRoleAdditionalOptions;
 * CloudAssembly cloudAssembly;
 * AssetManifestArtifact assetManifestArtifact = AssetManifestArtifact.Builder.create(cloudAssembly, "name")
 *         .type(ArtifactType.NONE)
 *         // the properties below are optional
 *         .dependencies(List.of("dependencies"))
 *         .displayName("displayName")
 *         .environment("environment")
 *         .metadata(Map.of(
 *                 "metadataKey", List.of(MetadataEntry.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .data("data")
 *                         .trace(List.of("trace"))
 *                         .build())))
 *         .properties(AwsCloudFormationStackProperties.builder()
 *                 .templateFile("templateFile")
 *                 // the properties below are optional
 *                 .assumeRoleAdditionalOptions(Map.of(
 *                         "assumeRoleAdditionalOptionsKey", assumeRoleAdditionalOptions))
 *                 .assumeRoleArn("assumeRoleArn")
 *                 .assumeRoleExternalId("assumeRoleExternalId")
 *                 .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *                 .cloudFormationExecutionRoleArn("cloudFormationExecutionRoleArn")
 *                 .lookupRole(BootstrapRole.builder()
 *                         .arn("arn")
 *                         // the properties below are optional
 *                         .assumeRoleAdditionalOptions(Map.of(
 *                                 "assumeRoleAdditionalOptionsKey", assumeRoleAdditionalOptions))
 *                         .assumeRoleExternalId("assumeRoleExternalId")
 *                         .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *                         .requiresBootstrapStackVersion(123)
 *                         .build())
 *                 .notificationArns(List.of("notificationArns"))
 *                 .parameters(Map.of(
 *                         "parametersKey", "parameters"))
 *                 .requiresBootstrapStackVersion(123)
 *                 .stackName("stackName")
 *                 .stackTemplateAssetObjectUrl("stackTemplateAssetObjectUrl")
 *                 .tags(Map.of(
 *                         "tagsKey", "tags"))
 *                 .terminationProtection(false)
 *                 .validateOnSynth(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:26.043Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cx_api.AssetManifestArtifact")
public class AssetManifestArtifact extends software.amazon.awscdk.cxapi.CloudArtifact {

    protected AssetManifestArtifact(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetManifestArtifact(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param assembly This parameter is required.
     * @param name This parameter is required.
     * @param artifact This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetManifestArtifact(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssembly assembly, final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.ArtifactManifest artifact) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(assembly, "assembly is required"), java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(artifact, "artifact is required") });
    }

    /**
     * Checks if <code>art</code> is an instance of this class.
     * <p>
     * Use this method instead of <code>instanceof</code> to properly detect <code>AssetManifestArtifact</code>
     * instances, even when the construct library is symlinked.
     * <p>
     * Explanation: in JavaScript, multiple copies of the <code>cx-api</code> library on
     * disk are seen as independent, completely different libraries. As a
     * consequence, the class <code>AssetManifestArtifact</code> in each copy of the <code>cx-api</code> library
     * is seen as a different class, and an instance of one class will not test as
     * <code>instanceof</code> the other class. <code>npm install</code> will not create installations
     * like this, but users may manually symlink construct libraries together or
     * use a monorepo tool: in those cases, multiple copies of the <code>cx-api</code>
     * library can be accidentally installed, and <code>instanceof</code> will behave
     * unpredictably. It is safest to avoid using <code>instanceof</code>, and using
     * this type-testing method instead.
     * <p>
     * @param art This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isAssetManifestArtifact(final @org.jetbrains.annotations.NotNull java.lang.Object art) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.cxapi.AssetManifestArtifact.class, "isAssetManifestArtifact", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { art });
    }

    /**
     * The Asset Manifest contents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.AssetManifest getContents() {
        return software.amazon.jsii.Kernel.get(this, "contents", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.AssetManifest.class));
    }

    /**
     * The file name of the asset manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFile() {
        return software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of SSM parameter with bootstrap stack version.
     * <p>
     * Default: - Discover SSM parameter by reading stack
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBootstrapStackVersionSsmParameter() {
        return software.amazon.jsii.Kernel.get(this, "bootstrapStackVersionSsmParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Version of bootstrap stack required to deploy this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRequiresBootstrapStackVersion() {
        return software.amazon.jsii.Kernel.get(this, "requiresBootstrapStackVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.cxapi.AssetManifestArtifact}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.cxapi.AssetManifestArtifact> {
        /**
         * @return a new instance of {@link Builder}.
         * @param assembly This parameter is required.
         * @param name This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.cxapi.CloudAssembly assembly, final java.lang.String name) {
            return new Builder(assembly, name);
        }

        private final software.amazon.awscdk.cxapi.CloudAssembly assembly;
        private final java.lang.String name;
        private final software.amazon.awscdk.cloud_assembly_schema.ArtifactManifest.Builder artifact;

        private Builder(final software.amazon.awscdk.cxapi.CloudAssembly assembly, final java.lang.String name) {
            this.assembly = assembly;
            this.name = name;
            this.artifact = new software.amazon.awscdk.cloud_assembly_schema.ArtifactManifest.Builder();
        }

        /**
         * The type of artifact.
         * <p>
         * @return {@code this}
         * @param type The type of artifact. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final software.amazon.awscdk.cloud_assembly_schema.ArtifactType type) {
            this.artifact.type(type);
            return this;
        }

        /**
         * IDs of artifacts that must be deployed before this artifact.
         * <p>
         * Default: - no dependencies.
         * <p>
         * @return {@code this}
         * @param dependencies IDs of artifacts that must be deployed before this artifact. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dependencies(final java.util.List<java.lang.String> dependencies) {
            this.artifact.dependencies(dependencies);
            return this;
        }

        /**
         * A string that can be shown to a user to uniquely identify this artifact inside a cloud assembly tree.
         * <p>
         * Is used by the CLI to present a list of stacks to the user in a way that
         * makes sense to them. Even though the property name "display name" doesn't
         * imply it, this field is used to select stacks as well, so all stacks should
         * have a unique display name.
         * <p>
         * Default: - no display name
         * <p>
         * @return {@code this}
         * @param displayName A string that can be shown to a user to uniquely identify this artifact inside a cloud assembly tree. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.artifact.displayName(displayName);
            return this;
        }

        /**
         * The environment into which this artifact is deployed.
         * <p>
         * Default: - no envrionment.
         * <p>
         * @return {@code this}
         * @param environment The environment into which this artifact is deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final java.lang.String environment) {
            this.artifact.environment(environment);
            return this;
        }

        /**
         * Associated metadata.
         * <p>
         * Default: - no metadata.
         * <p>
         * @return {@code this}
         * @param metadata Associated metadata. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final java.util.Map<java.lang.String, ? extends java.util.List<? extends software.amazon.awscdk.cloud_assembly_schema.MetadataEntry>> metadata) {
            this.artifact.metadata(metadata);
            return this;
        }

        /**
         * The set of properties for this artifact (depends on type).
         * <p>
         * Default: - no properties.
         * <p>
         * @return {@code this}
         * @param properties The set of properties for this artifact (depends on type). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(final software.amazon.awscdk.cloud_assembly_schema.AwsCloudFormationStackProperties properties) {
            this.artifact.properties(properties);
            return this;
        }
        /**
         * The set of properties for this artifact (depends on type).
         * <p>
         * Default: - no properties.
         * <p>
         * @return {@code this}
         * @param properties The set of properties for this artifact (depends on type). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(final software.amazon.awscdk.cloud_assembly_schema.AssetManifestProperties properties) {
            this.artifact.properties(properties);
            return this;
        }
        /**
         * The set of properties for this artifact (depends on type).
         * <p>
         * Default: - no properties.
         * <p>
         * @return {@code this}
         * @param properties The set of properties for this artifact (depends on type). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(final software.amazon.awscdk.cloud_assembly_schema.TreeArtifactProperties properties) {
            this.artifact.properties(properties);
            return this;
        }
        /**
         * The set of properties for this artifact (depends on type).
         * <p>
         * Default: - no properties.
         * <p>
         * @return {@code this}
         * @param properties The set of properties for this artifact (depends on type). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(final software.amazon.awscdk.cloud_assembly_schema.NestedCloudAssemblyProperties properties) {
            this.artifact.properties(properties);
            return this;
        }
        /**
         * The set of properties for this artifact (depends on type).
         * <p>
         * Default: - no properties.
         * <p>
         * @return {@code this}
         * @param properties The set of properties for this artifact (depends on type). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(final software.amazon.awscdk.cloud_assembly_schema.FeatureFlagReportProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.cxapi.AssetManifestArtifact}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.cxapi.AssetManifestArtifact build() {
            return new software.amazon.awscdk.cxapi.AssetManifestArtifact(
                this.assembly,
                this.name,
                this.artifact.build()
            );
        }
    }
}
