package software.amazon.awscdk.cxapi;

/**
 * Construction properties for CloudAssemblyBuilder.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cxapi.*;
 * CloudAssemblyBuilder cloudAssemblyBuilder;
 * CloudAssemblyBuilderProps cloudAssemblyBuilderProps = CloudAssemblyBuilderProps.builder()
 *         .assetOutdir("assetOutdir")
 *         .parentBuilder(cloudAssemblyBuilder)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:26.047Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cx_api.CloudAssemblyBuilderProps")
@software.amazon.jsii.Jsii.Proxy(CloudAssemblyBuilderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CloudAssemblyBuilderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Use the given asset output directory.
     * <p>
     * Default: - Same as the manifest outdir
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssetOutdir() {
        return null;
    }

    /**
     * If this builder is for a nested assembly, the parent assembly builder.
     * <p>
     * Default: - This is a root assembly
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.cxapi.CloudAssemblyBuilder getParentBuilder() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CloudAssemblyBuilderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudAssemblyBuilderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CloudAssemblyBuilderProps> {
        java.lang.String assetOutdir;
        software.amazon.awscdk.cxapi.CloudAssemblyBuilder parentBuilder;

        /**
         * Sets the value of {@link CloudAssemblyBuilderProps#getAssetOutdir}
         * @param assetOutdir Use the given asset output directory.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetOutdir(java.lang.String assetOutdir) {
            this.assetOutdir = assetOutdir;
            return this;
        }

        /**
         * Sets the value of {@link CloudAssemblyBuilderProps#getParentBuilder}
         * @param parentBuilder If this builder is for a nested assembly, the parent assembly builder.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parentBuilder(software.amazon.awscdk.cxapi.CloudAssemblyBuilder parentBuilder) {
            this.parentBuilder = parentBuilder;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudAssemblyBuilderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CloudAssemblyBuilderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudAssemblyBuilderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudAssemblyBuilderProps {
        private final java.lang.String assetOutdir;
        private final software.amazon.awscdk.cxapi.CloudAssemblyBuilder parentBuilder;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assetOutdir = software.amazon.jsii.Kernel.get(this, "assetOutdir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parentBuilder = software.amazon.jsii.Kernel.get(this, "parentBuilder", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudAssemblyBuilder.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assetOutdir = builder.assetOutdir;
            this.parentBuilder = builder.parentBuilder;
        }

        @Override
        public final java.lang.String getAssetOutdir() {
            return this.assetOutdir;
        }

        @Override
        public final software.amazon.awscdk.cxapi.CloudAssemblyBuilder getParentBuilder() {
            return this.parentBuilder;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssetOutdir() != null) {
                data.set("assetOutdir", om.valueToTree(this.getAssetOutdir()));
            }
            if (this.getParentBuilder() != null) {
                data.set("parentBuilder", om.valueToTree(this.getParentBuilder()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cx_api.CloudAssemblyBuilderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudAssemblyBuilderProps.Jsii$Proxy that = (CloudAssemblyBuilderProps.Jsii$Proxy) o;

            if (this.assetOutdir != null ? !this.assetOutdir.equals(that.assetOutdir) : that.assetOutdir != null) return false;
            return this.parentBuilder != null ? this.parentBuilder.equals(that.parentBuilder) : that.parentBuilder == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assetOutdir != null ? this.assetOutdir.hashCode() : 0;
            result = 31 * result + (this.parentBuilder != null ? this.parentBuilder.hashCode() : 0);
            return result;
        }
    }
}
