package software.amazon.awscdk.pipelines;

/**
 * Options for ECR sources.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IRepository repository;
 * CodePipelineSource.ecr(repository, ECRSourceOptions.builder()
 *         .imageTag("latest")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:26.112Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.ECRSourceOptions")
@software.amazon.jsii.Jsii.Proxy(ECRSourceOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ECRSourceOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The action name used for this source in the CodePipeline.
     * <p>
     * Default: - The repository name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getActionName() {
        return null;
    }

    /**
     * The image tag that will be checked for changes.
     * <p>
     * Default: latest
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageTag() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ECRSourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ECRSourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ECRSourceOptions> {
        java.lang.String actionName;
        java.lang.String imageTag;

        /**
         * Sets the value of {@link ECRSourceOptions#getActionName}
         * @param actionName The action name used for this source in the CodePipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link ECRSourceOptions#getImageTag}
         * @param imageTag The image tag that will be checked for changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTag(java.lang.String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ECRSourceOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ECRSourceOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ECRSourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ECRSourceOptions {
        private final java.lang.String actionName;
        private final java.lang.String imageTag;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageTag = software.amazon.jsii.Kernel.get(this, "imageTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actionName = builder.actionName;
            this.imageTag = builder.imageTag;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.String getImageTag() {
            return this.imageTag;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getActionName() != null) {
                data.set("actionName", om.valueToTree(this.getActionName()));
            }
            if (this.getImageTag() != null) {
                data.set("imageTag", om.valueToTree(this.getImageTag()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.ECRSourceOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ECRSourceOptions.Jsii$Proxy that = (ECRSourceOptions.Jsii$Proxy) o;

            if (this.actionName != null ? !this.actionName.equals(that.actionName) : that.actionName != null) return false;
            return this.imageTag != null ? this.imageTag.equals(that.imageTag) : that.imageTag == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actionName != null ? this.actionName.hashCode() : 0;
            result = 31 * result + (this.imageTag != null ? this.imageTag.hashCode() : 0);
            return result;
        }
    }
}
