package software.amazon.awscdk.services.amplify;

/**
 * Properties for defining a <code>CfnApp</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amplify.*;
 * CfnAppProps cfnAppProps = CfnAppProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .accessToken("accessToken")
 *         .autoBranchCreationConfig(AutoBranchCreationConfigProperty.builder()
 *                 .autoBranchCreationPatterns(List.of("autoBranchCreationPatterns"))
 *                 .basicAuthConfig(BasicAuthConfigProperty.builder()
 *                         .enableBasicAuth(false)
 *                         .password("password")
 *                         .username("username")
 *                         .build())
 *                 .buildSpec("buildSpec")
 *                 .enableAutoBranchCreation(false)
 *                 .enableAutoBuild(false)
 *                 .enablePerformanceMode(false)
 *                 .enablePullRequestPreview(false)
 *                 .environmentVariables(List.of(EnvironmentVariableProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .framework("framework")
 *                 .pullRequestEnvironmentName("pullRequestEnvironmentName")
 *                 .stage("stage")
 *                 .build())
 *         .basicAuthConfig(BasicAuthConfigProperty.builder()
 *                 .enableBasicAuth(false)
 *                 .password("password")
 *                 .username("username")
 *                 .build())
 *         .buildSpec("buildSpec")
 *         .cacheConfig(CacheConfigProperty.builder()
 *                 .type("type")
 *                 .build())
 *         .computeRoleArn("computeRoleArn")
 *         .customHeaders("customHeaders")
 *         .customRules(List.of(CustomRuleProperty.builder()
 *                 .source("source")
 *                 .target("target")
 *                 // the properties below are optional
 *                 .condition("condition")
 *                 .status("status")
 *                 .build()))
 *         .description("description")
 *         .enableBranchAutoDeletion(false)
 *         .environmentVariables(List.of(EnvironmentVariableProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .iamServiceRole("iamServiceRole")
 *         .jobConfig(JobConfigProperty.builder()
 *                 .buildComputeType("buildComputeType")
 *                 .build())
 *         .oauthToken("oauthToken")
 *         .platform("platform")
 *         .repository("repository")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:09.181Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplify.CfnAppProps")
@software.amazon.jsii.Jsii.Proxy(CfnAppProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAppProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Amplify app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The personal access token for a GitHub repository for an Amplify app.
     * <p>
     * The personal access token is used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.
     * <p>
     * Use <code>AccessToken</code> for GitHub repositories only. To authorize access to a repository provider such as Bitbucket or CodeCommit, use <code>OauthToken</code> .
     * <p>
     * You must specify either <code>AccessToken</code> or <code>OauthToken</code> when you create a new app.
     * <p>
     * Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <em>Amplify User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-accesstoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-accesstoken</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
        return null;
    }

    /**
     * Sets the configuration for your automatic branch creation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-autobranchcreationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-autobranchcreationconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoBranchCreationConfig() {
        return null;
    }

    /**
     * The credentials for basic authorization for an Amplify app.
     * <p>
     * You must base64-encode the authorization credentials and provide them in the format <code>user:password</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-basicauthconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-basicauthconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBasicAuthConfig() {
        return null;
    }

    /**
     * The build specification (build spec) for an Amplify app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-buildspec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-buildspec</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBuildSpec() {
        return null;
    }

    /**
     * The cache configuration for the Amplify app.
     * <p>
     * If you don't specify the cache configuration <code>type</code> , Amplify uses the default <code>AMPLIFY_MANAGED</code> setting.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-cacheconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-cacheconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCacheConfig() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role for an SSR app.
     * <p>
     * The Compute role allows the Amplify Hosting compute service to securely access specific AWS resources based on the role's permissions. For more information about the SSR Compute role, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html">Adding an SSR Compute role</a> in the <em>Amplify User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-computerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-computerolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComputeRoleArn() {
        return null;
    }

    /**
     * The custom HTTP headers for an Amplify app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customheaders</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomHeaders() {
        return null;
    }

    /**
     * The custom rewrite and redirect rules for an Amplify app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customrules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomRules() {
        return null;
    }

    /**
     * The description of the Amplify app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Automatically disconnect a branch in Amplify Hosting when you delete a branch from your Git repository.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-enablebranchautodeletion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-enablebranchautodeletion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableBranchAutoDeletion() {
        return null;
    }

    /**
     * The environment variables for the Amplify app.
     * <p>
     * For a list of the environment variables that are accessible to Amplify by default, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html">Amplify Environment variables</a> in the <em>Amplify Hosting User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-environmentvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-environmentvariables</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentVariables() {
        return null;
    }

    /**
     * AWS Identity and Access Management ( IAM ) service role for the Amazon Resource Name (ARN) of the Amplify app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-iamservicerole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-iamservicerole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIamServiceRole() {
        return null;
    }

    /**
     * The configuration details that apply to the jobs for an Amplify app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-jobconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-jobconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getJobConfig() {
        return null;
    }

    /**
     * The OAuth token for a third-party source control system for an Amplify app.
     * <p>
     * The OAuth token is used to create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.
     * <p>
     * Use <code>OauthToken</code> for repository providers other than GitHub, such as Bitbucket or CodeCommit. To authorize access to GitHub as your repository provider, use <code>AccessToken</code> .
     * <p>
     * You must specify either <code>OauthToken</code> or <code>AccessToken</code> when you create a new app.
     * <p>
     * Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <em>Amplify User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-oauthtoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-oauthtoken</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOauthToken() {
        return null;
    }

    /**
     * The platform for the Amplify app.
     * <p>
     * For a static app, set the platform type to <code>WEB</code> . For a dynamic server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code> . For an app requiring Amplify Hosting's original SSR support only, set the platform type to <code>WEB_DYNAMIC</code> .
     * <p>
     * If you are deploying an SSG only app with Next.js version 14 or later, you must set the platform type to <code>WEB_COMPUTE</code> and set the artifacts <code>baseDirectory</code> to <code>.next</code> in the application's build settings. For an example of the build specification settings, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/deploy-nextjs-app.html#build-setting-detection-ssg-14">Amplify build settings for a Next.js 14 SSG application</a> in the <em>Amplify Hosting User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-platform">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-platform</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPlatform() {
        return null;
    }

    /**
     * The Git repository for the Amplify app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-repository">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-repository</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRepository() {
        return null;
    }

    /**
     * The tag for an Amplify app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAppProps> {
        java.lang.String name;
        java.lang.String accessToken;
        java.lang.Object autoBranchCreationConfig;
        java.lang.Object basicAuthConfig;
        java.lang.String buildSpec;
        java.lang.Object cacheConfig;
        java.lang.String computeRoleArn;
        java.lang.String customHeaders;
        java.lang.Object customRules;
        java.lang.String description;
        java.lang.Object enableBranchAutoDeletion;
        java.lang.Object environmentVariables;
        java.lang.String iamServiceRole;
        java.lang.Object jobConfig;
        java.lang.String oauthToken;
        java.lang.String platform;
        java.lang.String repository;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAppProps#getName}
         * @param name The name of the Amplify app. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getAccessToken}
         * @param accessToken The personal access token for a GitHub repository for an Amplify app.
         *                    The personal access token is used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.
         *                    <p>
         *                    Use <code>AccessToken</code> for GitHub repositories only. To authorize access to a repository provider such as Bitbucket or CodeCommit, use <code>OauthToken</code> .
         *                    <p>
         *                    You must specify either <code>AccessToken</code> or <code>OauthToken</code> when you create a new app.
         *                    <p>
         *                    Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <em>Amplify User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessToken(java.lang.String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getAutoBranchCreationConfig}
         * @param autoBranchCreationConfig Sets the configuration for your automatic branch creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoBranchCreationConfig(software.amazon.awscdk.IResolvable autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getAutoBranchCreationConfig}
         * @param autoBranchCreationConfig Sets the configuration for your automatic branch creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoBranchCreationConfig(software.amazon.awscdk.services.amplify.CfnApp.AutoBranchCreationConfigProperty autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getBasicAuthConfig}
         * @param basicAuthConfig The credentials for basic authorization for an Amplify app.
         *                        You must base64-encode the authorization credentials and provide them in the format <code>user:password</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder basicAuthConfig(software.amazon.awscdk.IResolvable basicAuthConfig) {
            this.basicAuthConfig = basicAuthConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getBasicAuthConfig}
         * @param basicAuthConfig The credentials for basic authorization for an Amplify app.
         *                        You must base64-encode the authorization credentials and provide them in the format <code>user:password</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder basicAuthConfig(software.amazon.awscdk.services.amplify.CfnApp.BasicAuthConfigProperty basicAuthConfig) {
            this.basicAuthConfig = basicAuthConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getBuildSpec}
         * @param buildSpec The build specification (build spec) for an Amplify app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildSpec(java.lang.String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getCacheConfig}
         * @param cacheConfig The cache configuration for the Amplify app.
         *                    If you don't specify the cache configuration <code>type</code> , Amplify uses the default <code>AMPLIFY_MANAGED</code> setting.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheConfig(software.amazon.awscdk.IResolvable cacheConfig) {
            this.cacheConfig = cacheConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getCacheConfig}
         * @param cacheConfig The cache configuration for the Amplify app.
         *                    If you don't specify the cache configuration <code>type</code> , Amplify uses the default <code>AMPLIFY_MANAGED</code> setting.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheConfig(software.amazon.awscdk.services.amplify.CfnApp.CacheConfigProperty cacheConfig) {
            this.cacheConfig = cacheConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getComputeRoleArn}
         * @param computeRoleArn The Amazon Resource Name (ARN) of the IAM role for an SSR app.
         *                       The Compute role allows the Amplify Hosting compute service to securely access specific AWS resources based on the role's permissions. For more information about the SSR Compute role, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html">Adding an SSR Compute role</a> in the <em>Amplify User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeRoleArn(java.lang.String computeRoleArn) {
            this.computeRoleArn = computeRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getCustomHeaders}
         * @param customHeaders The custom HTTP headers for an Amplify app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customHeaders(java.lang.String customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getCustomRules}
         * @param customRules The custom rewrite and redirect rules for an Amplify app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customRules(software.amazon.awscdk.IResolvable customRules) {
            this.customRules = customRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getCustomRules}
         * @param customRules The custom rewrite and redirect rules for an Amplify app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customRules(java.util.List<? extends java.lang.Object> customRules) {
            this.customRules = customRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getDescription}
         * @param description The description of the Amplify app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getEnableBranchAutoDeletion}
         * @param enableBranchAutoDeletion Automatically disconnect a branch in Amplify Hosting when you delete a branch from your Git repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableBranchAutoDeletion(java.lang.Boolean enableBranchAutoDeletion) {
            this.enableBranchAutoDeletion = enableBranchAutoDeletion;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getEnableBranchAutoDeletion}
         * @param enableBranchAutoDeletion Automatically disconnect a branch in Amplify Hosting when you delete a branch from your Git repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableBranchAutoDeletion(software.amazon.awscdk.IResolvable enableBranchAutoDeletion) {
            this.enableBranchAutoDeletion = enableBranchAutoDeletion;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getEnvironmentVariables}
         * @param environmentVariables The environment variables for the Amplify app.
         *                             For a list of the environment variables that are accessible to Amplify by default, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html">Amplify Environment variables</a> in the <em>Amplify Hosting User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(software.amazon.awscdk.IResolvable environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getEnvironmentVariables}
         * @param environmentVariables The environment variables for the Amplify app.
         *                             For a list of the environment variables that are accessible to Amplify by default, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html">Amplify Environment variables</a> in the <em>Amplify Hosting User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(java.util.List<? extends java.lang.Object> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getIamServiceRole}
         * @param iamServiceRole AWS Identity and Access Management ( IAM ) service role for the Amazon Resource Name (ARN) of the Amplify app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamServiceRole(java.lang.String iamServiceRole) {
            this.iamServiceRole = iamServiceRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getJobConfig}
         * @param jobConfig The configuration details that apply to the jobs for an Amplify app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobConfig(software.amazon.awscdk.IResolvable jobConfig) {
            this.jobConfig = jobConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getJobConfig}
         * @param jobConfig The configuration details that apply to the jobs for an Amplify app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobConfig(software.amazon.awscdk.services.amplify.CfnApp.JobConfigProperty jobConfig) {
            this.jobConfig = jobConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getOauthToken}
         * @param oauthToken The OAuth token for a third-party source control system for an Amplify app.
         *                   The OAuth token is used to create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.
         *                   <p>
         *                   Use <code>OauthToken</code> for repository providers other than GitHub, such as Bitbucket or CodeCommit. To authorize access to GitHub as your repository provider, use <code>AccessToken</code> .
         *                   <p>
         *                   You must specify either <code>OauthToken</code> or <code>AccessToken</code> when you create a new app.
         *                   <p>
         *                   Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/setting-up-GitHub-access.html#migrating-to-github-app-auth">Migrating an existing OAuth app to the Amplify GitHub App</a> in the <em>Amplify User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oauthToken(java.lang.String oauthToken) {
            this.oauthToken = oauthToken;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getPlatform}
         * @param platform The platform for the Amplify app.
         *                 For a static app, set the platform type to <code>WEB</code> . For a dynamic server-side rendered (SSR) app, set the platform type to <code>WEB_COMPUTE</code> . For an app requiring Amplify Hosting's original SSR support only, set the platform type to <code>WEB_DYNAMIC</code> .
         *                 <p>
         *                 If you are deploying an SSG only app with Next.js version 14 or later, you must set the platform type to <code>WEB_COMPUTE</code> and set the artifacts <code>baseDirectory</code> to <code>.next</code> in the application's build settings. For an example of the build specification settings, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/deploy-nextjs-app.html#build-setting-detection-ssg-14">Amplify build settings for a Next.js 14 SSG application</a> in the <em>Amplify Hosting User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platform(java.lang.String platform) {
            this.platform = platform;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getRepository}
         * @param repository The Git repository for the Amplify app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repository(java.lang.String repository) {
            this.repository = repository;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppProps#getTags}
         * @param tags The tag for an Amplify app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAppProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAppProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAppProps {
        private final java.lang.String name;
        private final java.lang.String accessToken;
        private final java.lang.Object autoBranchCreationConfig;
        private final java.lang.Object basicAuthConfig;
        private final java.lang.String buildSpec;
        private final java.lang.Object cacheConfig;
        private final java.lang.String computeRoleArn;
        private final java.lang.String customHeaders;
        private final java.lang.Object customRules;
        private final java.lang.String description;
        private final java.lang.Object enableBranchAutoDeletion;
        private final java.lang.Object environmentVariables;
        private final java.lang.String iamServiceRole;
        private final java.lang.Object jobConfig;
        private final java.lang.String oauthToken;
        private final java.lang.String platform;
        private final java.lang.String repository;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoBranchCreationConfig = software.amazon.jsii.Kernel.get(this, "autoBranchCreationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.basicAuthConfig = software.amazon.jsii.Kernel.get(this, "basicAuthConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.buildSpec = software.amazon.jsii.Kernel.get(this, "buildSpec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cacheConfig = software.amazon.jsii.Kernel.get(this, "cacheConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.computeRoleArn = software.amazon.jsii.Kernel.get(this, "computeRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customHeaders = software.amazon.jsii.Kernel.get(this, "customHeaders", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customRules = software.amazon.jsii.Kernel.get(this, "customRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableBranchAutoDeletion = software.amazon.jsii.Kernel.get(this, "enableBranchAutoDeletion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.iamServiceRole = software.amazon.jsii.Kernel.get(this, "iamServiceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobConfig = software.amazon.jsii.Kernel.get(this, "jobConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.oauthToken = software.amazon.jsii.Kernel.get(this, "oauthToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.platform = software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repository = software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.accessToken = builder.accessToken;
            this.autoBranchCreationConfig = builder.autoBranchCreationConfig;
            this.basicAuthConfig = builder.basicAuthConfig;
            this.buildSpec = builder.buildSpec;
            this.cacheConfig = builder.cacheConfig;
            this.computeRoleArn = builder.computeRoleArn;
            this.customHeaders = builder.customHeaders;
            this.customRules = builder.customRules;
            this.description = builder.description;
            this.enableBranchAutoDeletion = builder.enableBranchAutoDeletion;
            this.environmentVariables = builder.environmentVariables;
            this.iamServiceRole = builder.iamServiceRole;
            this.jobConfig = builder.jobConfig;
            this.oauthToken = builder.oauthToken;
            this.platform = builder.platform;
            this.repository = builder.repository;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final java.lang.Object getAutoBranchCreationConfig() {
            return this.autoBranchCreationConfig;
        }

        @Override
        public final java.lang.Object getBasicAuthConfig() {
            return this.basicAuthConfig;
        }

        @Override
        public final java.lang.String getBuildSpec() {
            return this.buildSpec;
        }

        @Override
        public final java.lang.Object getCacheConfig() {
            return this.cacheConfig;
        }

        @Override
        public final java.lang.String getComputeRoleArn() {
            return this.computeRoleArn;
        }

        @Override
        public final java.lang.String getCustomHeaders() {
            return this.customHeaders;
        }

        @Override
        public final java.lang.Object getCustomRules() {
            return this.customRules;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEnableBranchAutoDeletion() {
            return this.enableBranchAutoDeletion;
        }

        @Override
        public final java.lang.Object getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final java.lang.String getIamServiceRole() {
            return this.iamServiceRole;
        }

        @Override
        public final java.lang.Object getJobConfig() {
            return this.jobConfig;
        }

        @Override
        public final java.lang.String getOauthToken() {
            return this.oauthToken;
        }

        @Override
        public final java.lang.String getPlatform() {
            return this.platform;
        }

        @Override
        public final java.lang.String getRepository() {
            return this.repository;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getAccessToken() != null) {
                data.set("accessToken", om.valueToTree(this.getAccessToken()));
            }
            if (this.getAutoBranchCreationConfig() != null) {
                data.set("autoBranchCreationConfig", om.valueToTree(this.getAutoBranchCreationConfig()));
            }
            if (this.getBasicAuthConfig() != null) {
                data.set("basicAuthConfig", om.valueToTree(this.getBasicAuthConfig()));
            }
            if (this.getBuildSpec() != null) {
                data.set("buildSpec", om.valueToTree(this.getBuildSpec()));
            }
            if (this.getCacheConfig() != null) {
                data.set("cacheConfig", om.valueToTree(this.getCacheConfig()));
            }
            if (this.getComputeRoleArn() != null) {
                data.set("computeRoleArn", om.valueToTree(this.getComputeRoleArn()));
            }
            if (this.getCustomHeaders() != null) {
                data.set("customHeaders", om.valueToTree(this.getCustomHeaders()));
            }
            if (this.getCustomRules() != null) {
                data.set("customRules", om.valueToTree(this.getCustomRules()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnableBranchAutoDeletion() != null) {
                data.set("enableBranchAutoDeletion", om.valueToTree(this.getEnableBranchAutoDeletion()));
            }
            if (this.getEnvironmentVariables() != null) {
                data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
            }
            if (this.getIamServiceRole() != null) {
                data.set("iamServiceRole", om.valueToTree(this.getIamServiceRole()));
            }
            if (this.getJobConfig() != null) {
                data.set("jobConfig", om.valueToTree(this.getJobConfig()));
            }
            if (this.getOauthToken() != null) {
                data.set("oauthToken", om.valueToTree(this.getOauthToken()));
            }
            if (this.getPlatform() != null) {
                data.set("platform", om.valueToTree(this.getPlatform()));
            }
            if (this.getRepository() != null) {
                data.set("repository", om.valueToTree(this.getRepository()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplify.CfnAppProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAppProps.Jsii$Proxy that = (CfnAppProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
            if (this.autoBranchCreationConfig != null ? !this.autoBranchCreationConfig.equals(that.autoBranchCreationConfig) : that.autoBranchCreationConfig != null) return false;
            if (this.basicAuthConfig != null ? !this.basicAuthConfig.equals(that.basicAuthConfig) : that.basicAuthConfig != null) return false;
            if (this.buildSpec != null ? !this.buildSpec.equals(that.buildSpec) : that.buildSpec != null) return false;
            if (this.cacheConfig != null ? !this.cacheConfig.equals(that.cacheConfig) : that.cacheConfig != null) return false;
            if (this.computeRoleArn != null ? !this.computeRoleArn.equals(that.computeRoleArn) : that.computeRoleArn != null) return false;
            if (this.customHeaders != null ? !this.customHeaders.equals(that.customHeaders) : that.customHeaders != null) return false;
            if (this.customRules != null ? !this.customRules.equals(that.customRules) : that.customRules != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enableBranchAutoDeletion != null ? !this.enableBranchAutoDeletion.equals(that.enableBranchAutoDeletion) : that.enableBranchAutoDeletion != null) return false;
            if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
            if (this.iamServiceRole != null ? !this.iamServiceRole.equals(that.iamServiceRole) : that.iamServiceRole != null) return false;
            if (this.jobConfig != null ? !this.jobConfig.equals(that.jobConfig) : that.jobConfig != null) return false;
            if (this.oauthToken != null ? !this.oauthToken.equals(that.oauthToken) : that.oauthToken != null) return false;
            if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) return false;
            if (this.repository != null ? !this.repository.equals(that.repository) : that.repository != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
            result = 31 * result + (this.autoBranchCreationConfig != null ? this.autoBranchCreationConfig.hashCode() : 0);
            result = 31 * result + (this.basicAuthConfig != null ? this.basicAuthConfig.hashCode() : 0);
            result = 31 * result + (this.buildSpec != null ? this.buildSpec.hashCode() : 0);
            result = 31 * result + (this.cacheConfig != null ? this.cacheConfig.hashCode() : 0);
            result = 31 * result + (this.computeRoleArn != null ? this.computeRoleArn.hashCode() : 0);
            result = 31 * result + (this.customHeaders != null ? this.customHeaders.hashCode() : 0);
            result = 31 * result + (this.customRules != null ? this.customRules.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enableBranchAutoDeletion != null ? this.enableBranchAutoDeletion.hashCode() : 0);
            result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
            result = 31 * result + (this.iamServiceRole != null ? this.iamServiceRole.hashCode() : 0);
            result = 31 * result + (this.jobConfig != null ? this.jobConfig.hashCode() : 0);
            result = 31 * result + (this.oauthToken != null ? this.oauthToken.hashCode() : 0);
            result = 31 * result + (this.platform != null ? this.platform.hashCode() : 0);
            result = 31 * result + (this.repository != null ? this.repository.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
