package software.amazon.awscdk.services.amplifyuibuilder;

/**
 * Properties for defining a <code>CfnForm</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amplifyuibuilder.*;
 * FormInputValuePropertyProperty formInputValuePropertyProperty_;
 * CfnFormProps cfnFormProps = CfnFormProps.builder()
 *         .appId("appId")
 *         .cta(FormCTAProperty.builder()
 *                 .cancel(FormButtonProperty.builder()
 *                         .children("children")
 *                         .excluded(false)
 *                         .position(FieldPositionProperty.builder()
 *                                 .below("below")
 *                                 .fixed("fixed")
 *                                 .rightOf("rightOf")
 *                                 .build())
 *                         .build())
 *                 .clear(FormButtonProperty.builder()
 *                         .children("children")
 *                         .excluded(false)
 *                         .position(FieldPositionProperty.builder()
 *                                 .below("below")
 *                                 .fixed("fixed")
 *                                 .rightOf("rightOf")
 *                                 .build())
 *                         .build())
 *                 .position("position")
 *                 .submit(FormButtonProperty.builder()
 *                         .children("children")
 *                         .excluded(false)
 *                         .position(FieldPositionProperty.builder()
 *                                 .below("below")
 *                                 .fixed("fixed")
 *                                 .rightOf("rightOf")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .dataType(FormDataTypeConfigProperty.builder()
 *                 .dataSourceType("dataSourceType")
 *                 .dataTypeName("dataTypeName")
 *                 .build())
 *         .environmentName("environmentName")
 *         .fields(Map.of(
 *                 "fieldsKey", FieldConfigProperty.builder()
 *                         .excluded(false)
 *                         .inputType(FieldInputConfigProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .defaultChecked(false)
 *                                 .defaultCountryCode("defaultCountryCode")
 *                                 .defaultValue("defaultValue")
 *                                 .descriptiveText("descriptiveText")
 *                                 .fileUploaderConfig(FileUploaderFieldConfigProperty.builder()
 *                                         .acceptedFileTypes(List.of("acceptedFileTypes"))
 *                                         .accessLevel("accessLevel")
 *                                         // the properties below are optional
 *                                         .isResumable(false)
 *                                         .maxFileCount(123)
 *                                         .maxSize(123)
 *                                         .showThumbnails(false)
 *                                         .build())
 *                                 .isArray(false)
 *                                 .maxValue(123)
 *                                 .minValue(123)
 *                                 .name("name")
 *                                 .placeholder("placeholder")
 *                                 .readOnly(false)
 *                                 .required(false)
 *                                 .step(123)
 *                                 .value("value")
 *                                 .valueMappings(ValueMappingsProperty.builder()
 *                                         .values(List.of(ValueMappingProperty.builder()
 *                                                 .value(FormInputValuePropertyProperty.builder()
 *                                                         .bindingProperties(FormInputValuePropertyBindingPropertiesProperty.builder()
 *                                                                 .property("property")
 *                                                                 // the properties below are optional
 *                                                                 .field("field")
 *                                                                 .build())
 *                                                         .concat(List.of(formInputValuePropertyProperty_))
 *                                                         .value("value")
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .displayValue(FormInputValuePropertyProperty.builder()
 *                                                         .bindingProperties(FormInputValuePropertyBindingPropertiesProperty.builder()
 *                                                                 .property("property")
 *                                                                 // the properties below are optional
 *                                                                 .field("field")
 *                                                                 .build())
 *                                                         .concat(List.of(formInputValuePropertyProperty_))
 *                                                         .value("value")
 *                                                         .build())
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .bindingProperties(Map.of(
 *                                                 "bindingPropertiesKey", FormInputBindingPropertiesValueProperty.builder()
 *                                                         .bindingProperties(FormInputBindingPropertiesValuePropertiesProperty.builder()
 *                                                                 .model("model")
 *                                                                 .build())
 *                                                         .type("type")
 *                                                         .build()))
 *                                         .build())
 *                                 .build())
 *                         .label("label")
 *                         .position(FieldPositionProperty.builder()
 *                                 .below("below")
 *                                 .fixed("fixed")
 *                                 .rightOf("rightOf")
 *                                 .build())
 *                         .validations(List.of(FieldValidationConfigurationProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .numValues(List.of(123))
 *                                 .strValues(List.of("strValues"))
 *                                 .validationMessage("validationMessage")
 *                                 .build()))
 *                         .build()))
 *         .formActionType("formActionType")
 *         .labelDecorator("labelDecorator")
 *         .name("name")
 *         .schemaVersion("schemaVersion")
 *         .sectionalElements(Map.of(
 *                 "sectionalElementsKey", SectionalElementProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .excluded(false)
 *                         .level(123)
 *                         .orientation("orientation")
 *                         .position(FieldPositionProperty.builder()
 *                                 .below("below")
 *                                 .fixed("fixed")
 *                                 .rightOf("rightOf")
 *                                 .build())
 *                         .text("text")
 *                         .build()))
 *         .style(FormStyleProperty.builder()
 *                 .horizontalGap(FormStyleConfigProperty.builder()
 *                         .tokenReference("tokenReference")
 *                         .value("value")
 *                         .build())
 *                 .outerPadding(FormStyleConfigProperty.builder()
 *                         .tokenReference("tokenReference")
 *                         .value("value")
 *                         .build())
 *                 .verticalGap(FormStyleConfigProperty.builder()
 *                         .tokenReference("tokenReference")
 *                         .value("value")
 *                         .build())
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:09.251Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnFormProps")
@software.amazon.jsii.Jsii.Proxy(CfnFormProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFormProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique ID of the Amplify app associated with the form.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-appid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-appid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAppId() {
        return null;
    }

    /**
     * The <code>FormCTA</code> object that stores the call to action configuration for the form.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-cta">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-cta</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCta() {
        return null;
    }

    /**
     * The type of data source to use to create the form.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-datatype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-datatype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataType() {
        return null;
    }

    /**
     * The name of the backend environment that is a part of the Amplify app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-environmentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-environmentname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentName() {
        return null;
    }

    /**
     * The configuration information for the form's fields.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-fields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-fields</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFields() {
        return null;
    }

    /**
     * Specifies whether to perform a create or update action on the form.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-formactiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-formactiontype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFormActionType() {
        return null;
    }

    /**
     * Specifies an icon or decoration to display on the form.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-labeldecorator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-labeldecorator</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLabelDecorator() {
        return null;
    }

    /**
     * The name of the form.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The schema version of the form.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-schemaversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-schemaversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSchemaVersion() {
        return null;
    }

    /**
     * The configuration information for the visual helper elements for the form.
     * <p>
     * These elements are not associated with any data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-sectionalelements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-sectionalelements</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSectionalElements() {
        return null;
    }

    /**
     * The configuration for the form's style.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-style">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-style</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStyle() {
        return null;
    }

    /**
     * One or more key-value pairs to use when tagging the form data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-form.html#cfn-amplifyuibuilder-form-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFormProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFormProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFormProps> {
        java.lang.String appId;
        java.lang.Object cta;
        java.lang.Object dataType;
        java.lang.String environmentName;
        java.lang.Object fields;
        java.lang.String formActionType;
        java.lang.String labelDecorator;
        java.lang.String name;
        java.lang.String schemaVersion;
        java.lang.Object sectionalElements;
        java.lang.Object style;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnFormProps#getAppId}
         * @param appId The unique ID of the Amplify app associated with the form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appId(java.lang.String appId) {
            this.appId = appId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getCta}
         * @param cta The <code>FormCTA</code> object that stores the call to action configuration for the form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cta(software.amazon.awscdk.IResolvable cta) {
            this.cta = cta;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getCta}
         * @param cta The <code>FormCTA</code> object that stores the call to action configuration for the form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cta(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormCTAProperty cta) {
            this.cta = cta;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getDataType}
         * @param dataType The type of data source to use to create the form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataType(software.amazon.awscdk.IResolvable dataType) {
            this.dataType = dataType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getDataType}
         * @param dataType The type of data source to use to create the form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataType(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormDataTypeConfigProperty dataType) {
            this.dataType = dataType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getEnvironmentName}
         * @param environmentName The name of the backend environment that is a part of the Amplify app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentName(java.lang.String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getFields}
         * @param fields The configuration information for the form's fields.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(software.amazon.awscdk.IResolvable fields) {
            this.fields = fields;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getFields}
         * @param fields The configuration information for the form's fields.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(java.util.Map<java.lang.String, ? extends java.lang.Object> fields) {
            this.fields = fields;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getFormActionType}
         * @param formActionType Specifies whether to perform a create or update action on the form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder formActionType(java.lang.String formActionType) {
            this.formActionType = formActionType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getLabelDecorator}
         * @param labelDecorator Specifies an icon or decoration to display on the form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labelDecorator(java.lang.String labelDecorator) {
            this.labelDecorator = labelDecorator;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getName}
         * @param name The name of the form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getSchemaVersion}
         * @param schemaVersion The schema version of the form.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaVersion(java.lang.String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getSectionalElements}
         * @param sectionalElements The configuration information for the visual helper elements for the form.
         *                          These elements are not associated with any data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sectionalElements(software.amazon.awscdk.IResolvable sectionalElements) {
            this.sectionalElements = sectionalElements;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getSectionalElements}
         * @param sectionalElements The configuration information for the visual helper elements for the form.
         *                          These elements are not associated with any data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sectionalElements(java.util.Map<java.lang.String, ? extends java.lang.Object> sectionalElements) {
            this.sectionalElements = sectionalElements;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getStyle}
         * @param style The configuration for the form's style.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder style(software.amazon.awscdk.IResolvable style) {
            this.style = style;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getStyle}
         * @param style The configuration for the form's style.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder style(software.amazon.awscdk.services.amplifyuibuilder.CfnForm.FormStyleProperty style) {
            this.style = style;
            return this;
        }

        /**
         * Sets the value of {@link CfnFormProps#getTags}
         * @param tags One or more key-value pairs to use when tagging the form data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFormProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFormProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFormProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFormProps {
        private final java.lang.String appId;
        private final java.lang.Object cta;
        private final java.lang.Object dataType;
        private final java.lang.String environmentName;
        private final java.lang.Object fields;
        private final java.lang.String formActionType;
        private final java.lang.String labelDecorator;
        private final java.lang.String name;
        private final java.lang.String schemaVersion;
        private final java.lang.Object sectionalElements;
        private final java.lang.Object style;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appId = software.amazon.jsii.Kernel.get(this, "appId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cta = software.amazon.jsii.Kernel.get(this, "cta", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.environmentName = software.amazon.jsii.Kernel.get(this, "environmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fields = software.amazon.jsii.Kernel.get(this, "fields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.formActionType = software.amazon.jsii.Kernel.get(this, "formActionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.labelDecorator = software.amazon.jsii.Kernel.get(this, "labelDecorator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schemaVersion = software.amazon.jsii.Kernel.get(this, "schemaVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sectionalElements = software.amazon.jsii.Kernel.get(this, "sectionalElements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.style = software.amazon.jsii.Kernel.get(this, "style", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appId = builder.appId;
            this.cta = builder.cta;
            this.dataType = builder.dataType;
            this.environmentName = builder.environmentName;
            this.fields = builder.fields;
            this.formActionType = builder.formActionType;
            this.labelDecorator = builder.labelDecorator;
            this.name = builder.name;
            this.schemaVersion = builder.schemaVersion;
            this.sectionalElements = builder.sectionalElements;
            this.style = builder.style;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getAppId() {
            return this.appId;
        }

        @Override
        public final java.lang.Object getCta() {
            return this.cta;
        }

        @Override
        public final java.lang.Object getDataType() {
            return this.dataType;
        }

        @Override
        public final java.lang.String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final java.lang.Object getFields() {
            return this.fields;
        }

        @Override
        public final java.lang.String getFormActionType() {
            return this.formActionType;
        }

        @Override
        public final java.lang.String getLabelDecorator() {
            return this.labelDecorator;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final java.lang.Object getSectionalElements() {
            return this.sectionalElements;
        }

        @Override
        public final java.lang.Object getStyle() {
            return this.style;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAppId() != null) {
                data.set("appId", om.valueToTree(this.getAppId()));
            }
            if (this.getCta() != null) {
                data.set("cta", om.valueToTree(this.getCta()));
            }
            if (this.getDataType() != null) {
                data.set("dataType", om.valueToTree(this.getDataType()));
            }
            if (this.getEnvironmentName() != null) {
                data.set("environmentName", om.valueToTree(this.getEnvironmentName()));
            }
            if (this.getFields() != null) {
                data.set("fields", om.valueToTree(this.getFields()));
            }
            if (this.getFormActionType() != null) {
                data.set("formActionType", om.valueToTree(this.getFormActionType()));
            }
            if (this.getLabelDecorator() != null) {
                data.set("labelDecorator", om.valueToTree(this.getLabelDecorator()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getSchemaVersion() != null) {
                data.set("schemaVersion", om.valueToTree(this.getSchemaVersion()));
            }
            if (this.getSectionalElements() != null) {
                data.set("sectionalElements", om.valueToTree(this.getSectionalElements()));
            }
            if (this.getStyle() != null) {
                data.set("style", om.valueToTree(this.getStyle()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnFormProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFormProps.Jsii$Proxy that = (CfnFormProps.Jsii$Proxy) o;

            if (this.appId != null ? !this.appId.equals(that.appId) : that.appId != null) return false;
            if (this.cta != null ? !this.cta.equals(that.cta) : that.cta != null) return false;
            if (this.dataType != null ? !this.dataType.equals(that.dataType) : that.dataType != null) return false;
            if (this.environmentName != null ? !this.environmentName.equals(that.environmentName) : that.environmentName != null) return false;
            if (this.fields != null ? !this.fields.equals(that.fields) : that.fields != null) return false;
            if (this.formActionType != null ? !this.formActionType.equals(that.formActionType) : that.formActionType != null) return false;
            if (this.labelDecorator != null ? !this.labelDecorator.equals(that.labelDecorator) : that.labelDecorator != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.schemaVersion != null ? !this.schemaVersion.equals(that.schemaVersion) : that.schemaVersion != null) return false;
            if (this.sectionalElements != null ? !this.sectionalElements.equals(that.sectionalElements) : that.sectionalElements != null) return false;
            if (this.style != null ? !this.style.equals(that.style) : that.style != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.appId != null ? this.appId.hashCode() : 0;
            result = 31 * result + (this.cta != null ? this.cta.hashCode() : 0);
            result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
            result = 31 * result + (this.environmentName != null ? this.environmentName.hashCode() : 0);
            result = 31 * result + (this.fields != null ? this.fields.hashCode() : 0);
            result = 31 * result + (this.formActionType != null ? this.formActionType.hashCode() : 0);
            result = 31 * result + (this.labelDecorator != null ? this.labelDecorator.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.schemaVersion != null ? this.schemaVersion.hashCode() : 0);
            result = 31 * result + (this.sectionalElements != null ? this.sectionalElements.hashCode() : 0);
            result = 31 * result + (this.style != null ? this.style.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
