package software.amazon.awscdk.services.appconfig;

/**
 * Properties for the Action construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn;
 * Extension.Builder.create(this, "MyExtension")
 *         .actions(List.of(
 *             Action.Builder.create()
 *                     .actionPoints(List.of(ActionPoint.ON_DEPLOYMENT_START))
 *                     .eventDestination(new LambdaDestination(fn))
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:09.705Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.ActionProps")
@software.amazon.jsii.Jsii.Proxy(ActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ActionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The action points that will trigger the extension action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appconfig.ActionPoint> getActionPoints();

    /**
     * The event destination for the action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination getEventDestination();

    /**
     * The description for the action.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The execution role for the action.
     * <p>
     * Default: - A role is generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getExecutionRole() {
        return null;
    }

    /**
     * The flag that specifies whether or not to create the execution role.
     * <p>
     * If set to true, then the role will not be auto-generated under the assumption
     * there is already the corresponding resource-based policy attached to the event
     * destination. If false, the execution role will be generated if not provided.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getInvokeWithoutExecutionRole() {
        return null;
    }

    /**
     * The name for the action.
     * <p>
     * Default: - A name is generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ActionProps> {
        java.util.List<software.amazon.awscdk.services.appconfig.ActionPoint> actionPoints;
        software.amazon.awscdk.services.appconfig.IEventDestination eventDestination;
        java.lang.String description;
        software.amazon.awscdk.services.iam.IRole executionRole;
        java.lang.Boolean invokeWithoutExecutionRole;
        java.lang.String name;

        /**
         * Sets the value of {@link ActionProps#getActionPoints}
         * @param actionPoints The action points that will trigger the extension action. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder actionPoints(java.util.List<? extends software.amazon.awscdk.services.appconfig.ActionPoint> actionPoints) {
            this.actionPoints = (java.util.List<software.amazon.awscdk.services.appconfig.ActionPoint>)actionPoints;
            return this;
        }

        /**
         * Sets the value of {@link ActionProps#getEventDestination}
         * @param eventDestination The event destination for the action. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventDestination(software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
            this.eventDestination = eventDestination;
            return this;
        }

        /**
         * Sets the value of {@link ActionProps#getDescription}
         * @param description The description for the action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ActionProps#getExecutionRole}
         * @param executionRole The execution role for the action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(software.amazon.awscdk.services.iam.IRole executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link ActionProps#getInvokeWithoutExecutionRole}
         * @param invokeWithoutExecutionRole The flag that specifies whether or not to create the execution role.
         *                                   If set to true, then the role will not be auto-generated under the assumption
         *                                   there is already the corresponding resource-based policy attached to the event
         *                                   destination. If false, the execution role will be generated if not provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invokeWithoutExecutionRole(java.lang.Boolean invokeWithoutExecutionRole) {
            this.invokeWithoutExecutionRole = invokeWithoutExecutionRole;
            return this;
        }

        /**
         * Sets the value of {@link ActionProps#getName}
         * @param name The name for the action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProps {
        private final java.util.List<software.amazon.awscdk.services.appconfig.ActionPoint> actionPoints;
        private final software.amazon.awscdk.services.appconfig.IEventDestination eventDestination;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.iam.IRole executionRole;
        private final java.lang.Boolean invokeWithoutExecutionRole;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actionPoints = software.amazon.jsii.Kernel.get(this, "actionPoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ActionPoint.class)));
            this.eventDestination = software.amazon.jsii.Kernel.get(this, "eventDestination", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IEventDestination.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.invokeWithoutExecutionRole = software.amazon.jsii.Kernel.get(this, "invokeWithoutExecutionRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actionPoints = (java.util.List<software.amazon.awscdk.services.appconfig.ActionPoint>)java.util.Objects.requireNonNull(builder.actionPoints, "actionPoints is required");
            this.eventDestination = java.util.Objects.requireNonNull(builder.eventDestination, "eventDestination is required");
            this.description = builder.description;
            this.executionRole = builder.executionRole;
            this.invokeWithoutExecutionRole = builder.invokeWithoutExecutionRole;
            this.name = builder.name;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appconfig.ActionPoint> getActionPoints() {
            return this.actionPoints;
        }

        @Override
        public final software.amazon.awscdk.services.appconfig.IEventDestination getEventDestination() {
            return this.eventDestination;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final java.lang.Boolean getInvokeWithoutExecutionRole() {
            return this.invokeWithoutExecutionRole;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actionPoints", om.valueToTree(this.getActionPoints()));
            data.set("eventDestination", om.valueToTree(this.getEventDestination()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExecutionRole() != null) {
                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            }
            if (this.getInvokeWithoutExecutionRole() != null) {
                data.set("invokeWithoutExecutionRole", om.valueToTree(this.getInvokeWithoutExecutionRole()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appconfig.ActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ActionProps.Jsii$Proxy that = (ActionProps.Jsii$Proxy) o;

            if (!actionPoints.equals(that.actionPoints)) return false;
            if (!eventDestination.equals(that.eventDestination)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
            if (this.invokeWithoutExecutionRole != null ? !this.invokeWithoutExecutionRole.equals(that.invokeWithoutExecutionRole) : that.invokeWithoutExecutionRole != null) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actionPoints.hashCode();
            result = 31 * result + (this.eventDestination.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
            result = 31 * result + (this.invokeWithoutExecutionRole != null ? this.invokeWithoutExecutionRole.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
