package software.amazon.awscdk.services.appconfig;

/**
 * An AWS AppConfig environment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Application app = new Application(this, "MyApp");
 * Environment env = Environment.Builder.create(this, "MyEnv")
 *         .application(app)
 *         .build();
 * HostedConfiguration.Builder.create(this, "MyFirstHostedConfig")
 *         .application(app)
 *         .deployTo(List.of(env))
 *         .content(ConfigurationContent.fromInlineText("This is my first configuration content."))
 *         .build();
 * HostedConfiguration.Builder.create(this, "MySecondHostedConfig")
 *         .application(app)
 *         .deployTo(List.of(env))
 *         .content(ConfigurationContent.fromInlineText("This is my second configuration content."))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-environment.html">https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-environment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:09.743Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.Environment")
public class Environment extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.appconfig.IEnvironment, software.amazon.awscdk.services.appconfig.IExtensible {

    protected Environment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Environment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appconfig.Environment.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Environment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.EnvironmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports an environment into the CDK using its Amazon Resource Name (ARN).
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id The name of the environment construct. This parameter is required.
     * @param environmentArn The Amazon Resource Name (ARN) of the environment. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEnvironment fromEnvironmentArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String environmentArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Environment.class, "fromEnvironmentArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IEnvironment.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(environmentArn, "environmentArn is required") });
    }

    /**
     * Imports an environment into the CDK from its attributes.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id The name of the environment construct. This parameter is required.
     * @param attrs The attributes of the environment. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEnvironment fromEnvironmentAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.EnvironmentAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Environment.class, "fromEnvironmentAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IEnvironment.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Creates a deployment of the supplied configuration to this environment.
     * <p>
     * Note that you can only deploy one configuration at a time to an environment.
     * However, you can deploy one configuration each to different environments at the same time.
     * If more than one deployment is requested for this environment, they will occur in the same order they were provided.
     * <p>
     * @param configuration This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IConfiguration configuration) {
        software.amazon.jsii.Kernel.call(this, "addDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(configuration, "configuration is required") });
    }

    /**
     * Creates a deployment for each of the supplied configurations to this environment.
     * <p>
     * These configurations will be deployed in the same order as the input array.
     * <p>
     * @param configurations This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addDeployments(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IConfiguration... configurations) {
        software.amazon.jsii.Kernel.call(this, "addDeployments", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(configurations).toArray(Object[]::new));
    }

    /**
     * Adds an extension association to the environment.
     * <p>
     * @param extension This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addExtension(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IExtension extension) {
        software.amazon.jsii.Kernel.call(this, "addExtension", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(extension, "extension is required") });
    }

    /**
     * Adds an AT_DEPLOYMENT_TICK extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void atDeploymentTick(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "atDeploymentTick", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an AT_DEPLOYMENT_TICK extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void atDeploymentTick(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "atDeploymentTick", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an IAM policy statement associated with this environment to an IAM principal's policy.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Permits an IAM principal to perform read operations on this environment's configurations.
     * <p>
     * Actions: GetLatestConfiguration, StartConfigurationSession.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantReadConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Adds an extension defined by the action point and event destination and also creates an extension association to the environment.
     * <p>
     * @param actionPoint This parameter is required.
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void on(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ActionPoint actionPoint, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "on", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(actionPoint, "actionPoint is required"), java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an extension defined by the action point and event destination and also creates an extension association to the environment.
     * <p>
     * @param actionPoint This parameter is required.
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void on(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ActionPoint actionPoint, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "on", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(actionPoint, "actionPoint is required"), java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_BAKING extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentBaking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentBaking", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_BAKING extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentBaking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentBaking", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_COMPLETE extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentComplete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentComplete", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_COMPLETE extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentComplete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentComplete", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_ROLLED_BACK extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentRolledBack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentRolledBack", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_ROLLED_BACK extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentRolledBack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentRolledBack", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_START extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStart", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_START extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStart", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_STEP extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStep(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStep", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_STEP extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStep(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStep", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds a PRE_CREATE_HOSTED_CONFIGURATION_VERSION extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preCreateHostedConfigurationVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "preCreateHostedConfigurationVersion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds a PRE_CREATE_HOSTED_CONFIGURATION_VERSION extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preCreateHostedConfigurationVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "preCreateHostedConfigurationVersion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds a PRE_START_DEPLOYMENT extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preStartDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "preStartDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds a PRE_START_DEPLOYMENT extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preStartDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "preStartDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The ID of the environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentArn() {
        return software.amazon.jsii.Kernel.get(this, "environmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentId() {
        return software.amazon.jsii.Kernel.get(this, "environmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The application associated with the environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.IApplication getApplication() {
        return software.amazon.jsii.Kernel.get(this, "application", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IApplication.class));
    }

    /**
     * The description of the environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The monitors for the environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appconfig.Monitor> getMonitors() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.appconfig.Monitor>)(software.amazon.jsii.Kernel.get(this, "monitors", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Monitor.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The name of the environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appconfig.CfnDeployment> getDeploymentQueue() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "deploymentQueue", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.CfnDeployment.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setDeploymentQueue(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appconfig.CfnDeployment> value) {
        software.amazon.jsii.Kernel.set(this, "deploymentQueue", java.util.Objects.requireNonNull(value, "deploymentQueue is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ExtensibleBase getExtensible() {
        return software.amazon.jsii.Kernel.get(this, "extensible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ExtensibleBase.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setExtensible(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ExtensibleBase value) {
        software.amazon.jsii.Kernel.set(this, "extensible", java.util.Objects.requireNonNull(value, "extensible is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appconfig.Environment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appconfig.Environment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appconfig.EnvironmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appconfig.EnvironmentProps.Builder();
        }

        /**
         * A property to prevent accidental deletion of active environments.
         * <p>
         * Default: undefined - AppConfig default is ACCOUNT_DEFAULT
         * <p>
         * @return {@code this}
         * @param deletionProtectionCheck A property to prevent accidental deletion of active environments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtectionCheck(final software.amazon.awscdk.services.appconfig.DeletionProtectionCheck deletionProtectionCheck) {
            this.props.deletionProtectionCheck(deletionProtectionCheck);
            return this;
        }

        /**
         * The description of the environment.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description The description of the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the environment.
         * <p>
         * Default: - A name is generated.
         * <p>
         * @return {@code this}
         * @param environmentName The name of the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentName(final java.lang.String environmentName) {
            this.props.environmentName(environmentName);
            return this;
        }

        /**
         * The monitors for the environment.
         * <p>
         * Default: - No monitors.
         * <p>
         * @return {@code this}
         * @param monitors The monitors for the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitors(final java.util.List<? extends software.amazon.awscdk.services.appconfig.Monitor> monitors) {
            this.props.monitors(monitors);
            return this;
        }

        /**
         * The application to be associated with the environment.
         * <p>
         * @return {@code this}
         * @param application The application to be associated with the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder application(final software.amazon.awscdk.services.appconfig.IApplication application) {
            this.props.application(application);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appconfig.Environment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appconfig.Environment build() {
            return new software.amazon.awscdk.services.appconfig.Environment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
