package software.amazon.awscdk.services.appmesh;

/**
 * Interface with properties necessary to import a reusable VirtualNode.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String virtualNodeName = "my-virtual-node";
 * VirtualNode.fromVirtualNodeAttributes(this, "imported-virtual-node", VirtualNodeAttributes.builder()
 *         .mesh(Mesh.fromMeshName(this, "Mesh", "testMesh"))
 *         .virtualNodeName(virtualNodeName)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:10.203Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualNodeAttributes")
@software.amazon.jsii.Jsii.Proxy(VirtualNodeAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VirtualNodeAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Mesh that the VirtualNode belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IMesh getMesh();

    /**
     * The name of the VirtualNode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVirtualNodeName();

    /**
     * @return a {@link Builder} of {@link VirtualNodeAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VirtualNodeAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VirtualNodeAttributes> {
        software.amazon.awscdk.services.appmesh.IMesh mesh;
        java.lang.String virtualNodeName;

        /**
         * Sets the value of {@link VirtualNodeAttributes#getMesh}
         * @param mesh The Mesh that the VirtualNode belongs to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mesh(software.amazon.awscdk.services.appmesh.IMesh mesh) {
            this.mesh = mesh;
            return this;
        }

        /**
         * Sets the value of {@link VirtualNodeAttributes#getVirtualNodeName}
         * @param virtualNodeName The name of the VirtualNode. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualNodeName(java.lang.String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VirtualNodeAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VirtualNodeAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VirtualNodeAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualNodeAttributes {
        private final software.amazon.awscdk.services.appmesh.IMesh mesh;
        private final java.lang.String virtualNodeName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mesh = software.amazon.jsii.Kernel.get(this, "mesh", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IMesh.class));
            this.virtualNodeName = software.amazon.jsii.Kernel.get(this, "virtualNodeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mesh = java.util.Objects.requireNonNull(builder.mesh, "mesh is required");
            this.virtualNodeName = java.util.Objects.requireNonNull(builder.virtualNodeName, "virtualNodeName is required");
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.IMesh getMesh() {
            return this.mesh;
        }

        @Override
        public final java.lang.String getVirtualNodeName() {
            return this.virtualNodeName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("mesh", om.valueToTree(this.getMesh()));
            data.set("virtualNodeName", om.valueToTree(this.getVirtualNodeName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.VirtualNodeAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VirtualNodeAttributes.Jsii$Proxy that = (VirtualNodeAttributes.Jsii$Proxy) o;

            if (!mesh.equals(that.mesh)) return false;
            return this.virtualNodeName.equals(that.virtualNodeName);
        }

        @Override
        public final int hashCode() {
            int result = this.mesh.hashCode();
            result = 31 * result + (this.virtualNodeName.hashCode());
            return result;
        }
    }
}
