package software.amazon.awscdk.services.appsync;

/**
 * Auth provider settings for AppSync Event APIs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * AppSyncAuthProvider apiKeyProvider = AppSyncAuthProvider.builder()
 *         .authorizationType(AppSyncAuthorizationType.API_KEY)
 *         .build();
 * EventApi api = EventApi.Builder.create(this, "api")
 *         .apiName("Api")
 *         .ownerContact("OwnerContact")
 *         .authorizationConfig(EventApiAuthConfig.builder()
 *                 .authProviders(List.of(apiKeyProvider))
 *                 .connectionAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .defaultPublishAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .defaultSubscribeAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .build())
 *         .logConfig(AppSyncLogConfig.builder()
 *                 .fieldLogLevel(AppSyncFieldLogLevel.INFO)
 *                 .retention(RetentionDays.ONE_WEEK)
 *                 .build())
 *         .build();
 * api.addChannelNamespace("default");
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/appsync/latest/eventapi/configure-event-api-auth.html">https://docs.aws.amazon.com/appsync/latest/eventapi/configure-event-api-auth.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:10.302Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AppSyncAuthProvider")
@software.amazon.jsii.Jsii.Proxy(AppSyncAuthProvider.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AppSyncAuthProvider extends software.amazon.jsii.JsiiSerializable {

    /**
     * One of possible authorization types AppSync supports.
     * <p>
     * Default: - `AuthorizationType.API_KEY`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppSyncAuthorizationType getAuthorizationType();

    /**
     * If authorizationType is <code>AuthorizationType.API_KEY</code>, this option can be configured.
     * <p>
     * Default: - name: 'DefaultAPIKey'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.AppSyncApiKeyConfig getApiKeyConfig() {
        return null;
    }

    /**
     * If authorizationType is <code>AuthorizationType.USER_POOL</code>, this option is required.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.AppSyncCognitoConfig getCognitoConfig() {
        return null;
    }

    /**
     * If authorizationType is <code>AuthorizationType.LAMBDA</code>, this option is required.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.AppSyncLambdaAuthorizerConfig getLambdaAuthorizerConfig() {
        return null;
    }

    /**
     * If authorizationType is <code>AuthorizationType.OIDC</code>, this option is required.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.AppSyncOpenIdConnectConfig getOpenIdConnectConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AppSyncAuthProvider}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AppSyncAuthProvider}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AppSyncAuthProvider> {
        software.amazon.awscdk.services.appsync.AppSyncAuthorizationType authorizationType;
        software.amazon.awscdk.services.appsync.AppSyncApiKeyConfig apiKeyConfig;
        software.amazon.awscdk.services.appsync.AppSyncCognitoConfig cognitoConfig;
        software.amazon.awscdk.services.appsync.AppSyncLambdaAuthorizerConfig lambdaAuthorizerConfig;
        software.amazon.awscdk.services.appsync.AppSyncOpenIdConnectConfig openIdConnectConfig;

        /**
         * Sets the value of {@link AppSyncAuthProvider#getAuthorizationType}
         * @param authorizationType One of possible authorization types AppSync supports. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationType(software.amazon.awscdk.services.appsync.AppSyncAuthorizationType authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncAuthProvider#getApiKeyConfig}
         * @param apiKeyConfig If authorizationType is <code>AuthorizationType.API_KEY</code>, this option can be configured.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyConfig(software.amazon.awscdk.services.appsync.AppSyncApiKeyConfig apiKeyConfig) {
            this.apiKeyConfig = apiKeyConfig;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncAuthProvider#getCognitoConfig}
         * @param cognitoConfig If authorizationType is <code>AuthorizationType.USER_POOL</code>, this option is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoConfig(software.amazon.awscdk.services.appsync.AppSyncCognitoConfig cognitoConfig) {
            this.cognitoConfig = cognitoConfig;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncAuthProvider#getLambdaAuthorizerConfig}
         * @param lambdaAuthorizerConfig If authorizationType is <code>AuthorizationType.LAMBDA</code>, this option is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaAuthorizerConfig(software.amazon.awscdk.services.appsync.AppSyncLambdaAuthorizerConfig lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncAuthProvider#getOpenIdConnectConfig}
         * @param openIdConnectConfig If authorizationType is <code>AuthorizationType.OIDC</code>, this option is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectConfig(software.amazon.awscdk.services.appsync.AppSyncOpenIdConnectConfig openIdConnectConfig) {
            this.openIdConnectConfig = openIdConnectConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AppSyncAuthProvider}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AppSyncAuthProvider build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AppSyncAuthProvider}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppSyncAuthProvider {
        private final software.amazon.awscdk.services.appsync.AppSyncAuthorizationType authorizationType;
        private final software.amazon.awscdk.services.appsync.AppSyncApiKeyConfig apiKeyConfig;
        private final software.amazon.awscdk.services.appsync.AppSyncCognitoConfig cognitoConfig;
        private final software.amazon.awscdk.services.appsync.AppSyncLambdaAuthorizerConfig lambdaAuthorizerConfig;
        private final software.amazon.awscdk.services.appsync.AppSyncOpenIdConnectConfig openIdConnectConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizationType = software.amazon.jsii.Kernel.get(this, "authorizationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncAuthorizationType.class));
            this.apiKeyConfig = software.amazon.jsii.Kernel.get(this, "apiKeyConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncApiKeyConfig.class));
            this.cognitoConfig = software.amazon.jsii.Kernel.get(this, "cognitoConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncCognitoConfig.class));
            this.lambdaAuthorizerConfig = software.amazon.jsii.Kernel.get(this, "lambdaAuthorizerConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncLambdaAuthorizerConfig.class));
            this.openIdConnectConfig = software.amazon.jsii.Kernel.get(this, "openIdConnectConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncOpenIdConnectConfig.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizationType = java.util.Objects.requireNonNull(builder.authorizationType, "authorizationType is required");
            this.apiKeyConfig = builder.apiKeyConfig;
            this.cognitoConfig = builder.cognitoConfig;
            this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
            this.openIdConnectConfig = builder.openIdConnectConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.AppSyncAuthorizationType getAuthorizationType() {
            return this.authorizationType;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.AppSyncApiKeyConfig getApiKeyConfig() {
            return this.apiKeyConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.AppSyncCognitoConfig getCognitoConfig() {
            return this.cognitoConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.AppSyncLambdaAuthorizerConfig getLambdaAuthorizerConfig() {
            return this.lambdaAuthorizerConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.AppSyncOpenIdConnectConfig getOpenIdConnectConfig() {
            return this.openIdConnectConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authorizationType", om.valueToTree(this.getAuthorizationType()));
            if (this.getApiKeyConfig() != null) {
                data.set("apiKeyConfig", om.valueToTree(this.getApiKeyConfig()));
            }
            if (this.getCognitoConfig() != null) {
                data.set("cognitoConfig", om.valueToTree(this.getCognitoConfig()));
            }
            if (this.getLambdaAuthorizerConfig() != null) {
                data.set("lambdaAuthorizerConfig", om.valueToTree(this.getLambdaAuthorizerConfig()));
            }
            if (this.getOpenIdConnectConfig() != null) {
                data.set("openIdConnectConfig", om.valueToTree(this.getOpenIdConnectConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.AppSyncAuthProvider"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AppSyncAuthProvider.Jsii$Proxy that = (AppSyncAuthProvider.Jsii$Proxy) o;

            if (!authorizationType.equals(that.authorizationType)) return false;
            if (this.apiKeyConfig != null ? !this.apiKeyConfig.equals(that.apiKeyConfig) : that.apiKeyConfig != null) return false;
            if (this.cognitoConfig != null ? !this.cognitoConfig.equals(that.cognitoConfig) : that.cognitoConfig != null) return false;
            if (this.lambdaAuthorizerConfig != null ? !this.lambdaAuthorizerConfig.equals(that.lambdaAuthorizerConfig) : that.lambdaAuthorizerConfig != null) return false;
            return this.openIdConnectConfig != null ? this.openIdConnectConfig.equals(that.openIdConnectConfig) : that.openIdConnectConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorizationType.hashCode();
            result = 31 * result + (this.apiKeyConfig != null ? this.apiKeyConfig.hashCode() : 0);
            result = 31 * result + (this.cognitoConfig != null ? this.cognitoConfig.hashCode() : 0);
            result = 31 * result + (this.lambdaAuthorizerConfig != null ? this.lambdaAuthorizerConfig.hashCode() : 0);
            result = 31 * result + (this.openIdConnectConfig != null ? this.openIdConnectConfig.hashCode() : 0);
            return result;
        }
    }
}
