package software.amazon.awscdk.services.appsync;

/**
 * An AppSync datasource backed by a Lambda function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function lambdaDs;
 * EventApi api = EventApi.Builder.create(this, "EventApiLambda")
 *         .apiName("LambdaEventApi")
 *         .build();
 * AppSyncLambdaDataSource dataSource = api.addLambdaDataSource("lambdads", lambdaDs);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:10.325Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AppSyncLambdaDataSource")
public class AppSyncLambdaDataSource extends software.amazon.awscdk.services.appsync.AppSyncBackedDataSource {

    protected AppSyncLambdaDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AppSyncLambdaDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AppSyncLambdaDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppSyncLambdaDataSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.AppSyncLambdaDataSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.AppSyncLambdaDataSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.AppSyncLambdaDataSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.AppSyncLambdaDataSourceProps.Builder();
        }

        /**
         * The API to attach this data source to.
         * <p>
         * @return {@code this}
         * @param api The API to attach this data source to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(final software.amazon.awscdk.services.appsync.IApi api) {
            this.props.api(api);
            return this;
        }

        /**
         * The description of the data source.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param description The description of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the data source.
         * <p>
         * The only allowed pattern is: {[_A-Za-z][_0-9A-Za-z]*}.
         * Any invalid characters will be automatically removed.
         * <p>
         * Default: - id of data source
         * <p>
         * @return {@code this}
         * @param name The name of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The IAM service role to be assumed by AppSync to interact with the data source.
         * <p>
         * Default: -  Create a new role
         * <p>
         * @return {@code this}
         * @param serviceRole The IAM service role to be assumed by AppSync to interact with the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(final software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * The Lambda function to call to interact with this data source.
         * <p>
         * @return {@code this}
         * @param lambdaFunction The Lambda function to call to interact with this data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaFunction(final software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
            this.props.lambdaFunction(lambdaFunction);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.AppSyncLambdaDataSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.AppSyncLambdaDataSource build() {
            return new software.amazon.awscdk.services.appsync.AppSyncLambdaDataSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
