package software.amazon.awscdk.services.appsync;

/**
 * Properties for defining a <code>CfnGraphQLApi</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnGraphQLApiProps cfnGraphQLApiProps = CfnGraphQLApiProps.builder()
 *         .authenticationType("authenticationType")
 *         .name("name")
 *         // the properties below are optional
 *         .additionalAuthenticationProviders(List.of(AdditionalAuthenticationProviderProperty.builder()
 *                 .authenticationType("authenticationType")
 *                 // the properties below are optional
 *                 .lambdaAuthorizerConfig(LambdaAuthorizerConfigProperty.builder()
 *                         .authorizerResultTtlInSeconds(123)
 *                         .authorizerUri("authorizerUri")
 *                         .identityValidationExpression("identityValidationExpression")
 *                         .build())
 *                 .openIdConnectConfig(OpenIDConnectConfigProperty.builder()
 *                         .authTtl(123)
 *                         .clientId("clientId")
 *                         .iatTtl(123)
 *                         .issuer("issuer")
 *                         .build())
 *                 .userPoolConfig(CognitoUserPoolConfigProperty.builder()
 *                         .appIdClientRegex("appIdClientRegex")
 *                         .awsRegion("awsRegion")
 *                         .userPoolId("userPoolId")
 *                         .build())
 *                 .build()))
 *         .apiType("apiType")
 *         .enhancedMetricsConfig(EnhancedMetricsConfigProperty.builder()
 *                 .dataSourceLevelMetricsBehavior("dataSourceLevelMetricsBehavior")
 *                 .operationLevelMetricsConfig("operationLevelMetricsConfig")
 *                 .resolverLevelMetricsBehavior("resolverLevelMetricsBehavior")
 *                 .build())
 *         .environmentVariables(Map.of(
 *                 "environmentVariablesKey", "environmentVariables"))
 *         .introspectionConfig("introspectionConfig")
 *         .lambdaAuthorizerConfig(LambdaAuthorizerConfigProperty.builder()
 *                 .authorizerResultTtlInSeconds(123)
 *                 .authorizerUri("authorizerUri")
 *                 .identityValidationExpression("identityValidationExpression")
 *                 .build())
 *         .logConfig(LogConfigProperty.builder()
 *                 .cloudWatchLogsRoleArn("cloudWatchLogsRoleArn")
 *                 .excludeVerboseContent(false)
 *                 .fieldLogLevel("fieldLogLevel")
 *                 .build())
 *         .mergedApiExecutionRoleArn("mergedApiExecutionRoleArn")
 *         .openIdConnectConfig(OpenIDConnectConfigProperty.builder()
 *                 .authTtl(123)
 *                 .clientId("clientId")
 *                 .iatTtl(123)
 *                 .issuer("issuer")
 *                 .build())
 *         .ownerContact("ownerContact")
 *         .queryDepthLimit(123)
 *         .resolverCountLimit(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userPoolConfig(UserPoolConfigProperty.builder()
 *                 .appIdClientRegex("appIdClientRegex")
 *                 .awsRegion("awsRegion")
 *                 .defaultAction("defaultAction")
 *                 .userPoolId("userPoolId")
 *                 .build())
 *         .visibility("visibility")
 *         .xrayEnabled(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:10.402Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApiProps")
@software.amazon.jsii.Jsii.Proxy(CfnGraphQLApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGraphQLApiProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Security configuration for your GraphQL API.
     * <p>
     * For allowed values (such as <code>API_KEY</code> , <code>AWS_IAM</code> , <code>AMAZON_COGNITO_USER_POOLS</code> , <code>OPENID_CONNECT</code> , or <code>AWS_LAMBDA</code> ), see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/security.html">Security</a> in the <em>AWS AppSync Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-authenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-authenticationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthenticationType();

    /**
     * The API name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A list of additional authentication providers for the <code>GraphqlApi</code> API.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-additionalauthenticationproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-additionalauthenticationproviders</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalAuthenticationProviders() {
        return null;
    }

    /**
     * The value that indicates whether the GraphQL API is a standard API ( <code>GRAPHQL</code> ) or merged API ( <code>MERGED</code> ).
     * <p>
     * <em>WARNING</em> : If the <code>ApiType</code> has not been defined, <em>explicitly</em> setting it to <code>GRAPHQL</code> in a template/stack update will result in an API replacement and new DNS values.
     * <p>
     * The following values are valid:
     * <p>
     * <code>GRAPHQL | MERGED</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-apitype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-apitype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiType() {
        return null;
    }

    /**
     * Enables and controls the enhanced metrics feature.
     * <p>
     * Enhanced metrics emit granular data on API usage and performance such as AppSync request and error counts, latency, and cache hits/misses. All enhanced metric data is sent to your CloudWatch account, and you can configure the types of data that will be sent.
     * <p>
     * Enhanced metrics can be configured at the resolver, data source, and operation levels. For more information, see <a href="https://docs.aws.amazon.com//appsync/latest/devguide/monitoring.html#cw-metrics">Monitoring and logging</a> in the <em>AWS AppSync User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-enhancedmetricsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-enhancedmetricsconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnhancedMetricsConfig() {
        return null;
    }

    /**
     * A map containing the list of resources with their properties and environment variables.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/environmental-variables.html">Environmental variables</a> .
     * <p>
     * <em>Pattern</em> : <code>^[A-Za-z]+\\w*$\\</code>
     * <p>
     * <em>Minimum</em> : 2
     * <p>
     * <em>Maximum</em> : 64
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-environmentvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-environmentvariables</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentVariables() {
        return null;
    }

    /**
     * Sets the value of the GraphQL API to enable ( <code>ENABLED</code> ) or disable ( <code>DISABLED</code> ) introspection.
     * <p>
     * If no value is provided, the introspection configuration will be set to <code>ENABLED</code> by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled.
     * <p>
     * For more information about introspection, see <a href="https://docs.aws.amazon.com/https://graphql.org/learn/introspection/">GraphQL introspection</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-introspectionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-introspectionconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIntrospectionConfig() {
        return null;
    }

    /**
     * A <code>LambdaAuthorizerConfig</code> holds configuration on how to authorize AWS AppSync API access when using the <code>AWS_LAMBDA</code> authorizer mode.
     * <p>
     * Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-lambdaauthorizerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-lambdaauthorizerconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaAuthorizerConfig() {
        return null;
    }

    /**
     * The Amazon CloudWatch Logs configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-logconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-logconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogConfig() {
        return null;
    }

    /**
     * The AWS Identity and Access Management service role ARN for a merged API.
     * <p>
     * The AppSync service assumes this role on behalf of the Merged API to validate access to source APIs at runtime and to prompt the <code>AUTO_MERGE</code> to update the merged API endpoint with the source API changes automatically.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-mergedapiexecutionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-mergedapiexecutionrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMergedApiExecutionRoleArn() {
        return null;
    }

    /**
     * The OpenID Connect configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-openidconnectconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-openidconnectconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOpenIdConnectConfig() {
        return null;
    }

    /**
     * The owner contact information for an API resource.
     * <p>
     * This field accepts any string input with a length of 0 - 256 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-ownercontact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-ownercontact</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOwnerContact() {
        return null;
    }

    /**
     * The maximum depth a query can have in a single request.
     * <p>
     * Depth refers to the amount of nested levels allowed in the body of query. The default value is <code>0</code> (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between <code>1</code> and <code>75</code> nested levels. This field will produce a limit error if the operation falls out of bounds. Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-querydepthlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-querydepthlimit</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getQueryDepthLimit() {
        return null;
    }

    /**
     * The maximum number of resolvers that can be invoked in a single request.
     * <p>
     * The default value is <code>0</code> (or unspecified), which will set the limit to <code>10000</code> . When specified, the limit value can be between <code>1</code> and <code>10000</code> . This field will produce a limit error if the operation falls out of bounds.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-resolvercountlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-resolvercountlimit</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getResolverCountLimit() {
        return null;
    }

    /**
     * An arbitrary set of tags (key-value pairs) for this GraphQL API.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-userpoolconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-userpoolconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserPoolConfig() {
        return null;
    }

    /**
     * Sets the scope of the GraphQL API to public ( <code>GLOBAL</code> ) or private ( <code>PRIVATE</code> ).
     * <p>
     * By default, the scope is set to <code>Global</code> if no value is provided.
     * <p>
     * <em>WARNING</em> : If <code>Visibility</code> has not been defined, <em>explicitly</em> setting it to <code>GLOBAL</code> in a template/stack update will result in an API replacement and new DNS values.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-visibility">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-visibility</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVisibility() {
        return null;
    }

    /**
     * A flag indicating whether to use AWS X-Ray tracing for this <code>GraphqlApi</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-xrayenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-graphqlapi.html#cfn-appsync-graphqlapi-xrayenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getXrayEnabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGraphQLApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGraphQLApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGraphQLApiProps> {
        java.lang.String authenticationType;
        java.lang.String name;
        java.lang.Object additionalAuthenticationProviders;
        java.lang.String apiType;
        java.lang.Object enhancedMetricsConfig;
        java.lang.Object environmentVariables;
        java.lang.String introspectionConfig;
        java.lang.Object lambdaAuthorizerConfig;
        java.lang.Object logConfig;
        java.lang.String mergedApiExecutionRoleArn;
        java.lang.Object openIdConnectConfig;
        java.lang.String ownerContact;
        java.lang.Number queryDepthLimit;
        java.lang.Number resolverCountLimit;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object userPoolConfig;
        java.lang.String visibility;
        java.lang.Object xrayEnabled;

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getAuthenticationType}
         * @param authenticationType Security configuration for your GraphQL API. This parameter is required.
         *                           For allowed values (such as <code>API_KEY</code> , <code>AWS_IAM</code> , <code>AMAZON_COGNITO_USER_POOLS</code> , <code>OPENID_CONNECT</code> , or <code>AWS_LAMBDA</code> ), see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/security.html">Security</a> in the <em>AWS AppSync Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationType(java.lang.String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getName}
         * @param name The API name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getAdditionalAuthenticationProviders}
         * @param additionalAuthenticationProviders A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalAuthenticationProviders(software.amazon.awscdk.IResolvable additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = additionalAuthenticationProviders;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getAdditionalAuthenticationProviders}
         * @param additionalAuthenticationProviders A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalAuthenticationProviders(java.util.List<? extends java.lang.Object> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = additionalAuthenticationProviders;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getApiType}
         * @param apiType The value that indicates whether the GraphQL API is a standard API ( <code>GRAPHQL</code> ) or merged API ( <code>MERGED</code> ).
         *                <em>WARNING</em> : If the <code>ApiType</code> has not been defined, <em>explicitly</em> setting it to <code>GRAPHQL</code> in a template/stack update will result in an API replacement and new DNS values.
         *                <p>
         *                The following values are valid:
         *                <p>
         *                <code>GRAPHQL | MERGED</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiType(java.lang.String apiType) {
            this.apiType = apiType;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getEnhancedMetricsConfig}
         * @param enhancedMetricsConfig Enables and controls the enhanced metrics feature.
         *                              Enhanced metrics emit granular data on API usage and performance such as AppSync request and error counts, latency, and cache hits/misses. All enhanced metric data is sent to your CloudWatch account, and you can configure the types of data that will be sent.
         *                              <p>
         *                              Enhanced metrics can be configured at the resolver, data source, and operation levels. For more information, see <a href="https://docs.aws.amazon.com//appsync/latest/devguide/monitoring.html#cw-metrics">Monitoring and logging</a> in the <em>AWS AppSync User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedMetricsConfig(software.amazon.awscdk.IResolvable enhancedMetricsConfig) {
            this.enhancedMetricsConfig = enhancedMetricsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getEnhancedMetricsConfig}
         * @param enhancedMetricsConfig Enables and controls the enhanced metrics feature.
         *                              Enhanced metrics emit granular data on API usage and performance such as AppSync request and error counts, latency, and cache hits/misses. All enhanced metric data is sent to your CloudWatch account, and you can configure the types of data that will be sent.
         *                              <p>
         *                              Enhanced metrics can be configured at the resolver, data source, and operation levels. For more information, see <a href="https://docs.aws.amazon.com//appsync/latest/devguide/monitoring.html#cw-metrics">Monitoring and logging</a> in the <em>AWS AppSync User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedMetricsConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.EnhancedMetricsConfigProperty enhancedMetricsConfig) {
            this.enhancedMetricsConfig = enhancedMetricsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getEnvironmentVariables}
         * @param environmentVariables A map containing the list of resources with their properties and environment variables.
         *                             For more information, see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/environmental-variables.html">Environmental variables</a> .
         *                             <p>
         *                             <em>Pattern</em> : <code>^[A-Za-z]+\\w*$\\</code>
         *                             <p>
         *                             <em>Minimum</em> : 2
         *                             <p>
         *                             <em>Maximum</em> : 64
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(java.util.Map<java.lang.String, java.lang.String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getEnvironmentVariables}
         * @param environmentVariables A map containing the list of resources with their properties and environment variables.
         *                             For more information, see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/environmental-variables.html">Environmental variables</a> .
         *                             <p>
         *                             <em>Pattern</em> : <code>^[A-Za-z]+\\w*$\\</code>
         *                             <p>
         *                             <em>Minimum</em> : 2
         *                             <p>
         *                             <em>Maximum</em> : 64
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(software.amazon.awscdk.IResolvable environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getIntrospectionConfig}
         * @param introspectionConfig Sets the value of the GraphQL API to enable ( <code>ENABLED</code> ) or disable ( <code>DISABLED</code> ) introspection.
         *                            If no value is provided, the introspection configuration will be set to <code>ENABLED</code> by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled.
         *                            <p>
         *                            For more information about introspection, see <a href="https://docs.aws.amazon.com/https://graphql.org/learn/introspection/">GraphQL introspection</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder introspectionConfig(java.lang.String introspectionConfig) {
            this.introspectionConfig = introspectionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getLambdaAuthorizerConfig}
         * @param lambdaAuthorizerConfig A <code>LambdaAuthorizerConfig</code> holds configuration on how to authorize AWS AppSync API access when using the <code>AWS_LAMBDA</code> authorizer mode.
         *                               Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaAuthorizerConfig(software.amazon.awscdk.IResolvable lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getLambdaAuthorizerConfig}
         * @param lambdaAuthorizerConfig A <code>LambdaAuthorizerConfig</code> holds configuration on how to authorize AWS AppSync API access when using the <code>AWS_LAMBDA</code> authorizer mode.
         *                               Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaAuthorizerConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getLogConfig}
         * @param logConfig The Amazon CloudWatch Logs configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(software.amazon.awscdk.IResolvable logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getLogConfig}
         * @param logConfig The Amazon CloudWatch Logs configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.LogConfigProperty logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getMergedApiExecutionRoleArn}
         * @param mergedApiExecutionRoleArn The AWS Identity and Access Management service role ARN for a merged API.
         *                                  The AppSync service assumes this role on behalf of the Merged API to validate access to source APIs at runtime and to prompt the <code>AUTO_MERGE</code> to update the merged API endpoint with the source API changes automatically.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mergedApiExecutionRoleArn(java.lang.String mergedApiExecutionRoleArn) {
            this.mergedApiExecutionRoleArn = mergedApiExecutionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getOpenIdConnectConfig}
         * @param openIdConnectConfig The OpenID Connect configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectConfig(software.amazon.awscdk.IResolvable openIdConnectConfig) {
            this.openIdConnectConfig = openIdConnectConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getOpenIdConnectConfig}
         * @param openIdConnectConfig The OpenID Connect configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.OpenIDConnectConfigProperty openIdConnectConfig) {
            this.openIdConnectConfig = openIdConnectConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getOwnerContact}
         * @param ownerContact The owner contact information for an API resource.
         *                     This field accepts any string input with a length of 0 - 256 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerContact(java.lang.String ownerContact) {
            this.ownerContact = ownerContact;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getQueryDepthLimit}
         * @param queryDepthLimit The maximum depth a query can have in a single request.
         *                        Depth refers to the amount of nested levels allowed in the body of query. The default value is <code>0</code> (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between <code>1</code> and <code>75</code> nested levels. This field will produce a limit error if the operation falls out of bounds. Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryDepthLimit(java.lang.Number queryDepthLimit) {
            this.queryDepthLimit = queryDepthLimit;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getResolverCountLimit}
         * @param resolverCountLimit The maximum number of resolvers that can be invoked in a single request.
         *                           The default value is <code>0</code> (or unspecified), which will set the limit to <code>10000</code> . When specified, the limit value can be between <code>1</code> and <code>10000</code> . This field will produce a limit error if the operation falls out of bounds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolverCountLimit(java.lang.Number resolverCountLimit) {
            this.resolverCountLimit = resolverCountLimit;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getTags}
         * @param tags An arbitrary set of tags (key-value pairs) for this GraphQL API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getUserPoolConfig}
         * @param userPoolConfig Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolConfig(software.amazon.awscdk.IResolvable userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getUserPoolConfig}
         * @param userPoolConfig Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.UserPoolConfigProperty userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getVisibility}
         * @param visibility Sets the scope of the GraphQL API to public ( <code>GLOBAL</code> ) or private ( <code>PRIVATE</code> ).
         *                   By default, the scope is set to <code>Global</code> if no value is provided.
         *                   <p>
         *                   <em>WARNING</em> : If <code>Visibility</code> has not been defined, <em>explicitly</em> setting it to <code>GLOBAL</code> in a template/stack update will result in an API replacement and new DNS values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibility(java.lang.String visibility) {
            this.visibility = visibility;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getXrayEnabled}
         * @param xrayEnabled A flag indicating whether to use AWS X-Ray tracing for this <code>GraphqlApi</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xrayEnabled(java.lang.Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getXrayEnabled}
         * @param xrayEnabled A flag indicating whether to use AWS X-Ray tracing for this <code>GraphqlApi</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xrayEnabled(software.amazon.awscdk.IResolvable xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGraphQLApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGraphQLApiProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGraphQLApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGraphQLApiProps {
        private final java.lang.String authenticationType;
        private final java.lang.String name;
        private final java.lang.Object additionalAuthenticationProviders;
        private final java.lang.String apiType;
        private final java.lang.Object enhancedMetricsConfig;
        private final java.lang.Object environmentVariables;
        private final java.lang.String introspectionConfig;
        private final java.lang.Object lambdaAuthorizerConfig;
        private final java.lang.Object logConfig;
        private final java.lang.String mergedApiExecutionRoleArn;
        private final java.lang.Object openIdConnectConfig;
        private final java.lang.String ownerContact;
        private final java.lang.Number queryDepthLimit;
        private final java.lang.Number resolverCountLimit;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object userPoolConfig;
        private final java.lang.String visibility;
        private final java.lang.Object xrayEnabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.additionalAuthenticationProviders = software.amazon.jsii.Kernel.get(this, "additionalAuthenticationProviders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.apiType = software.amazon.jsii.Kernel.get(this, "apiType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enhancedMetricsConfig = software.amazon.jsii.Kernel.get(this, "enhancedMetricsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.introspectionConfig = software.amazon.jsii.Kernel.get(this, "introspectionConfig", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lambdaAuthorizerConfig = software.amazon.jsii.Kernel.get(this, "lambdaAuthorizerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logConfig = software.amazon.jsii.Kernel.get(this, "logConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mergedApiExecutionRoleArn = software.amazon.jsii.Kernel.get(this, "mergedApiExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.openIdConnectConfig = software.amazon.jsii.Kernel.get(this, "openIdConnectConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ownerContact = software.amazon.jsii.Kernel.get(this, "ownerContact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryDepthLimit = software.amazon.jsii.Kernel.get(this, "queryDepthLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.resolverCountLimit = software.amazon.jsii.Kernel.get(this, "resolverCountLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.userPoolConfig = software.amazon.jsii.Kernel.get(this, "userPoolConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.visibility = software.amazon.jsii.Kernel.get(this, "visibility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.xrayEnabled = software.amazon.jsii.Kernel.get(this, "xrayEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authenticationType = java.util.Objects.requireNonNull(builder.authenticationType, "authenticationType is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.additionalAuthenticationProviders = builder.additionalAuthenticationProviders;
            this.apiType = builder.apiType;
            this.enhancedMetricsConfig = builder.enhancedMetricsConfig;
            this.environmentVariables = builder.environmentVariables;
            this.introspectionConfig = builder.introspectionConfig;
            this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
            this.logConfig = builder.logConfig;
            this.mergedApiExecutionRoleArn = builder.mergedApiExecutionRoleArn;
            this.openIdConnectConfig = builder.openIdConnectConfig;
            this.ownerContact = builder.ownerContact;
            this.queryDepthLimit = builder.queryDepthLimit;
            this.resolverCountLimit = builder.resolverCountLimit;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.userPoolConfig = builder.userPoolConfig;
            this.visibility = builder.visibility;
            this.xrayEnabled = builder.xrayEnabled;
        }

        @Override
        public final java.lang.String getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getAdditionalAuthenticationProviders() {
            return this.additionalAuthenticationProviders;
        }

        @Override
        public final java.lang.String getApiType() {
            return this.apiType;
        }

        @Override
        public final java.lang.Object getEnhancedMetricsConfig() {
            return this.enhancedMetricsConfig;
        }

        @Override
        public final java.lang.Object getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final java.lang.String getIntrospectionConfig() {
            return this.introspectionConfig;
        }

        @Override
        public final java.lang.Object getLambdaAuthorizerConfig() {
            return this.lambdaAuthorizerConfig;
        }

        @Override
        public final java.lang.Object getLogConfig() {
            return this.logConfig;
        }

        @Override
        public final java.lang.String getMergedApiExecutionRoleArn() {
            return this.mergedApiExecutionRoleArn;
        }

        @Override
        public final java.lang.Object getOpenIdConnectConfig() {
            return this.openIdConnectConfig;
        }

        @Override
        public final java.lang.String getOwnerContact() {
            return this.ownerContact;
        }

        @Override
        public final java.lang.Number getQueryDepthLimit() {
            return this.queryDepthLimit;
        }

        @Override
        public final java.lang.Number getResolverCountLimit() {
            return this.resolverCountLimit;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getUserPoolConfig() {
            return this.userPoolConfig;
        }

        @Override
        public final java.lang.String getVisibility() {
            return this.visibility;
        }

        @Override
        public final java.lang.Object getXrayEnabled() {
            return this.xrayEnabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getAdditionalAuthenticationProviders() != null) {
                data.set("additionalAuthenticationProviders", om.valueToTree(this.getAdditionalAuthenticationProviders()));
            }
            if (this.getApiType() != null) {
                data.set("apiType", om.valueToTree(this.getApiType()));
            }
            if (this.getEnhancedMetricsConfig() != null) {
                data.set("enhancedMetricsConfig", om.valueToTree(this.getEnhancedMetricsConfig()));
            }
            if (this.getEnvironmentVariables() != null) {
                data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
            }
            if (this.getIntrospectionConfig() != null) {
                data.set("introspectionConfig", om.valueToTree(this.getIntrospectionConfig()));
            }
            if (this.getLambdaAuthorizerConfig() != null) {
                data.set("lambdaAuthorizerConfig", om.valueToTree(this.getLambdaAuthorizerConfig()));
            }
            if (this.getLogConfig() != null) {
                data.set("logConfig", om.valueToTree(this.getLogConfig()));
            }
            if (this.getMergedApiExecutionRoleArn() != null) {
                data.set("mergedApiExecutionRoleArn", om.valueToTree(this.getMergedApiExecutionRoleArn()));
            }
            if (this.getOpenIdConnectConfig() != null) {
                data.set("openIdConnectConfig", om.valueToTree(this.getOpenIdConnectConfig()));
            }
            if (this.getOwnerContact() != null) {
                data.set("ownerContact", om.valueToTree(this.getOwnerContact()));
            }
            if (this.getQueryDepthLimit() != null) {
                data.set("queryDepthLimit", om.valueToTree(this.getQueryDepthLimit()));
            }
            if (this.getResolverCountLimit() != null) {
                data.set("resolverCountLimit", om.valueToTree(this.getResolverCountLimit()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUserPoolConfig() != null) {
                data.set("userPoolConfig", om.valueToTree(this.getUserPoolConfig()));
            }
            if (this.getVisibility() != null) {
                data.set("visibility", om.valueToTree(this.getVisibility()));
            }
            if (this.getXrayEnabled() != null) {
                data.set("xrayEnabled", om.valueToTree(this.getXrayEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGraphQLApiProps.Jsii$Proxy that = (CfnGraphQLApiProps.Jsii$Proxy) o;

            if (!authenticationType.equals(that.authenticationType)) return false;
            if (!name.equals(that.name)) return false;
            if (this.additionalAuthenticationProviders != null ? !this.additionalAuthenticationProviders.equals(that.additionalAuthenticationProviders) : that.additionalAuthenticationProviders != null) return false;
            if (this.apiType != null ? !this.apiType.equals(that.apiType) : that.apiType != null) return false;
            if (this.enhancedMetricsConfig != null ? !this.enhancedMetricsConfig.equals(that.enhancedMetricsConfig) : that.enhancedMetricsConfig != null) return false;
            if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
            if (this.introspectionConfig != null ? !this.introspectionConfig.equals(that.introspectionConfig) : that.introspectionConfig != null) return false;
            if (this.lambdaAuthorizerConfig != null ? !this.lambdaAuthorizerConfig.equals(that.lambdaAuthorizerConfig) : that.lambdaAuthorizerConfig != null) return false;
            if (this.logConfig != null ? !this.logConfig.equals(that.logConfig) : that.logConfig != null) return false;
            if (this.mergedApiExecutionRoleArn != null ? !this.mergedApiExecutionRoleArn.equals(that.mergedApiExecutionRoleArn) : that.mergedApiExecutionRoleArn != null) return false;
            if (this.openIdConnectConfig != null ? !this.openIdConnectConfig.equals(that.openIdConnectConfig) : that.openIdConnectConfig != null) return false;
            if (this.ownerContact != null ? !this.ownerContact.equals(that.ownerContact) : that.ownerContact != null) return false;
            if (this.queryDepthLimit != null ? !this.queryDepthLimit.equals(that.queryDepthLimit) : that.queryDepthLimit != null) return false;
            if (this.resolverCountLimit != null ? !this.resolverCountLimit.equals(that.resolverCountLimit) : that.resolverCountLimit != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.userPoolConfig != null ? !this.userPoolConfig.equals(that.userPoolConfig) : that.userPoolConfig != null) return false;
            if (this.visibility != null ? !this.visibility.equals(that.visibility) : that.visibility != null) return false;
            return this.xrayEnabled != null ? this.xrayEnabled.equals(that.xrayEnabled) : that.xrayEnabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authenticationType.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.additionalAuthenticationProviders != null ? this.additionalAuthenticationProviders.hashCode() : 0);
            result = 31 * result + (this.apiType != null ? this.apiType.hashCode() : 0);
            result = 31 * result + (this.enhancedMetricsConfig != null ? this.enhancedMetricsConfig.hashCode() : 0);
            result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
            result = 31 * result + (this.introspectionConfig != null ? this.introspectionConfig.hashCode() : 0);
            result = 31 * result + (this.lambdaAuthorizerConfig != null ? this.lambdaAuthorizerConfig.hashCode() : 0);
            result = 31 * result + (this.logConfig != null ? this.logConfig.hashCode() : 0);
            result = 31 * result + (this.mergedApiExecutionRoleArn != null ? this.mergedApiExecutionRoleArn.hashCode() : 0);
            result = 31 * result + (this.openIdConnectConfig != null ? this.openIdConnectConfig.hashCode() : 0);
            result = 31 * result + (this.ownerContact != null ? this.ownerContact.hashCode() : 0);
            result = 31 * result + (this.queryDepthLimit != null ? this.queryDepthLimit.hashCode() : 0);
            result = 31 * result + (this.resolverCountLimit != null ? this.resolverCountLimit.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.userPoolConfig != null ? this.userPoolConfig.hashCode() : 0);
            result = 31 * result + (this.visibility != null ? this.visibility.hashCode() : 0);
            result = 31 * result + (this.xrayEnabled != null ? this.xrayEnabled.hashCode() : 0);
            return result;
        }
    }
}
