package software.amazon.awscdk.services.appsync;

/**
 * A Channel Namespace.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EventApi api;
 * ChannelNamespace.Builder.create(this, "Namespace")
 *         .api(api)
 *         .authorizationConfig(NamespaceAuthConfig.builder()
 *                 // Override publishing authorization to API Key
 *                 .publishAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 // Override subscribing authorization to Lambda
 *                 .subscribeAuthModeTypes(List.of(AppSyncAuthorizationType.LAMBDA))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:10.413Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.ChannelNamespace")
public class ChannelNamespace extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.appsync.IChannelNamespace {

    protected ChannelNamespace(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ChannelNamespace(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appsync.ChannelNamespace.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ChannelNamespace(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ChannelNamespaceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Use an existing channel namespace by ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param channelNamespaceArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IChannelNamespace fromChannelNamespaceArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String channelNamespaceArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.ChannelNamespace.class, "fromChannelNamespaceArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IChannelNamespace.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(channelNamespaceArn, "channelNamespaceArn is required") });
    }

    /**
     * Adds an IAM policy statement for EventPublish access to this channel namespace to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPublish(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantPublish", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Adds an IAM policy statement for EventPublish and EventSubscribe access to this channel namespace to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPublishAndSubscribe(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantPublishAndSubscribe", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Adds an IAM policy statement for EventSubscribe access to this channel namespace to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSubscribe(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantSubscribe", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * the ARN of the channel namespace.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getChannelNamespaceArn() {
        return software.amazon.jsii.Kernel.get(this, "channelNamespaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.ChannelNamespace}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.ChannelNamespace> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.ChannelNamespaceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.ChannelNamespaceProps.Builder();
        }

        /**
         * Authorization config for channel namespace.
         * <p>
         * Default: - defaults to Event API default auth config
         * <p>
         * @return {@code this}
         * @param authorizationConfig Authorization config for channel namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationConfig(final software.amazon.awscdk.services.appsync.NamespaceAuthConfig authorizationConfig) {
            this.props.authorizationConfig(authorizationConfig);
            return this;
        }

        /**
         * the name of the channel namespace.
         * <p>
         * Default: - the construct's id will be used
         * <p>
         * @return {@code this}
         * @param channelNamespaceName the name of the channel namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelNamespaceName(final java.lang.String channelNamespaceName) {
            this.props.channelNamespaceName(channelNamespaceName);
            return this;
        }

        /**
         * The Event Handler code.
         * <p>
         * Default: - no code is used
         * <p>
         * @return {@code this}
         * @param code The Event Handler code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.services.appsync.Code code) {
            this.props.code(code);
            return this;
        }

        /**
         * onPublish handler config.
         * <p>
         * Default: - no handler config
         * <p>
         * @return {@code this}
         * @param publishHandlerConfig onPublish handler config. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishHandlerConfig(final software.amazon.awscdk.services.appsync.HandlerConfig publishHandlerConfig) {
            this.props.publishHandlerConfig(publishHandlerConfig);
            return this;
        }

        /**
         * onSubscribe handler config.
         * <p>
         * Default: - no handler config
         * <p>
         * @return {@code this}
         * @param subscribeHandlerConfig onSubscribe handler config. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscribeHandlerConfig(final software.amazon.awscdk.services.appsync.HandlerConfig subscribeHandlerConfig) {
            this.props.subscribeHandlerConfig(subscribeHandlerConfig);
            return this;
        }

        /**
         * The API this channel namespace is associated with.
         * <p>
         * @return {@code this}
         * @param api The API this channel namespace is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(final software.amazon.awscdk.services.appsync.IEventApi api) {
            this.props.api(api);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.ChannelNamespace}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.ChannelNamespace build() {
            return new software.amazon.awscdk.services.appsync.ChannelNamespace(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
