package software.amazon.awscdk.services.autoscaling;

/**
 * InstancesDistribution is a subproperty of MixedInstancesPolicy that describes an instances distribution for an Auto Scaling group.
 * <p>
 * The instances distribution specifies the distribution of On-Demand Instances
 * and Spot Instances, the maximum price to pay for Spot Instances, and how the Auto Scaling group allocates
 * instance types to fulfill On-Demand and Spot capacities.
 * <p>
 * For more information and example configurations, see Auto Scaling groups with multiple instance types
 * and purchase options in the Amazon EC2 Auto Scaling User Guide:
 * <p>
 * https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * LaunchTemplate launchTemplate1;
 * LaunchTemplate launchTemplate2;
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .mixedInstancesPolicy(MixedInstancesPolicy.builder()
 *                 .instancesDistribution(InstancesDistribution.builder()
 *                         .onDemandPercentageAboveBaseCapacity(50)
 *                         .build())
 *                 .launchTemplate(launchTemplate1)
 *                 .launchTemplateOverrides(List.of(LaunchTemplateOverrides.builder().instanceType(new InstanceType("t3.micro")).build(), LaunchTemplateOverrides.builder().instanceType(new InstanceType("t3a.micro")).build(), LaunchTemplateOverrides.builder().instanceType(new InstanceType("t4g.micro")).launchTemplate(launchTemplate2).build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:10.754Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.InstancesDistribution")
@software.amazon.jsii.Jsii.Proxy(InstancesDistribution.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InstancesDistribution extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates how to allocate instance types to fulfill On-Demand capacity.
     * <p>
     * The only valid value is prioritized,
     * which is also the default value.
     * <p>
     * Default: OnDemandAllocationStrategy.PRIORITIZED
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.OnDemandAllocationStrategy getOnDemandAllocationStrategy() {
        return null;
    }

    /**
     * The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances.
     * <p>
     * This
     * base portion is provisioned first as your group scales. Defaults to 0 if not specified. If you specify weights
     * for the instance types in the overrides, set the value of OnDemandBaseCapacity in terms of the number of
     * capacity units, and not the number of instances.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getOnDemandBaseCapacity() {
        return null;
    }

    /**
     * Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
     * <p>
     * Expressed as a number (for example, 20 specifies 20% On-Demand Instances, 80% Spot Instances).
     * Defaults to 100 if not specified. If set to 100, only On-Demand Instances are provisioned.
     * <p>
     * Default: 100
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getOnDemandPercentageAboveBaseCapacity() {
        return null;
    }

    /**
     * If the allocation strategy is lowest-price, the Auto Scaling group launches instances using the Spot pools with the lowest price, and evenly allocates your instances across the number of Spot pools that you specify.
     * <p>
     * Defaults to
     * lowest-price if not specified.
     * <p>
     * If the allocation strategy is capacity-optimized (recommended), the Auto Scaling group launches instances using Spot
     * pools that are optimally chosen based on the available Spot capacity. Alternatively, you can use capacity-optimized-prioritized
     * and set the order of instance types in the list of launch template overrides from highest to lowest priority
     * (from first to last in the list). Amazon EC2 Auto Scaling honors the instance type priorities on a best-effort basis but
     * optimizes for capacity first.
     * <p>
     * Default: SpotAllocationStrategy.LOWEST_PRICE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.SpotAllocationStrategy getSpotAllocationStrategy() {
        return null;
    }

    /**
     * The number of Spot Instance pools to use to allocate your Spot capacity.
     * <p>
     * The Spot pools are determined from the different instance
     * types in the overrides. Valid only when the Spot allocation strategy is lowest-price. Value must be in the range of 1 to 20.
     * Defaults to 2 if not specified.
     * <p>
     * Default: 2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSpotInstancePools() {
        return null;
    }

    /**
     * The maximum price per unit hour that you are willing to pay for a Spot Instance.
     * <p>
     * If you leave the value at its default (empty),
     * Amazon EC2 Auto Scaling uses the On-Demand price as the maximum Spot price. To remove a value that you previously set, include
     * the property but specify an empty string ("") for the value.
     * <p>
     * Default: "" - On-Demand price
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSpotMaxPrice() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InstancesDistribution}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InstancesDistribution}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InstancesDistribution> {
        software.amazon.awscdk.services.autoscaling.OnDemandAllocationStrategy onDemandAllocationStrategy;
        java.lang.Number onDemandBaseCapacity;
        java.lang.Number onDemandPercentageAboveBaseCapacity;
        software.amazon.awscdk.services.autoscaling.SpotAllocationStrategy spotAllocationStrategy;
        java.lang.Number spotInstancePools;
        java.lang.String spotMaxPrice;

        /**
         * Sets the value of {@link InstancesDistribution#getOnDemandAllocationStrategy}
         * @param onDemandAllocationStrategy Indicates how to allocate instance types to fulfill On-Demand capacity.
         *                                   The only valid value is prioritized,
         *                                   which is also the default value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDemandAllocationStrategy(software.amazon.awscdk.services.autoscaling.OnDemandAllocationStrategy onDemandAllocationStrategy) {
            this.onDemandAllocationStrategy = onDemandAllocationStrategy;
            return this;
        }

        /**
         * Sets the value of {@link InstancesDistribution#getOnDemandBaseCapacity}
         * @param onDemandBaseCapacity The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances.
         *                             This
         *                             base portion is provisioned first as your group scales. Defaults to 0 if not specified. If you specify weights
         *                             for the instance types in the overrides, set the value of OnDemandBaseCapacity in terms of the number of
         *                             capacity units, and not the number of instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDemandBaseCapacity(java.lang.Number onDemandBaseCapacity) {
            this.onDemandBaseCapacity = onDemandBaseCapacity;
            return this;
        }

        /**
         * Sets the value of {@link InstancesDistribution#getOnDemandPercentageAboveBaseCapacity}
         * @param onDemandPercentageAboveBaseCapacity Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
         *                                            Expressed as a number (for example, 20 specifies 20% On-Demand Instances, 80% Spot Instances).
         *                                            Defaults to 100 if not specified. If set to 100, only On-Demand Instances are provisioned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDemandPercentageAboveBaseCapacity(java.lang.Number onDemandPercentageAboveBaseCapacity) {
            this.onDemandPercentageAboveBaseCapacity = onDemandPercentageAboveBaseCapacity;
            return this;
        }

        /**
         * Sets the value of {@link InstancesDistribution#getSpotAllocationStrategy}
         * @param spotAllocationStrategy If the allocation strategy is lowest-price, the Auto Scaling group launches instances using the Spot pools with the lowest price, and evenly allocates your instances across the number of Spot pools that you specify.
         *                               Defaults to
         *                               lowest-price if not specified.
         *                               <p>
         *                               If the allocation strategy is capacity-optimized (recommended), the Auto Scaling group launches instances using Spot
         *                               pools that are optimally chosen based on the available Spot capacity. Alternatively, you can use capacity-optimized-prioritized
         *                               and set the order of instance types in the list of launch template overrides from highest to lowest priority
         *                               (from first to last in the list). Amazon EC2 Auto Scaling honors the instance type priorities on a best-effort basis but
         *                               optimizes for capacity first.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotAllocationStrategy(software.amazon.awscdk.services.autoscaling.SpotAllocationStrategy spotAllocationStrategy) {
            this.spotAllocationStrategy = spotAllocationStrategy;
            return this;
        }

        /**
         * Sets the value of {@link InstancesDistribution#getSpotInstancePools}
         * @param spotInstancePools The number of Spot Instance pools to use to allocate your Spot capacity.
         *                          The Spot pools are determined from the different instance
         *                          types in the overrides. Valid only when the Spot allocation strategy is lowest-price. Value must be in the range of 1 to 20.
         *                          Defaults to 2 if not specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotInstancePools(java.lang.Number spotInstancePools) {
            this.spotInstancePools = spotInstancePools;
            return this;
        }

        /**
         * Sets the value of {@link InstancesDistribution#getSpotMaxPrice}
         * @param spotMaxPrice The maximum price per unit hour that you are willing to pay for a Spot Instance.
         *                     If you leave the value at its default (empty),
         *                     Amazon EC2 Auto Scaling uses the On-Demand price as the maximum Spot price. To remove a value that you previously set, include
         *                     the property but specify an empty string ("") for the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotMaxPrice(java.lang.String spotMaxPrice) {
            this.spotMaxPrice = spotMaxPrice;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InstancesDistribution}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InstancesDistribution build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InstancesDistribution}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstancesDistribution {
        private final software.amazon.awscdk.services.autoscaling.OnDemandAllocationStrategy onDemandAllocationStrategy;
        private final java.lang.Number onDemandBaseCapacity;
        private final java.lang.Number onDemandPercentageAboveBaseCapacity;
        private final software.amazon.awscdk.services.autoscaling.SpotAllocationStrategy spotAllocationStrategy;
        private final java.lang.Number spotInstancePools;
        private final java.lang.String spotMaxPrice;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.onDemandAllocationStrategy = software.amazon.jsii.Kernel.get(this, "onDemandAllocationStrategy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.OnDemandAllocationStrategy.class));
            this.onDemandBaseCapacity = software.amazon.jsii.Kernel.get(this, "onDemandBaseCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.onDemandPercentageAboveBaseCapacity = software.amazon.jsii.Kernel.get(this, "onDemandPercentageAboveBaseCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.spotAllocationStrategy = software.amazon.jsii.Kernel.get(this, "spotAllocationStrategy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.SpotAllocationStrategy.class));
            this.spotInstancePools = software.amazon.jsii.Kernel.get(this, "spotInstancePools", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.spotMaxPrice = software.amazon.jsii.Kernel.get(this, "spotMaxPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.onDemandAllocationStrategy = builder.onDemandAllocationStrategy;
            this.onDemandBaseCapacity = builder.onDemandBaseCapacity;
            this.onDemandPercentageAboveBaseCapacity = builder.onDemandPercentageAboveBaseCapacity;
            this.spotAllocationStrategy = builder.spotAllocationStrategy;
            this.spotInstancePools = builder.spotInstancePools;
            this.spotMaxPrice = builder.spotMaxPrice;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.OnDemandAllocationStrategy getOnDemandAllocationStrategy() {
            return this.onDemandAllocationStrategy;
        }

        @Override
        public final java.lang.Number getOnDemandBaseCapacity() {
            return this.onDemandBaseCapacity;
        }

        @Override
        public final java.lang.Number getOnDemandPercentageAboveBaseCapacity() {
            return this.onDemandPercentageAboveBaseCapacity;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.SpotAllocationStrategy getSpotAllocationStrategy() {
            return this.spotAllocationStrategy;
        }

        @Override
        public final java.lang.Number getSpotInstancePools() {
            return this.spotInstancePools;
        }

        @Override
        public final java.lang.String getSpotMaxPrice() {
            return this.spotMaxPrice;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getOnDemandAllocationStrategy() != null) {
                data.set("onDemandAllocationStrategy", om.valueToTree(this.getOnDemandAllocationStrategy()));
            }
            if (this.getOnDemandBaseCapacity() != null) {
                data.set("onDemandBaseCapacity", om.valueToTree(this.getOnDemandBaseCapacity()));
            }
            if (this.getOnDemandPercentageAboveBaseCapacity() != null) {
                data.set("onDemandPercentageAboveBaseCapacity", om.valueToTree(this.getOnDemandPercentageAboveBaseCapacity()));
            }
            if (this.getSpotAllocationStrategy() != null) {
                data.set("spotAllocationStrategy", om.valueToTree(this.getSpotAllocationStrategy()));
            }
            if (this.getSpotInstancePools() != null) {
                data.set("spotInstancePools", om.valueToTree(this.getSpotInstancePools()));
            }
            if (this.getSpotMaxPrice() != null) {
                data.set("spotMaxPrice", om.valueToTree(this.getSpotMaxPrice()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.InstancesDistribution"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InstancesDistribution.Jsii$Proxy that = (InstancesDistribution.Jsii$Proxy) o;

            if (this.onDemandAllocationStrategy != null ? !this.onDemandAllocationStrategy.equals(that.onDemandAllocationStrategy) : that.onDemandAllocationStrategy != null) return false;
            if (this.onDemandBaseCapacity != null ? !this.onDemandBaseCapacity.equals(that.onDemandBaseCapacity) : that.onDemandBaseCapacity != null) return false;
            if (this.onDemandPercentageAboveBaseCapacity != null ? !this.onDemandPercentageAboveBaseCapacity.equals(that.onDemandPercentageAboveBaseCapacity) : that.onDemandPercentageAboveBaseCapacity != null) return false;
            if (this.spotAllocationStrategy != null ? !this.spotAllocationStrategy.equals(that.spotAllocationStrategy) : that.spotAllocationStrategy != null) return false;
            if (this.spotInstancePools != null ? !this.spotInstancePools.equals(that.spotInstancePools) : that.spotInstancePools != null) return false;
            return this.spotMaxPrice != null ? this.spotMaxPrice.equals(that.spotMaxPrice) : that.spotMaxPrice == null;
        }

        @Override
        public final int hashCode() {
            int result = this.onDemandAllocationStrategy != null ? this.onDemandAllocationStrategy.hashCode() : 0;
            result = 31 * result + (this.onDemandBaseCapacity != null ? this.onDemandBaseCapacity.hashCode() : 0);
            result = 31 * result + (this.onDemandPercentageAboveBaseCapacity != null ? this.onDemandPercentageAboveBaseCapacity.hashCode() : 0);
            result = 31 * result + (this.spotAllocationStrategy != null ? this.spotAllocationStrategy.hashCode() : 0);
            result = 31 * result + (this.spotInstancePools != null ? this.spotInstancePools.hashCode() : 0);
            result = 31 * result + (this.spotMaxPrice != null ? this.spotMaxPrice.hashCode() : 0);
            return result;
        }
    }
}
