package software.amazon.awscdk.services.autoscaling;

/**
 * Define a life cycle hook.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.autoscaling.*;
 * import software.amazon.awscdk.services.iam.*;
 * AutoScalingGroup autoScalingGroup;
 * ILifecycleHookTarget lifecycleHookTarget;
 * Role role;
 * LifecycleHook lifecycleHook = LifecycleHook.Builder.create(this, "MyLifecycleHook")
 *         .autoScalingGroup(autoScalingGroup)
 *         .lifecycleTransition(LifecycleTransition.INSTANCE_LAUNCHING)
 *         // the properties below are optional
 *         .defaultResult(DefaultResult.CONTINUE)
 *         .heartbeatTimeout(Duration.minutes(30))
 *         .lifecycleHookName("lifecycleHookName")
 *         .notificationMetadata("notificationMetadata")
 *         .notificationTarget(lifecycleHookTarget)
 *         .role(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:10.756Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.LifecycleHook")
public class LifecycleHook extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.autoscaling.ILifecycleHook {

    protected LifecycleHook(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LifecycleHook(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.autoscaling.LifecycleHook.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LifecycleHook(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.LifecycleHookProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The name of this lifecycle hook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLifecycleHookName() {
        return software.amazon.jsii.Kernel.get(this, "lifecycleHookName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The role that allows the ASG to publish to the notification target.
     * <p>
     * Default: - A default role is created if 'notificationTarget' is specified.
     * Otherwise, no role is created.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.autoscaling.LifecycleHook}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.autoscaling.LifecycleHook> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.autoscaling.LifecycleHookProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.autoscaling.LifecycleHookProps.Builder();
        }

        /**
         * The state of the Amazon EC2 instance to which you want to attach the lifecycle hook.
         * <p>
         * @return {@code this}
         * @param lifecycleTransition The state of the Amazon EC2 instance to which you want to attach the lifecycle hook. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleTransition(final software.amazon.awscdk.services.autoscaling.LifecycleTransition lifecycleTransition) {
            this.props.lifecycleTransition(lifecycleTransition);
            return this;
        }

        /**
         * The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure occurs.
         * <p>
         * Default: Continue
         * <p>
         * @return {@code this}
         * @param defaultResult The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure occurs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultResult(final software.amazon.awscdk.services.autoscaling.DefaultResult defaultResult) {
            this.props.defaultResult(defaultResult);
            return this;
        }

        /**
         * Maximum time between calls to RecordLifecycleActionHeartbeat for the hook.
         * <p>
         * If the lifecycle hook times out, perform the action in DefaultResult.
         * <p>
         * Default: - No heartbeat timeout.
         * <p>
         * @return {@code this}
         * @param heartbeatTimeout Maximum time between calls to RecordLifecycleActionHeartbeat for the hook. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(final software.amazon.awscdk.Duration heartbeatTimeout) {
            this.props.heartbeatTimeout(heartbeatTimeout);
            return this;
        }

        /**
         * Name of the lifecycle hook.
         * <p>
         * Default: - Automatically generated name.
         * <p>
         * @return {@code this}
         * @param lifecycleHookName Name of the lifecycle hook. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleHookName(final java.lang.String lifecycleHookName) {
            this.props.lifecycleHookName(lifecycleHookName);
            return this;
        }

        /**
         * Additional data to pass to the lifecycle hook target.
         * <p>
         * Default: - No metadata.
         * <p>
         * @return {@code this}
         * @param notificationMetadata Additional data to pass to the lifecycle hook target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationMetadata(final java.lang.String notificationMetadata) {
            this.props.notificationMetadata(notificationMetadata);
            return this;
        }

        /**
         * The target of the lifecycle hook.
         * <p>
         * Default: - No target.
         * <p>
         * @return {@code this}
         * @param notificationTarget The target of the lifecycle hook. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTarget(final software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget notificationTarget) {
            this.props.notificationTarget(notificationTarget);
            return this;
        }

        /**
         * The role that allows publishing to the notification target.
         * <p>
         * Default: - A role will be created if a target is provided. Otherwise, no role is created.
         * <p>
         * @return {@code this}
         * @param role The role that allows publishing to the notification target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The AutoScalingGroup to add the lifecycle hook to.
         * <p>
         * @return {@code this}
         * @param autoScalingGroup The AutoScalingGroup to add the lifecycle hook to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroup(final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup) {
            this.props.autoScalingGroup(autoScalingGroup);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.autoscaling.LifecycleHook}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.autoscaling.LifecycleHook build() {
            return new software.amazon.awscdk.services.autoscaling.LifecycleHook(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
