package software.amazon.awscdk.services.batch;

/**
 * Represents a Fairshare Scheduling Policy. Instructs the scheduler to allocate ComputeEnvironment vCPUs based on Job shareIdentifiers.
 * <p>
 * The Faireshare Scheduling Policy ensures that each share gets a certain amount of vCPUs.
 * The scheduler does this by deciding how many Jobs of each share to schedule <em>relative to how many jobs of
 * each share are currently being executed by the ComputeEnvironment</em>. The weight factors associated with
 * each share determine the ratio of vCPUs allocated; see the readme for a more in-depth discussion of
 * fairshare policies.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FairshareSchedulingPolicy fairsharePolicy = new FairshareSchedulingPolicy(this, "myFairsharePolicy");
 * fairsharePolicy.addShare(Share.builder()
 *         .shareIdentifier("A")
 *         .weightFactor(1)
 *         .build());
 * fairsharePolicy.addShare(Share.builder()
 *         .shareIdentifier("B")
 *         .weightFactor(1)
 *         .build());
 * JobQueue.Builder.create(this, "JobQueue")
 *         .schedulingPolicy(fairsharePolicy)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:11.036Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.FairshareSchedulingPolicy")
public class FairshareSchedulingPolicy extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.batch.IFairshareSchedulingPolicy, software.amazon.awscdk.services.batch.ISchedulingPolicy {

    protected FairshareSchedulingPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FairshareSchedulingPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.batch.FairshareSchedulingPolicy.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FairshareSchedulingPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.FairshareSchedulingPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FairshareSchedulingPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Reference an exisiting Scheduling Policy by its ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param fairshareSchedulingPolicyArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IFairshareSchedulingPolicy fromFairshareSchedulingPolicyArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String fairshareSchedulingPolicyArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.FairshareSchedulingPolicy.class, "fromFairshareSchedulingPolicyArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IFairshareSchedulingPolicy.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(fairshareSchedulingPolicyArn, "fairshareSchedulingPolicyArn is required") });
    }

    /**
     * Add a share this to this Fairshare SchedulingPolicy.
     * <p>
     * @param share This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addShare(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Share share) {
        software.amazon.jsii.Kernel.call(this, "addShare", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(share, "share is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The arn of this scheduling policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSchedulingPolicyArn() {
        return software.amazon.jsii.Kernel.get(this, "schedulingPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this scheduling policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSchedulingPolicyName() {
        return software.amazon.jsii.Kernel.get(this, "schedulingPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The shares that this Scheduling Policy applies to.
     * <p>
     * <em>Note</em>: It is possible to submit Jobs to the queue with Share Identifiers that
     * are not recognized by the Scheduling Policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.Share> getShares() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "shares", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Share.class))));
    }

    /**
     * Used to calculate the percentage of the maximum available vCPU to reserve for share identifiers not present in the Queue.
     * <p>
     * The percentage reserved is defined by the Scheduler as:
     * <code>(computeReservation/100)^ActiveFairShares</code> where <code>ActiveFairShares</code> is the number of active fair share identifiers.
     * <p>
     * For example, a computeReservation value of 50 indicates that AWS Batch reserves 50% of the
     * maximum available vCPU if there's only one fair share identifier.
     * It reserves 25% if there are two fair share identifiers.
     * It reserves 12.5% if there are three fair share identifiers.
     * <p>
     * A computeReservation value of 25 indicates that AWS Batch should reserve 25% of the
     * maximum available vCPU if there's only one fair share identifier,
     * 6.25% if there are two fair share identifiers,
     * and 1.56% if there are three fair share identifiers.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getComputeReservation() {
        return software.amazon.jsii.Kernel.get(this, "computeReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of time to use to measure the usage of each job.
     * <p>
     * The usage is used to calculate a fair share percentage for each fair share identifier currently in the Queue.
     * A value of zero (0) indicates that only current usage is measured.
     * The decay is linear and gives preference to newer jobs.
     * <p>
     * The maximum supported value is 604800 seconds (1 week).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getShareDecay() {
        return software.amazon.jsii.Kernel.get(this, "shareDecay", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.FairshareSchedulingPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.FairshareSchedulingPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.batch.FairshareSchedulingPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Used to calculate the percentage of the maximum available vCPU to reserve for share identifiers not present in the Queue.
         * <p>
         * The percentage reserved is defined by the Scheduler as:
         * <code>(computeReservation/100)^ActiveFairShares</code> where <code>ActiveFairShares</code> is the number of active fair share identifiers.
         * <p>
         * For example, a computeReservation value of 50 indicates that AWS Batch reserves 50% of the
         * maximum available vCPU if there's only one fair share identifier.
         * It reserves 25% if there are two fair share identifiers.
         * It reserves 12.5% if there are three fair share identifiers.
         * <p>
         * A computeReservation value of 25 indicates that AWS Batch should reserve 25% of the
         * maximum available vCPU if there's only one fair share identifier,
         * 6.25% if there are two fair share identifiers,
         * and 1.56% if there are three fair share identifiers.
         * <p>
         * Default: - no vCPU is reserved
         * <p>
         * @return {@code this}
         * @param computeReservation Used to calculate the percentage of the maximum available vCPU to reserve for share identifiers not present in the Queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeReservation(final java.lang.Number computeReservation) {
            this.props().computeReservation(computeReservation);
            return this;
        }

        /**
         * The name of this SchedulingPolicy.
         * <p>
         * Default: - generated by CloudFormation
         * <p>
         * @return {@code this}
         * @param schedulingPolicyName The name of this SchedulingPolicy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingPolicyName(final java.lang.String schedulingPolicyName) {
            this.props().schedulingPolicyName(schedulingPolicyName);
            return this;
        }

        /**
         * The amount of time to use to measure the usage of each job.
         * <p>
         * The usage is used to calculate a fair share percentage for each fair share identifier currently in the Queue.
         * A value of zero (0) indicates that only current usage is measured.
         * The decay is linear and gives preference to newer jobs.
         * <p>
         * The maximum supported value is 604800 seconds (1 week).
         * <p>
         * Default: - 0: only the current job usage is considered
         * <p>
         * @return {@code this}
         * @param shareDecay The amount of time to use to measure the usage of each job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shareDecay(final software.amazon.awscdk.Duration shareDecay) {
            this.props().shareDecay(shareDecay);
            return this;
        }

        /**
         * The shares that this Scheduling Policy applies to.
         * <p>
         * <em>Note</em>: It is possible to submit Jobs to the queue with Share Identifiers that
         * are not recognized by the Scheduling Policy.
         * <p>
         * Default: - no shares
         * <p>
         * @return {@code this}
         * @param shares The shares that this Scheduling Policy applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shares(final java.util.List<? extends software.amazon.awscdk.services.batch.Share> shares) {
            this.props().shares(shares);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.FairshareSchedulingPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.FairshareSchedulingPolicy build() {
            return new software.amazon.awscdk.services.batch.FairshareSchedulingPolicy(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.batch.FairshareSchedulingPolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.batch.FairshareSchedulingPolicyProps.Builder();
            }
            return this.props;
        }
    }
}
