package software.amazon.awscdk.services.bedrock;

/**
 * A Bedrock base foundation model.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.bedrock.*;
 * FoundationModel model = FoundationModel.fromFoundationModelId(this, "Model", FoundationModelIdentifier.AMAZON_TITAN_TEXT_G1_EXPRESS_V1);
 * BedrockInvokeModel task = BedrockInvokeModel.Builder.create(this, "Prompt Model")
 *         .model(model)
 *         .body(TaskInput.fromObject(Map.of(
 *                 "inputText", "Generate a list of five first names.",
 *                 "textGenerationConfig", Map.of(
 *                         "maxTokenCount", 100,
 *                         "temperature", 1))))
 *         .resultSelector(Map.of(
 *                 "names", JsonPath.stringAt("$.Body.results[0].outputText")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/models-supported.html">https://docs.aws.amazon.com/bedrock/latest/userguide/models-supported.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:11.370Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.FoundationModel")
public class FoundationModel extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.bedrock.IModel {

    protected FoundationModel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FoundationModel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Construct a Bedrock base foundation model given the model identifier.
     * <p>
     * @return A Bedrock base foundation model.
     * @see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids-arns.html">https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids-arns.html</a>
     * @param scope The parent construct. This parameter is required.
     * @param _id The name of the model construct. This parameter is required.
     * @param foundationModelId The model identifier such as 'amazon.titan-text-express-v1'. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.FoundationModel fromFoundationModelId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String _id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.FoundationModelIdentifier foundationModelId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.bedrock.FoundationModel.class, "fromFoundationModelId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModel.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(_id, "_id is required"), java.util.Objects.requireNonNull(foundationModelId, "foundationModelId is required") });
    }

    /**
     * The foundation model ARN.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getModelArn() {
        return software.amazon.jsii.Kernel.get(this, "modelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The foundation model ID.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "amazon.titan-text-express-v1";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getModelId() {
        return software.amazon.jsii.Kernel.get(this, "modelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
