package software.amazon.awscdk.services.chatbot;

/**
 * Properties for defining a <code>CfnMicrosoftTeamsChannelConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.chatbot.*;
 * CfnMicrosoftTeamsChannelConfigurationProps cfnMicrosoftTeamsChannelConfigurationProps = CfnMicrosoftTeamsChannelConfigurationProps.builder()
 *         .configurationName("configurationName")
 *         .iamRoleArn("iamRoleArn")
 *         .teamId("teamId")
 *         .teamsChannelId("teamsChannelId")
 *         .teamsTenantId("teamsTenantId")
 *         // the properties below are optional
 *         .customizationResourceArns(List.of("customizationResourceArns"))
 *         .guardrailPolicies(List.of("guardrailPolicies"))
 *         .loggingLevel("loggingLevel")
 *         .snsTopicArns(List.of("snsTopicArns"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .teamsChannelName("teamsChannelName")
 *         .userRoleRequired(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:11.484Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_chatbot.CfnMicrosoftTeamsChannelConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnMicrosoftTeamsChannelConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMicrosoftTeamsChannelConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-configurationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-configurationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConfigurationName();

    /**
     * The ARN of the IAM role that defines the permissions for  .
     * <p>
     * This is a user-defined role that  will assume. This is not the service-linked role. For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM Policies for  in chat applications</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-iamrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-iamrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIamRoleArn();

    /**
     * The ID of the Microsoft Team authorized with  .
     * <p>
     * To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the  in chat applications console. Then you can copy and paste the team ID from the console. For more details, see steps 1-3 in <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html">Tutorial: Get started with Microsoft Teams</a> in the <em>in chat applications Administrator Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-teamid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-teamid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTeamId();

    /**
     * The ID of the Microsoft Teams channel.
     * <p>
     * To get the channel ID, open Microsoft Teams, right click on the channel name in the left pane, then choose <em>Copy</em> . An example of the channel ID syntax is: <code>19%3ab6ef35dc342d56ba5654e6fc6d25a071%40thread.tacv2</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-teamschannelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-teamschannelid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTeamsChannelId();

    /**
     * The ID of the Microsoft Teams tenant.
     * <p>
     * To get the tenant ID, you must perform the initial authorization flow with Microsoft Teams in the  in chat applications console. Then you can copy and paste the tenant ID from the console. For more details, see steps 1-3 in <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html">Tutorial: Get started with Microsoft Teams</a> in the <em>in chat applications Administrator Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-teamstenantid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-teamstenantid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTeamsTenantId();

    /**
     * Links a list of resource ARNs (for example, custom action ARNs) to a Microsoft Teams channel configuration for  .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-customizationresourcearns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-customizationresourcearns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCustomizationResourceArns() {
        return null;
    }

    /**
     * The list of IAM policy ARNs that are applied as channel guardrails.
     * <p>
     * The AWS managed 'AdministratorAccess' policy is applied as a default if this is not set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-guardrailpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-guardrailpolicies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGuardrailPolicies() {
        return null;
    }

    /**
     * Specifies the logging level for this configuration. This property affects the log entries pushed to Amazon CloudWatch Logs.
     * <p>
     * Logging levels include <code>ERROR</code> , <code>INFO</code> , or <code>NONE</code> .
     * <p>
     * Default: - "NONE"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-logginglevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-logginglevel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLoggingLevel() {
        return null;
    }

    /**
     * The ARNs of the SNS topics that deliver notifications to  .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-snstopicarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-snstopicarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSnsTopicArns() {
        return null;
    }

    /**
     * The tags to add to the configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The name of the Microsoft Teams channel.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-teamschannelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-teamschannelname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTeamsChannelName() {
        return null;
    }

    /**
     * Enables use of a user role requirement in your chat configuration.
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-userrolerequired">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-microsoftteamschannelconfiguration.html#cfn-chatbot-microsoftteamschannelconfiguration-userrolerequired</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserRoleRequired() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMicrosoftTeamsChannelConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMicrosoftTeamsChannelConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMicrosoftTeamsChannelConfigurationProps> {
        java.lang.String configurationName;
        java.lang.String iamRoleArn;
        java.lang.String teamId;
        java.lang.String teamsChannelId;
        java.lang.String teamsTenantId;
        java.util.List<java.lang.String> customizationResourceArns;
        java.util.List<java.lang.String> guardrailPolicies;
        java.lang.String loggingLevel;
        java.util.List<java.lang.String> snsTopicArns;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String teamsChannelName;
        java.lang.Object userRoleRequired;

        /**
         * Sets the value of {@link CfnMicrosoftTeamsChannelConfigurationProps#getConfigurationName}
         * @param configurationName The name of the configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationName(java.lang.String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftTeamsChannelConfigurationProps#getIamRoleArn}
         * @param iamRoleArn The ARN of the IAM role that defines the permissions for  . This parameter is required.
         *                   This is a user-defined role that  will assume. This is not the service-linked role. For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM Policies for  in chat applications</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamRoleArn(java.lang.String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftTeamsChannelConfigurationProps#getTeamId}
         * @param teamId The ID of the Microsoft Team authorized with  . This parameter is required.
         *               To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the  in chat applications console. Then you can copy and paste the team ID from the console. For more details, see steps 1-3 in <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html">Tutorial: Get started with Microsoft Teams</a> in the <em>in chat applications Administrator Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder teamId(java.lang.String teamId) {
            this.teamId = teamId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftTeamsChannelConfigurationProps#getTeamsChannelId}
         * @param teamsChannelId The ID of the Microsoft Teams channel. This parameter is required.
         *                       To get the channel ID, open Microsoft Teams, right click on the channel name in the left pane, then choose <em>Copy</em> . An example of the channel ID syntax is: <code>19%3ab6ef35dc342d56ba5654e6fc6d25a071%40thread.tacv2</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder teamsChannelId(java.lang.String teamsChannelId) {
            this.teamsChannelId = teamsChannelId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftTeamsChannelConfigurationProps#getTeamsTenantId}
         * @param teamsTenantId The ID of the Microsoft Teams tenant. This parameter is required.
         *                      To get the tenant ID, you must perform the initial authorization flow with Microsoft Teams in the  in chat applications console. Then you can copy and paste the tenant ID from the console. For more details, see steps 1-3 in <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html">Tutorial: Get started with Microsoft Teams</a> in the <em>in chat applications Administrator Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder teamsTenantId(java.lang.String teamsTenantId) {
            this.teamsTenantId = teamsTenantId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftTeamsChannelConfigurationProps#getCustomizationResourceArns}
         * @param customizationResourceArns Links a list of resource ARNs (for example, custom action ARNs) to a Microsoft Teams channel configuration for  .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customizationResourceArns(java.util.List<java.lang.String> customizationResourceArns) {
            this.customizationResourceArns = customizationResourceArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftTeamsChannelConfigurationProps#getGuardrailPolicies}
         * @param guardrailPolicies The list of IAM policy ARNs that are applied as channel guardrails.
         *                          The AWS managed 'AdministratorAccess' policy is applied as a default if this is not set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder guardrailPolicies(java.util.List<java.lang.String> guardrailPolicies) {
            this.guardrailPolicies = guardrailPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftTeamsChannelConfigurationProps#getLoggingLevel}
         * @param loggingLevel Specifies the logging level for this configuration. This property affects the log entries pushed to Amazon CloudWatch Logs.
         *                     Logging levels include <code>ERROR</code> , <code>INFO</code> , or <code>NONE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingLevel(java.lang.String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftTeamsChannelConfigurationProps#getSnsTopicArns}
         * @param snsTopicArns The ARNs of the SNS topics that deliver notifications to  .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsTopicArns(java.util.List<java.lang.String> snsTopicArns) {
            this.snsTopicArns = snsTopicArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftTeamsChannelConfigurationProps#getTags}
         * @param tags The tags to add to the configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftTeamsChannelConfigurationProps#getTeamsChannelName}
         * @param teamsChannelName The name of the Microsoft Teams channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder teamsChannelName(java.lang.String teamsChannelName) {
            this.teamsChannelName = teamsChannelName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftTeamsChannelConfigurationProps#getUserRoleRequired}
         * @param userRoleRequired Enables use of a user role requirement in your chat configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userRoleRequired(java.lang.Boolean userRoleRequired) {
            this.userRoleRequired = userRoleRequired;
            return this;
        }

        /**
         * Sets the value of {@link CfnMicrosoftTeamsChannelConfigurationProps#getUserRoleRequired}
         * @param userRoleRequired Enables use of a user role requirement in your chat configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userRoleRequired(software.amazon.awscdk.IResolvable userRoleRequired) {
            this.userRoleRequired = userRoleRequired;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMicrosoftTeamsChannelConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMicrosoftTeamsChannelConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMicrosoftTeamsChannelConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMicrosoftTeamsChannelConfigurationProps {
        private final java.lang.String configurationName;
        private final java.lang.String iamRoleArn;
        private final java.lang.String teamId;
        private final java.lang.String teamsChannelId;
        private final java.lang.String teamsTenantId;
        private final java.util.List<java.lang.String> customizationResourceArns;
        private final java.util.List<java.lang.String> guardrailPolicies;
        private final java.lang.String loggingLevel;
        private final java.util.List<java.lang.String> snsTopicArns;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String teamsChannelName;
        private final java.lang.Object userRoleRequired;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configurationName = software.amazon.jsii.Kernel.get(this, "configurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iamRoleArn = software.amazon.jsii.Kernel.get(this, "iamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.teamId = software.amazon.jsii.Kernel.get(this, "teamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.teamsChannelId = software.amazon.jsii.Kernel.get(this, "teamsChannelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.teamsTenantId = software.amazon.jsii.Kernel.get(this, "teamsTenantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customizationResourceArns = software.amazon.jsii.Kernel.get(this, "customizationResourceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.guardrailPolicies = software.amazon.jsii.Kernel.get(this, "guardrailPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.loggingLevel = software.amazon.jsii.Kernel.get(this, "loggingLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snsTopicArns = software.amazon.jsii.Kernel.get(this, "snsTopicArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.teamsChannelName = software.amazon.jsii.Kernel.get(this, "teamsChannelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userRoleRequired = software.amazon.jsii.Kernel.get(this, "userRoleRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configurationName = java.util.Objects.requireNonNull(builder.configurationName, "configurationName is required");
            this.iamRoleArn = java.util.Objects.requireNonNull(builder.iamRoleArn, "iamRoleArn is required");
            this.teamId = java.util.Objects.requireNonNull(builder.teamId, "teamId is required");
            this.teamsChannelId = java.util.Objects.requireNonNull(builder.teamsChannelId, "teamsChannelId is required");
            this.teamsTenantId = java.util.Objects.requireNonNull(builder.teamsTenantId, "teamsTenantId is required");
            this.customizationResourceArns = builder.customizationResourceArns;
            this.guardrailPolicies = builder.guardrailPolicies;
            this.loggingLevel = builder.loggingLevel;
            this.snsTopicArns = builder.snsTopicArns;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.teamsChannelName = builder.teamsChannelName;
            this.userRoleRequired = builder.userRoleRequired;
        }

        @Override
        public final java.lang.String getConfigurationName() {
            return this.configurationName;
        }

        @Override
        public final java.lang.String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final java.lang.String getTeamId() {
            return this.teamId;
        }

        @Override
        public final java.lang.String getTeamsChannelId() {
            return this.teamsChannelId;
        }

        @Override
        public final java.lang.String getTeamsTenantId() {
            return this.teamsTenantId;
        }

        @Override
        public final java.util.List<java.lang.String> getCustomizationResourceArns() {
            return this.customizationResourceArns;
        }

        @Override
        public final java.util.List<java.lang.String> getGuardrailPolicies() {
            return this.guardrailPolicies;
        }

        @Override
        public final java.lang.String getLoggingLevel() {
            return this.loggingLevel;
        }

        @Override
        public final java.util.List<java.lang.String> getSnsTopicArns() {
            return this.snsTopicArns;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTeamsChannelName() {
            return this.teamsChannelName;
        }

        @Override
        public final java.lang.Object getUserRoleRequired() {
            return this.userRoleRequired;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configurationName", om.valueToTree(this.getConfigurationName()));
            data.set("iamRoleArn", om.valueToTree(this.getIamRoleArn()));
            data.set("teamId", om.valueToTree(this.getTeamId()));
            data.set("teamsChannelId", om.valueToTree(this.getTeamsChannelId()));
            data.set("teamsTenantId", om.valueToTree(this.getTeamsTenantId()));
            if (this.getCustomizationResourceArns() != null) {
                data.set("customizationResourceArns", om.valueToTree(this.getCustomizationResourceArns()));
            }
            if (this.getGuardrailPolicies() != null) {
                data.set("guardrailPolicies", om.valueToTree(this.getGuardrailPolicies()));
            }
            if (this.getLoggingLevel() != null) {
                data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
            }
            if (this.getSnsTopicArns() != null) {
                data.set("snsTopicArns", om.valueToTree(this.getSnsTopicArns()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTeamsChannelName() != null) {
                data.set("teamsChannelName", om.valueToTree(this.getTeamsChannelName()));
            }
            if (this.getUserRoleRequired() != null) {
                data.set("userRoleRequired", om.valueToTree(this.getUserRoleRequired()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_chatbot.CfnMicrosoftTeamsChannelConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMicrosoftTeamsChannelConfigurationProps.Jsii$Proxy that = (CfnMicrosoftTeamsChannelConfigurationProps.Jsii$Proxy) o;

            if (!configurationName.equals(that.configurationName)) return false;
            if (!iamRoleArn.equals(that.iamRoleArn)) return false;
            if (!teamId.equals(that.teamId)) return false;
            if (!teamsChannelId.equals(that.teamsChannelId)) return false;
            if (!teamsTenantId.equals(that.teamsTenantId)) return false;
            if (this.customizationResourceArns != null ? !this.customizationResourceArns.equals(that.customizationResourceArns) : that.customizationResourceArns != null) return false;
            if (this.guardrailPolicies != null ? !this.guardrailPolicies.equals(that.guardrailPolicies) : that.guardrailPolicies != null) return false;
            if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
            if (this.snsTopicArns != null ? !this.snsTopicArns.equals(that.snsTopicArns) : that.snsTopicArns != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.teamsChannelName != null ? !this.teamsChannelName.equals(that.teamsChannelName) : that.teamsChannelName != null) return false;
            return this.userRoleRequired != null ? this.userRoleRequired.equals(that.userRoleRequired) : that.userRoleRequired == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configurationName.hashCode();
            result = 31 * result + (this.iamRoleArn.hashCode());
            result = 31 * result + (this.teamId.hashCode());
            result = 31 * result + (this.teamsChannelId.hashCode());
            result = 31 * result + (this.teamsTenantId.hashCode());
            result = 31 * result + (this.customizationResourceArns != null ? this.customizationResourceArns.hashCode() : 0);
            result = 31 * result + (this.guardrailPolicies != null ? this.guardrailPolicies.hashCode() : 0);
            result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
            result = 31 * result + (this.snsTopicArns != null ? this.snsTopicArns.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.teamsChannelName != null ? this.teamsChannelName.hashCode() : 0);
            result = 31 * result + (this.userRoleRequired != null ? this.userRoleRequired.hashCode() : 0);
            return result;
        }
    }
}
