package software.amazon.awscdk.services.cloudfront;

/**
 * The HTTP methods that the Behavior will accept requests on.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a Distribution with configured HTTP methods and viewer protocol policy of the cache.
 * Bucket myBucket;
 * Distribution myWebDistribution = Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new S3Origin(myBucket))
 *                 .allowedMethods(AllowedMethods.ALLOW_ALL)
 *                 .viewerProtocolPolicy(ViewerProtocolPolicy.REDIRECT_TO_HTTPS)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:11.656Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.AllowedMethods")
public class AllowedMethods extends software.amazon.jsii.JsiiObject {

    protected AllowedMethods(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AllowedMethods(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ALLOW_ALL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.AllowedMethods.class, "ALLOW_ALL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.AllowedMethods.class));
        ALLOW_GET_HEAD = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.AllowedMethods.class, "ALLOW_GET_HEAD", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.AllowedMethods.class));
        ALLOW_GET_HEAD_OPTIONS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.AllowedMethods.class, "ALLOW_GET_HEAD_OPTIONS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.AllowedMethods.class));
    }

    /**
     * All supported HTTP methods.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.AllowedMethods ALLOW_ALL;

    /**
     * HEAD and GET.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.AllowedMethods ALLOW_GET_HEAD;

    /**
     * HEAD, GET, and OPTIONS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.AllowedMethods ALLOW_GET_HEAD_OPTIONS;

    /**
     * HTTP methods supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getMethods() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "methods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }
}
