package software.amazon.awscdk.services.cloudfront;

/**
 * Represents the VPC origin endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * ApplicationLoadBalancer applicationLoadBalancer;
 * VpcOriginEndpoint vpcOriginEndpoint = VpcOriginEndpoint.applicationLoadBalancer(applicationLoadBalancer);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:11.869Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.VpcOriginEndpoint")
public abstract class VpcOriginEndpoint extends software.amazon.jsii.JsiiObject {

    protected VpcOriginEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VpcOriginEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected VpcOriginEndpoint() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * A VPC origin endpoint from an Application Load Balancer.
     * <p>
     * @param alb This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.VpcOriginEndpoint applicationLoadBalancer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer alb) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.VpcOriginEndpoint.class, "applicationLoadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.VpcOriginEndpoint.class), new Object[] { java.util.Objects.requireNonNull(alb, "alb is required") });
    }

    /**
     * A VPC origin endpoint from an EC2 instance.
     * <p>
     * @param instance This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.VpcOriginEndpoint ec2Instance(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IInstance instance) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.VpcOriginEndpoint.class, "ec2Instance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.VpcOriginEndpoint.class), new Object[] { java.util.Objects.requireNonNull(instance, "instance is required") });
    }

    /**
     * A VPC origin endpoint from an Network Load Balancer.
     * <p>
     * @param nlb This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.VpcOriginEndpoint networkLoadBalancer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer nlb) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.VpcOriginEndpoint.class, "networkLoadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.VpcOriginEndpoint.class), new Object[] { java.util.Objects.requireNonNull(nlb, "nlb is required") });
    }

    /**
     * The ARN of the CloudFront VPC origin endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getEndpointArn();

    /**
     * The domain name of the CloudFront VPC origin endpoint configuration.
     * <p>
     * Default: - No domain name configured
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.lang.String getDomainName();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.cloudfront.VpcOriginEndpoint {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The ARN of the CloudFront VPC origin endpoint configuration.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getEndpointArn() {
            return software.amazon.jsii.Kernel.get(this, "endpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The domain name of the CloudFront VPC origin endpoint configuration.
         * <p>
         * Default: - No domain name configured
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
            return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
