package software.amazon.awscdk.services.cloudwatch;

/**
 * Dashboard Variable.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Dashboard dashboard = Dashboard.Builder.create(this, "Dash")
 *         .defaultInterval(Duration.days(7))
 *         .variables(List.of(DashboardVariable.Builder.create()
 *                 .id("functionName")
 *                 .type(VariableType.PATTERN)
 *                 .label("Function")
 *                 .inputType(VariableInputType.RADIO)
 *                 .value("originalFuncNameInDashboard")
 *                 // equivalent to cw.Values.fromSearch('{AWS/Lambda,FunctionName} MetricName=\"Duration\"', 'FunctionName')
 *                 .values(Values.fromSearchComponents(SearchComponents.builder()
 *                         .namespace("AWS/Lambda")
 *                         .dimensions(List.of("FunctionName"))
 *                         .metricName("Duration")
 *                         .populateFrom("FunctionName")
 *                         .build()))
 *                 .defaultValue(DefaultValue.FIRST)
 *                 .visible(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:12.048Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.DashboardVariable")
public class DashboardVariable extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.IVariable {

    protected DashboardVariable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DashboardVariable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DashboardVariable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.DashboardVariableOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Return the variable JSON for use in the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object toJson() {
        return software.amazon.jsii.Kernel.call(this, "toJson", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.DashboardVariable}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.DashboardVariable> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.cloudwatch.DashboardVariableOptions.Builder options;

        private Builder() {
            this.options = new software.amazon.awscdk.services.cloudwatch.DashboardVariableOptions.Builder();
        }

        /**
         * Unique id.
         * <p>
         * @return {@code this}
         * @param id Unique id. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(final java.lang.String id) {
            this.options.id(id);
            return this;
        }

        /**
         * The way the variable value is selected.
         * <p>
         * @return {@code this}
         * @param inputType The way the variable value is selected. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputType(final software.amazon.awscdk.services.cloudwatch.VariableInputType inputType) {
            this.options.inputType(inputType);
            return this;
        }

        /**
         * Type of the variable.
         * <p>
         * @return {@code this}
         * @param type Type of the variable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final software.amazon.awscdk.services.cloudwatch.VariableType type) {
            this.options.type(type);
            return this;
        }

        /**
         * Pattern or property value to replace.
         * <p>
         * @return {@code this}
         * @param value Pattern or property value to replace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(final java.lang.String value) {
            this.options.value(value);
            return this;
        }

        /**
         * Optional default value.
         * <p>
         * Default: - no default value is set
         * <p>
         * @return {@code this}
         * @param defaultValue Optional default value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultValue(final software.amazon.awscdk.services.cloudwatch.DefaultValue defaultValue) {
            this.options.defaultValue(defaultValue);
            return this;
        }

        /**
         * Optional label in the toolbar.
         * <p>
         * Default: - the variable's value
         * <p>
         * @return {@code this}
         * @param label Optional label in the toolbar. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder label(final java.lang.String label) {
            this.options.label(label);
            return this;
        }

        /**
         * Optional values (required for {@link VariableInputType.RADIO} and {@link VariableInputType.SELECT} dashboard variables).
         * <p>
         * Default: - no values
         * <p>
         * @return {@code this}
         * @param values Optional values (required for {@link VariableInputType.RADIO} and {@link VariableInputType.SELECT} dashboard variables). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder values(final software.amazon.awscdk.services.cloudwatch.Values values) {
            this.options.values(values);
            return this;
        }

        /**
         * Whether the variable is visible.
         * <p>
         * Default: - true
         * <p>
         * @return {@code this}
         * @param visible Whether the variable is visible. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visible(final java.lang.Boolean visible) {
            this.options.visible(visible);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.DashboardVariable}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.DashboardVariable build() {
            return new software.amazon.awscdk.services.cloudwatch.DashboardVariable(
                this.options.build()
            );
        }
    }
}
