package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for a SearchExpression.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SearchExpression cpuUtilization = SearchExpression.Builder.create()
 *         .expression("SEARCH('{AWS/EC2,InstanceId} MetricName=\"CPUUtilization\"', 'Average', 900)")
 *         .label("EC2 CPU Utilization")
 *         .color("#ff7f0e")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:12.083Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.SearchExpressionProps")
@software.amazon.jsii.Jsii.Proxy(SearchExpressionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SearchExpressionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudwatch.SearchExpressionOptions {

    /**
     * The search expression defining the metrics to be retrieved.
     * <p>
     * A search expression cannot be used within an Alarm.
     * <p>
     * A search expression allows you to retrieve and graph multiple related metrics in a single statement.
     * It can return up to 500 time series.
     * <p>
     * Examples:
     * <p>
     * <ul>
     * <li><code>SEARCH('{AWS/EC2,InstanceId} CPUUtilization', 'Average', 300)</code></li>
     * <li><code>SEARCH('{AWS/ApplicationELB,LoadBalancer} RequestCount', 'Sum', 60)</code></li>
     * <li><code>SEARCH('{MyNamespace,ServiceName} Errors', 'Sum')</code></li>
     * </ul>
     * <p>
     * For more information about search expression syntax, see:
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/search-expression-syntax.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExpression();

    /**
     * @return a {@link Builder} of {@link SearchExpressionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SearchExpressionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SearchExpressionProps> {
        java.lang.String expression;
        java.lang.String color;
        java.lang.String label;
        software.amazon.awscdk.Duration period;
        java.lang.String searchAccount;
        java.lang.String searchRegion;

        /**
         * Sets the value of {@link SearchExpressionProps#getExpression}
         * @param expression The search expression defining the metrics to be retrieved. This parameter is required.
         *                   A search expression cannot be used within an Alarm.
         *                   <p>
         *                   A search expression allows you to retrieve and graph multiple related metrics in a single statement.
         *                   It can return up to 500 time series.
         *                   <p>
         *                   Examples:
         *                   <p>
         *                   <ul>
         *                   <li><code>SEARCH('{AWS/EC2,InstanceId} CPUUtilization', 'Average', 300)</code></li>
         *                   <li><code>SEARCH('{AWS/ApplicationELB,LoadBalancer} RequestCount', 'Sum', 60)</code></li>
         *                   <li><code>SEARCH('{MyNamespace,ServiceName} Errors', 'Sum')</code></li>
         *                   </ul>
         *                   <p>
         *                   For more information about search expression syntax, see:
         *                   https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/search-expression-syntax.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expression(java.lang.String expression) {
            this.expression = expression;
            return this;
        }

        /**
         * Sets the value of {@link SearchExpressionProps#getColor}
         * @param color Color for the metric produced by the search expression.
         *              If the search expression produces more than one time series, the color is assigned to the first one.
         *              Other metrics are assigned colors automatically.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder color(java.lang.String color) {
            this.color = color;
            return this;
        }

        /**
         * Sets the value of {@link SearchExpressionProps#getLabel}
         * @param label Label for this search expression when added to a Graph in a Dashboard.
         *              If this expression evaluates to more than one time series,
         *              each time series will appear in the graph using a combination of the
         *              expression label and the individual metric label. Specify the empty
         *              string (<code>''</code>) to suppress the expression label and only keep the
         *              metric label.
         *              <p>
         *              You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">dynamic labels</a>
         *              to show summary information about the displayed time series
         *              in the legend. For example, if you use:
         *              <p>
         *              <blockquote><pre>
         *              [max: ${MAX}] MyMetric
         *              </pre></blockquote>
         *              <p>
         *              As the metric label, the maximum value in the visible range will
         *              be shown next to the time series name in the graph's legend. If the
         *              search expression produces more than one time series, the maximum
         *              will be shown for each individual time series produce by this
         *              search expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder label(java.lang.String label) {
            this.label = label;
            return this;
        }

        /**
         * Sets the value of {@link SearchExpressionProps#getPeriod}
         * @param period The period over which the search expression's statistics are applied.
         *               This period overrides the period defined within the search expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(software.amazon.awscdk.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link SearchExpressionProps#getSearchAccount}
         * @param searchAccount Account to evaluate search expressions within.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder searchAccount(java.lang.String searchAccount) {
            this.searchAccount = searchAccount;
            return this;
        }

        /**
         * Sets the value of {@link SearchExpressionProps#getSearchRegion}
         * @param searchRegion Region to evaluate search expressions within.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder searchRegion(java.lang.String searchRegion) {
            this.searchRegion = searchRegion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SearchExpressionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SearchExpressionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SearchExpressionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SearchExpressionProps {
        private final java.lang.String expression;
        private final java.lang.String color;
        private final java.lang.String label;
        private final software.amazon.awscdk.Duration period;
        private final java.lang.String searchAccount;
        private final java.lang.String searchRegion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.color = software.amazon.jsii.Kernel.get(this, "color", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.searchAccount = software.amazon.jsii.Kernel.get(this, "searchAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.searchRegion = software.amazon.jsii.Kernel.get(this, "searchRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
            this.color = builder.color;
            this.label = builder.label;
            this.period = builder.period;
            this.searchAccount = builder.searchAccount;
            this.searchRegion = builder.searchRegion;
        }

        @Override
        public final java.lang.String getExpression() {
            return this.expression;
        }

        @Override
        public final java.lang.String getColor() {
            return this.color;
        }

        @Override
        public final java.lang.String getLabel() {
            return this.label;
        }

        @Override
        public final software.amazon.awscdk.Duration getPeriod() {
            return this.period;
        }

        @Override
        public final java.lang.String getSearchAccount() {
            return this.searchAccount;
        }

        @Override
        public final java.lang.String getSearchRegion() {
            return this.searchRegion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("expression", om.valueToTree(this.getExpression()));
            if (this.getColor() != null) {
                data.set("color", om.valueToTree(this.getColor()));
            }
            if (this.getLabel() != null) {
                data.set("label", om.valueToTree(this.getLabel()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }
            if (this.getSearchAccount() != null) {
                data.set("searchAccount", om.valueToTree(this.getSearchAccount()));
            }
            if (this.getSearchRegion() != null) {
                data.set("searchRegion", om.valueToTree(this.getSearchRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.SearchExpressionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SearchExpressionProps.Jsii$Proxy that = (SearchExpressionProps.Jsii$Proxy) o;

            if (!expression.equals(that.expression)) return false;
            if (this.color != null ? !this.color.equals(that.color) : that.color != null) return false;
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
            if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
            if (this.searchAccount != null ? !this.searchAccount.equals(that.searchAccount) : that.searchAccount != null) return false;
            return this.searchRegion != null ? this.searchRegion.equals(that.searchRegion) : that.searchRegion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.expression.hashCode();
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            result = 31 * result + (this.searchAccount != null ? this.searchAccount.hashCode() : 0);
            result = 31 * result + (this.searchRegion != null ? this.searchRegion.hashCode() : 0);
            return result;
        }
    }
}
