package software.amazon.awscdk.services.cloudwatch;

/**
 * Standard table summary columns.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * dashboard.addWidgets(TableWidget.Builder.create()
 *         // ...
 *         .summary(TableSummaryProps.builder()
 *                 .columns(List.of(TableSummaryColumn.AVERAGE))
 *                 .hideNonSummaryColumns(true)
 *                 .sticky(true)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:12.088Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.TableSummaryColumn")
public enum TableSummaryColumn {
    /**
     * Minimum of all data points.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MINIMUM,
    /**
     * Maximum of all data points.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MAXIMUM,
    /**
     * Sum of all data points.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SUM,
    /**
     * Average of all data points.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AVERAGE,
}
