package software.amazon.awscdk.services.cloudwatch;

/**
 * Thresholds for highlighting cells in TableWidget.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * dashboard.addWidgets(TableWidget.Builder.create()
 *         // ...
 *         .thresholds(List.of(TableThreshold.above(1000, Color.RED), TableThreshold.between(500, 1000, Color.ORANGE), TableThreshold.below(500, Color.GREEN)))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:12.088Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.TableThreshold")
public class TableThreshold extends software.amazon.jsii.JsiiObject {

    protected TableThreshold(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TableThreshold(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * A threshold for highlighting and coloring cells above the specified value.
     * <p>
     * @param value lower bound of threshold range. This parameter is required.
     * @param color cell color for values within threshold range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.TableThreshold above(final @org.jetbrains.annotations.NotNull java.lang.Number value, final @org.jetbrains.annotations.Nullable java.lang.String color) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.TableThreshold.class, "above", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.TableThreshold.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required"), color });
    }

    /**
     * A threshold for highlighting and coloring cells above the specified value.
     * <p>
     * @param value lower bound of threshold range. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.TableThreshold above(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.TableThreshold.class, "above", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.TableThreshold.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * A threshold for highlighting and coloring cells below the specified value.
     * <p>
     * @param value upper bound of threshold range. This parameter is required.
     * @param color cell color for values within threshold range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.TableThreshold below(final @org.jetbrains.annotations.NotNull java.lang.Number value, final @org.jetbrains.annotations.Nullable java.lang.String color) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.TableThreshold.class, "below", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.TableThreshold.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required"), color });
    }

    /**
     * A threshold for highlighting and coloring cells below the specified value.
     * <p>
     * @param value upper bound of threshold range. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.TableThreshold below(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.TableThreshold.class, "below", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.TableThreshold.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * A threshold for highlighting and coloring cells within the specified values.
     * <p>
     * @param lowerBound lower bound of threshold range. This parameter is required.
     * @param upperBound upper bound of threshold range. This parameter is required.
     * @param color cell color for values within threshold range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.TableThreshold between(final @org.jetbrains.annotations.NotNull java.lang.Number lowerBound, final @org.jetbrains.annotations.NotNull java.lang.Number upperBound, final @org.jetbrains.annotations.Nullable java.lang.String color) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.TableThreshold.class, "between", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.TableThreshold.class), new Object[] { java.util.Objects.requireNonNull(lowerBound, "lowerBound is required"), java.util.Objects.requireNonNull(upperBound, "upperBound is required"), color });
    }

    /**
     * A threshold for highlighting and coloring cells within the specified values.
     * <p>
     * @param lowerBound lower bound of threshold range. This parameter is required.
     * @param upperBound upper bound of threshold range. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.TableThreshold between(final @org.jetbrains.annotations.NotNull java.lang.Number lowerBound, final @org.jetbrains.annotations.NotNull java.lang.Number upperBound) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.TableThreshold.class, "between", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.TableThreshold.class), new Object[] { java.util.Objects.requireNonNull(lowerBound, "lowerBound is required"), java.util.Objects.requireNonNull(upperBound, "upperBound is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object toJson() {
        return software.amazon.jsii.Kernel.call(this, "toJson", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }
}
