package software.amazon.awscdk.services.codeguruprofiler;

/**
 * Properties for defining a <code>CfnProfilingGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codeguruprofiler.*;
 * Object agentPermissions;
 * CfnProfilingGroupProps cfnProfilingGroupProps = CfnProfilingGroupProps.builder()
 *         .profilingGroupName("profilingGroupName")
 *         // the properties below are optional
 *         .agentPermissions(agentPermissions)
 *         .anomalyDetectionNotificationConfiguration(List.of(ChannelProperty.builder()
 *                 .channelUri("channelUri")
 *                 // the properties below are optional
 *                 .channelId("channelId")
 *                 .build()))
 *         .computePlatform("computePlatform")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:12.366Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codeguruprofiler.CfnProfilingGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnProfilingGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnProfilingGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the profiling group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-profilinggroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-profilinggroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProfilingGroupName();

    /**
     * The agent permissions attached to this profiling group.
     * <p>
     * This action group grants <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions to perform actions required by the profiling agent. The Json consists of key <code>Principals</code> .
     * <p>
     * <em>Principals</em> : A list of string ARNs for the roles and users you want to grant access to the profiling group. Wildcards are not supported in the ARNs. You are allowed to provide up to 50 ARNs. An empty list is not permitted. This is a required key.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html">Resource-based policies in CodeGuru Profiler</a> in the <em>Amazon CodeGuru Profiler user guide</em> , <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">ConfigureAgent</a> , and <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html">PostAgentProfile</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-agentpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-agentpermissions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAgentPermissions() {
        return null;
    }

    /**
     * Adds anomaly notifications for a profiling group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-anomalydetectionnotificationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-anomalydetectionnotificationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAnomalyDetectionNotificationConfiguration() {
        return null;
    }

    /**
     * The compute platform of the profiling group.
     * <p>
     * Use <code>AWSLambda</code> if your application runs on AWS Lambda. Use <code>Default</code> if your application runs on a compute platform that is not AWS Lambda , such an Amazon EC2 instance, an on-premises server, or a different platform. If not specified, <code>Default</code> is used. This property is immutable.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-computeplatform">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-computeplatform</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComputePlatform() {
        return null;
    }

    /**
     * A list of tags to add to the created profiling group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnProfilingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnProfilingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnProfilingGroupProps> {
        java.lang.String profilingGroupName;
        java.lang.Object agentPermissions;
        java.lang.Object anomalyDetectionNotificationConfiguration;
        java.lang.String computePlatform;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnProfilingGroupProps#getProfilingGroupName}
         * @param profilingGroupName The name of the profiling group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profilingGroupName(java.lang.String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfilingGroupProps#getAgentPermissions}
         * @param agentPermissions The agent permissions attached to this profiling group.
         *                         This action group grants <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions to perform actions required by the profiling agent. The Json consists of key <code>Principals</code> .
         *                         <p>
         *                         <em>Principals</em> : A list of string ARNs for the roles and users you want to grant access to the profiling group. Wildcards are not supported in the ARNs. You are allowed to provide up to 50 ARNs. An empty list is not permitted. This is a required key.
         *                         <p>
         *                         For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html">Resource-based policies in CodeGuru Profiler</a> in the <em>Amazon CodeGuru Profiler user guide</em> , <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">ConfigureAgent</a> , and <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html">PostAgentProfile</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentPermissions(java.lang.Object agentPermissions) {
            this.agentPermissions = agentPermissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfilingGroupProps#getAnomalyDetectionNotificationConfiguration}
         * @param anomalyDetectionNotificationConfiguration Adds anomaly notifications for a profiling group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder anomalyDetectionNotificationConfiguration(software.amazon.awscdk.IResolvable anomalyDetectionNotificationConfiguration) {
            this.anomalyDetectionNotificationConfiguration = anomalyDetectionNotificationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfilingGroupProps#getAnomalyDetectionNotificationConfiguration}
         * @param anomalyDetectionNotificationConfiguration Adds anomaly notifications for a profiling group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder anomalyDetectionNotificationConfiguration(java.util.List<? extends java.lang.Object> anomalyDetectionNotificationConfiguration) {
            this.anomalyDetectionNotificationConfiguration = anomalyDetectionNotificationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfilingGroupProps#getComputePlatform}
         * @param computePlatform The compute platform of the profiling group.
         *                        Use <code>AWSLambda</code> if your application runs on AWS Lambda. Use <code>Default</code> if your application runs on a compute platform that is not AWS Lambda , such an Amazon EC2 instance, an on-premises server, or a different platform. If not specified, <code>Default</code> is used. This property is immutable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computePlatform(java.lang.String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfilingGroupProps#getTags}
         * @param tags A list of tags to add to the created profiling group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnProfilingGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnProfilingGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnProfilingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnProfilingGroupProps {
        private final java.lang.String profilingGroupName;
        private final java.lang.Object agentPermissions;
        private final java.lang.Object anomalyDetectionNotificationConfiguration;
        private final java.lang.String computePlatform;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.profilingGroupName = software.amazon.jsii.Kernel.get(this, "profilingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.agentPermissions = software.amazon.jsii.Kernel.get(this, "agentPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.anomalyDetectionNotificationConfiguration = software.amazon.jsii.Kernel.get(this, "anomalyDetectionNotificationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.computePlatform = software.amazon.jsii.Kernel.get(this, "computePlatform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.profilingGroupName = java.util.Objects.requireNonNull(builder.profilingGroupName, "profilingGroupName is required");
            this.agentPermissions = builder.agentPermissions;
            this.anomalyDetectionNotificationConfiguration = builder.anomalyDetectionNotificationConfiguration;
            this.computePlatform = builder.computePlatform;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getProfilingGroupName() {
            return this.profilingGroupName;
        }

        @Override
        public final java.lang.Object getAgentPermissions() {
            return this.agentPermissions;
        }

        @Override
        public final java.lang.Object getAnomalyDetectionNotificationConfiguration() {
            return this.anomalyDetectionNotificationConfiguration;
        }

        @Override
        public final java.lang.String getComputePlatform() {
            return this.computePlatform;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("profilingGroupName", om.valueToTree(this.getProfilingGroupName()));
            if (this.getAgentPermissions() != null) {
                data.set("agentPermissions", om.valueToTree(this.getAgentPermissions()));
            }
            if (this.getAnomalyDetectionNotificationConfiguration() != null) {
                data.set("anomalyDetectionNotificationConfiguration", om.valueToTree(this.getAnomalyDetectionNotificationConfiguration()));
            }
            if (this.getComputePlatform() != null) {
                data.set("computePlatform", om.valueToTree(this.getComputePlatform()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codeguruprofiler.CfnProfilingGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnProfilingGroupProps.Jsii$Proxy that = (CfnProfilingGroupProps.Jsii$Proxy) o;

            if (!profilingGroupName.equals(that.profilingGroupName)) return false;
            if (this.agentPermissions != null ? !this.agentPermissions.equals(that.agentPermissions) : that.agentPermissions != null) return false;
            if (this.anomalyDetectionNotificationConfiguration != null ? !this.anomalyDetectionNotificationConfiguration.equals(that.anomalyDetectionNotificationConfiguration) : that.anomalyDetectionNotificationConfiguration != null) return false;
            if (this.computePlatform != null ? !this.computePlatform.equals(that.computePlatform) : that.computePlatform != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.profilingGroupName.hashCode();
            result = 31 * result + (this.agentPermissions != null ? this.agentPermissions.hashCode() : 0);
            result = 31 * result + (this.anomalyDetectionNotificationConfiguration != null ? this.anomalyDetectionNotificationConfiguration.hashCode() : 0);
            result = 31 * result + (this.computePlatform != null ? this.computePlatform.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
