package software.amazon.awscdk.services.codepipeline;

/**
 * Execution mode.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Pipeline.Builder.create(this, "Pipeline")
 *         .pipelineType(PipelineType.V2)
 *         .executionMode(ExecutionMode.PARALLEL)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:12.440Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.ExecutionMode")
public enum ExecutionMode {
    /**
     * QUEUED mode.
     * <p>
     * Executions are processed one by one in the order that they are queued.
     * <p>
     * This requires pipeline type V2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    QUEUED,
    /**
     * SUPERSEDED mode.
     * <p>
     * A more recent execution can overtake an older one.
     * <p>
     * This is the default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SUPERSEDED,
    /**
     * PARALLEL mode.
     * <p>
     * In PARALLEL mode, executions run simultaneously and independently of one
     * another. Executions don't wait for other runs to complete before starting
     * or finishing.
     * <p>
     * This requires pipeline type V2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL,
}
