package software.amazon.awscdk.services.codepipeline;

/**
 * Event for trigger with pull request filter.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodeStarConnectionsSourceAction sourceAction;
 * CodeBuildAction buildAction;
 * Pipeline.Builder.create(this, "Pipeline")
 *         .pipelineType(PipelineType.V2)
 *         .stages(List.of(StageProps.builder()
 *                 .stageName("Source")
 *                 .actions(List.of(sourceAction))
 *                 .build(), StageProps.builder()
 *                 .stageName("Build")
 *                 .actions(List.of(buildAction))
 *                 .build()))
 *         .triggers(List.of(TriggerProps.builder()
 *                 .providerType(ProviderType.CODE_STAR_SOURCE_CONNECTION)
 *                 .gitConfiguration(GitConfiguration.builder()
 *                         .sourceAction(sourceAction)
 *                         .pullRequestFilter(List.of(GitPullRequestFilter.builder()
 *                                 .branchesExcludes(List.of("exclude1", "exclude2"))
 *                                 .branchesIncludes(List.of("include1", "include2"))
 *                                 .events(List.of(GitPullRequestEvent.OPEN, GitPullRequestEvent.CLOSED))
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:12.442Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.GitPullRequestEvent")
public enum GitPullRequestEvent {
    /**
     * OPEN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPEN,
    /**
     * UPDATED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    UPDATED,
    /**
     * CLOSED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CLOSED,
}
