package software.amazon.awscdk.services.cognito;

/**
 * The <code>AWS::Cognito::IdentityPool</code> resource creates an Amazon Cognito identity pool.
 * <p>
 * To avoid deleting the resource accidentally from AWS CloudFormation , use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html">DeletionPolicy Attribute</a> and the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html">UpdateReplacePolicy Attribute</a> to retain the resource on deletion or replacement.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cognito.*;
 * OpenIdConnectProvider myProvider;
 * CfnIdentityPool.Builder.create(this, "IdentityPool")
 *         .openIdConnectProviderArns(List.of(myProvider.getOpenIdConnectProviderArn()))
 *         // And the other properties for your identity pool
 *         .allowUnauthenticatedIdentities(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:12.650Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnIdentityPool")
public class CfnIdentityPool extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnIdentityPool(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIdentityPool(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.CfnIdentityPool.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIdentityPool(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.CfnIdentityPoolProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Amazon Cognito identity pool, returned as a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Specifies whether the identity pool supports unauthenticated logins.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAllowUnauthenticatedIdentities() {
        return software.amazon.jsii.Kernel.get(this, "allowUnauthenticatedIdentities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the identity pool supports unauthenticated logins.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowUnauthenticatedIdentities(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "allowUnauthenticatedIdentities", java.util.Objects.requireNonNull(value, "allowUnauthenticatedIdentities is required"));
    }

    /**
     * Specifies whether the identity pool supports unauthenticated logins.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowUnauthenticatedIdentities(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "allowUnauthenticatedIdentities", java.util.Objects.requireNonNull(value, "allowUnauthenticatedIdentities is required"));
    }

    /**
     * Enables the Basic (Classic) authentication flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAllowClassicFlow() {
        return software.amazon.jsii.Kernel.get(this, "allowClassicFlow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables the Basic (Classic) authentication flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowClassicFlow(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "allowClassicFlow", value);
    }

    /**
     * Enables the Basic (Classic) authentication flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowClassicFlow(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "allowClassicFlow", value);
    }

    /**
     * The events to configure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCognitoEvents() {
        return software.amazon.jsii.Kernel.get(this, "cognitoEvents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The events to configure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoEvents(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "cognitoEvents", value);
    }

    /**
     * The Amazon Cognito user pools and their client IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCognitoIdentityProviders() {
        return software.amazon.jsii.Kernel.get(this, "cognitoIdentityProviders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon Cognito user pools and their client IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoIdentityProviders(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cognitoIdentityProviders", value);
    }

    /**
     * The Amazon Cognito user pools and their client IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoIdentityProviders(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cognito.CfnIdentityPool.CognitoIdentityProviderProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cognito.CfnIdentityPool.CognitoIdentityProviderProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "cognitoIdentityProviders", value);
    }

    /**
     * Configuration options for configuring Amazon Cognito streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCognitoStreams() {
        return software.amazon.jsii.Kernel.get(this, "cognitoStreams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration options for configuring Amazon Cognito streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoStreams(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cognitoStreams", value);
    }

    /**
     * Configuration options for configuring Amazon Cognito streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoStreams(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnIdentityPool.CognitoStreamsProperty value) {
        software.amazon.jsii.Kernel.set(this, "cognitoStreams", value);
    }

    /**
     * The "domain" Amazon Cognito uses when referencing your users.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeveloperProviderName() {
        return software.amazon.jsii.Kernel.get(this, "developerProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The "domain" Amazon Cognito uses when referencing your users.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeveloperProviderName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "developerProviderName", value);
    }

    /**
     * The name of your Amazon Cognito identity pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIdentityPoolName() {
        return software.amazon.jsii.Kernel.get(this, "identityPoolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of your Amazon Cognito identity pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityPoolName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "identityPoolName", value);
    }

    /**
     * Tags to assign to the identity pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getIdentityPoolTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "identityPoolTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Tags to assign to the identity pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityPoolTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "identityPoolTags", value);
    }

    /**
     * The Amazon Resource Names (ARNs) of the OpenID connect providers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOpenIdConnectProviderArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "openIdConnectProviderArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The Amazon Resource Names (ARNs) of the OpenID connect providers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenIdConnectProviderArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "openIdConnectProviderArns", value);
    }

    /**
     * The configuration options to be applied to the identity pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPushSync() {
        return software.amazon.jsii.Kernel.get(this, "pushSync", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration options to be applied to the identity pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPushSync(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "pushSync", value);
    }

    /**
     * The configuration options to be applied to the identity pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPushSync(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnIdentityPool.PushSyncProperty value) {
        software.amazon.jsii.Kernel.set(this, "pushSync", value);
    }

    /**
     * The Amazon Resource Names (ARNs) of the Security Assertion Markup Language (SAML) providers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSamlProviderArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "samlProviderArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The Amazon Resource Names (ARNs) of the Security Assertion Markup Language (SAML) providers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSamlProviderArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "samlProviderArns", value);
    }

    /**
     * Key-value pairs that map provider names to provider app IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSupportedLoginProviders() {
        return software.amazon.jsii.Kernel.get(this, "supportedLoginProviders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Key-value pairs that map provider names to provider app IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSupportedLoginProviders(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "supportedLoginProviders", value);
    }
    /**
     * <code>CognitoIdentityProvider</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html">AWS::Cognito::IdentityPool</a> resource that represents an Amazon Cognito user pool and its client ID.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * CognitoIdentityProviderProperty cognitoIdentityProviderProperty = CognitoIdentityProviderProperty.builder()
     *         .clientId("clientId")
     *         .providerName("providerName")
     *         // the properties below are optional
     *         .serverSideTokenCheck(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnIdentityPool.CognitoIdentityProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoIdentityProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoIdentityProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The client ID for the Amazon Cognito user pool.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html#cfn-cognito-identitypool-cognitoidentityprovider-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html#cfn-cognito-identitypool-cognitoidentityprovider-clientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientId();

        /**
         * The provider name for an Amazon Cognito user pool.
         * <p>
         * For example: <code>cognito-idp.us-east-2.amazonaws.com/us-east-2_123456789</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html#cfn-cognito-identitypool-cognitoidentityprovider-providername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html#cfn-cognito-identitypool-cognitoidentityprovider-providername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProviderName();

        /**
         * TRUE if server-side token validation is enabled for the identity provider’s token.
         * <p>
         * After you set the <code>ServerSideTokenCheck</code> to TRUE for an identity pool, that identity pool checks with the integrated user pools to make sure the user has not been globally signed out or deleted before the identity pool provides an OIDC token or AWS credentials for the user.
         * <p>
         * If the user is signed out or deleted, the identity pool returns a 400 Not Authorized error.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html#cfn-cognito-identitypool-cognitoidentityprovider-serversidetokencheck">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html#cfn-cognito-identitypool-cognitoidentityprovider-serversidetokencheck</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServerSideTokenCheck() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CognitoIdentityProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoIdentityProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoIdentityProviderProperty> {
            java.lang.String clientId;
            java.lang.String providerName;
            java.lang.Object serverSideTokenCheck;

            /**
             * Sets the value of {@link CognitoIdentityProviderProperty#getClientId}
             * @param clientId The client ID for the Amazon Cognito user pool. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link CognitoIdentityProviderProperty#getProviderName}
             * @param providerName The provider name for an Amazon Cognito user pool. This parameter is required.
             *                     For example: <code>cognito-idp.us-east-2.amazonaws.com/us-east-2_123456789</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerName(java.lang.String providerName) {
                this.providerName = providerName;
                return this;
            }

            /**
             * Sets the value of {@link CognitoIdentityProviderProperty#getServerSideTokenCheck}
             * @param serverSideTokenCheck TRUE if server-side token validation is enabled for the identity provider’s token.
             *                             After you set the <code>ServerSideTokenCheck</code> to TRUE for an identity pool, that identity pool checks with the integrated user pools to make sure the user has not been globally signed out or deleted before the identity pool provides an OIDC token or AWS credentials for the user.
             *                             <p>
             *                             If the user is signed out or deleted, the identity pool returns a 400 Not Authorized error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideTokenCheck(java.lang.Boolean serverSideTokenCheck) {
                this.serverSideTokenCheck = serverSideTokenCheck;
                return this;
            }

            /**
             * Sets the value of {@link CognitoIdentityProviderProperty#getServerSideTokenCheck}
             * @param serverSideTokenCheck TRUE if server-side token validation is enabled for the identity provider’s token.
             *                             After you set the <code>ServerSideTokenCheck</code> to TRUE for an identity pool, that identity pool checks with the integrated user pools to make sure the user has not been globally signed out or deleted before the identity pool provides an OIDC token or AWS credentials for the user.
             *                             <p>
             *                             If the user is signed out or deleted, the identity pool returns a 400 Not Authorized error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideTokenCheck(software.amazon.awscdk.IResolvable serverSideTokenCheck) {
                this.serverSideTokenCheck = serverSideTokenCheck;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoIdentityProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoIdentityProviderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CognitoIdentityProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoIdentityProviderProperty {
            private final java.lang.String clientId;
            private final java.lang.String providerName;
            private final java.lang.Object serverSideTokenCheck;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.providerName = software.amazon.jsii.Kernel.get(this, "providerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverSideTokenCheck = software.amazon.jsii.Kernel.get(this, "serverSideTokenCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
                this.providerName = java.util.Objects.requireNonNull(builder.providerName, "providerName is required");
                this.serverSideTokenCheck = builder.serverSideTokenCheck;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getProviderName() {
                return this.providerName;
            }

            @Override
            public final java.lang.Object getServerSideTokenCheck() {
                return this.serverSideTokenCheck;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientId", om.valueToTree(this.getClientId()));
                data.set("providerName", om.valueToTree(this.getProviderName()));
                if (this.getServerSideTokenCheck() != null) {
                    data.set("serverSideTokenCheck", om.valueToTree(this.getServerSideTokenCheck()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnIdentityPool.CognitoIdentityProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoIdentityProviderProperty.Jsii$Proxy that = (CognitoIdentityProviderProperty.Jsii$Proxy) o;

                if (!clientId.equals(that.clientId)) return false;
                if (!providerName.equals(that.providerName)) return false;
                return this.serverSideTokenCheck != null ? this.serverSideTokenCheck.equals(that.serverSideTokenCheck) : that.serverSideTokenCheck == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientId.hashCode();
                result = 31 * result + (this.providerName.hashCode());
                result = 31 * result + (this.serverSideTokenCheck != null ? this.serverSideTokenCheck.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>CognitoStreams</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html">AWS::Cognito::IdentityPool</a> resource that defines configuration options for Amazon Cognito streams.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * CognitoStreamsProperty cognitoStreamsProperty = CognitoStreamsProperty.builder()
     *         .roleArn("roleArn")
     *         .streamingStatus("streamingStatus")
     *         .streamName("streamName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnIdentityPool.CognitoStreamsProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoStreamsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoStreamsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the role Amazon Cognito can assume to publish to the stream.
         * <p>
         * This role must grant access to Amazon Cognito (cognito-sync) to invoke <code>PutRecord</code> on your Amazon Cognito stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html#cfn-cognito-identitypool-cognitostreams-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html#cfn-cognito-identitypool-cognitostreams-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * Status of the Amazon Cognito streams.
         * <p>
         * Valid values are: <code>ENABLED</code> or <code>DISABLED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html#cfn-cognito-identitypool-cognitostreams-streamingstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html#cfn-cognito-identitypool-cognitostreams-streamingstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamingStatus() {
            return null;
        }

        /**
         * The name of the Amazon Cognito stream to receive updates.
         * <p>
         * This stream must be in the developer's account and in the same Region as the identity pool.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html#cfn-cognito-identitypool-cognitostreams-streamname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html#cfn-cognito-identitypool-cognitostreams-streamname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CognitoStreamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoStreamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoStreamsProperty> {
            java.lang.String roleArn;
            java.lang.String streamingStatus;
            java.lang.String streamName;

            /**
             * Sets the value of {@link CognitoStreamsProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the role Amazon Cognito can assume to publish to the stream.
             *                This role must grant access to Amazon Cognito (cognito-sync) to invoke <code>PutRecord</code> on your Amazon Cognito stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link CognitoStreamsProperty#getStreamingStatus}
             * @param streamingStatus Status of the Amazon Cognito streams.
             *                        Valid values are: <code>ENABLED</code> or <code>DISABLED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamingStatus(java.lang.String streamingStatus) {
                this.streamingStatus = streamingStatus;
                return this;
            }

            /**
             * Sets the value of {@link CognitoStreamsProperty#getStreamName}
             * @param streamName The name of the Amazon Cognito stream to receive updates.
             *                   This stream must be in the developer's account and in the same Region as the identity pool.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamName(java.lang.String streamName) {
                this.streamName = streamName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoStreamsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoStreamsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CognitoStreamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoStreamsProperty {
            private final java.lang.String roleArn;
            private final java.lang.String streamingStatus;
            private final java.lang.String streamName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.streamingStatus = software.amazon.jsii.Kernel.get(this, "streamingStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.streamName = software.amazon.jsii.Kernel.get(this, "streamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = builder.roleArn;
                this.streamingStatus = builder.streamingStatus;
                this.streamName = builder.streamName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getStreamingStatus() {
                return this.streamingStatus;
            }

            @Override
            public final java.lang.String getStreamName() {
                return this.streamName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getStreamingStatus() != null) {
                    data.set("streamingStatus", om.valueToTree(this.getStreamingStatus()));
                }
                if (this.getStreamName() != null) {
                    data.set("streamName", om.valueToTree(this.getStreamName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnIdentityPool.CognitoStreamsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoStreamsProperty.Jsii$Proxy that = (CognitoStreamsProperty.Jsii$Proxy) o;

                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                if (this.streamingStatus != null ? !this.streamingStatus.equals(that.streamingStatus) : that.streamingStatus != null) return false;
                return this.streamName != null ? this.streamName.equals(that.streamName) : that.streamName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn != null ? this.roleArn.hashCode() : 0;
                result = 31 * result + (this.streamingStatus != null ? this.streamingStatus.hashCode() : 0);
                result = 31 * result + (this.streamName != null ? this.streamName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>PushSync</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html">AWS::Cognito::IdentityPool</a> resource that defines the configuration options to be applied to an Amazon Cognito identity pool.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * PushSyncProperty pushSyncProperty = PushSyncProperty.builder()
     *         .applicationArns(List.of("applicationArns"))
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-pushsync.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-pushsync.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnIdentityPool.PushSyncProperty")
    @software.amazon.jsii.Jsii.Proxy(PushSyncProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PushSyncProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARNs of the Amazon SNS platform applications that could be used by clients.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-pushsync.html#cfn-cognito-identitypool-pushsync-applicationarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-pushsync.html#cfn-cognito-identitypool-pushsync-applicationarns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getApplicationArns() {
            return null;
        }

        /**
         * An IAM role configured to allow Amazon Cognito to call Amazon SNS on behalf of the developer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-pushsync.html#cfn-cognito-identitypool-pushsync-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-pushsync.html#cfn-cognito-identitypool-pushsync-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PushSyncProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PushSyncProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PushSyncProperty> {
            java.util.List<java.lang.String> applicationArns;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link PushSyncProperty#getApplicationArns}
             * @param applicationArns The ARNs of the Amazon SNS platform applications that could be used by clients.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationArns(java.util.List<java.lang.String> applicationArns) {
                this.applicationArns = applicationArns;
                return this;
            }

            /**
             * Sets the value of {@link PushSyncProperty#getRoleArn}
             * @param roleArn An IAM role configured to allow Amazon Cognito to call Amazon SNS on behalf of the developer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PushSyncProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PushSyncProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PushSyncProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PushSyncProperty {
            private final java.util.List<java.lang.String> applicationArns;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationArns = software.amazon.jsii.Kernel.get(this, "applicationArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationArns = builder.applicationArns;
                this.roleArn = builder.roleArn;
            }

            @Override
            public final java.util.List<java.lang.String> getApplicationArns() {
                return this.applicationArns;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApplicationArns() != null) {
                    data.set("applicationArns", om.valueToTree(this.getApplicationArns()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnIdentityPool.PushSyncProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PushSyncProperty.Jsii$Proxy that = (PushSyncProperty.Jsii$Proxy) o;

                if (this.applicationArns != null ? !this.applicationArns.equals(that.applicationArns) : that.applicationArns != null) return false;
                return this.roleArn != null ? this.roleArn.equals(that.roleArn) : that.roleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.applicationArns != null ? this.applicationArns.hashCode() : 0;
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.CfnIdentityPool}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.CfnIdentityPool> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.CfnIdentityPoolProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.CfnIdentityPoolProps.Builder();
        }

        /**
         * Specifies whether the identity pool supports unauthenticated logins.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowunauthenticatedidentities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowunauthenticatedidentities</a>
         * @param allowUnauthenticatedIdentities Specifies whether the identity pool supports unauthenticated logins. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowUnauthenticatedIdentities(final java.lang.Boolean allowUnauthenticatedIdentities) {
            this.props.allowUnauthenticatedIdentities(allowUnauthenticatedIdentities);
            return this;
        }
        /**
         * Specifies whether the identity pool supports unauthenticated logins.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowunauthenticatedidentities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowunauthenticatedidentities</a>
         * @param allowUnauthenticatedIdentities Specifies whether the identity pool supports unauthenticated logins. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowUnauthenticatedIdentities(final software.amazon.awscdk.IResolvable allowUnauthenticatedIdentities) {
            this.props.allowUnauthenticatedIdentities(allowUnauthenticatedIdentities);
            return this;
        }

        /**
         * Enables the Basic (Classic) authentication flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowclassicflow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowclassicflow</a>
         * @param allowClassicFlow Enables the Basic (Classic) authentication flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowClassicFlow(final java.lang.Boolean allowClassicFlow) {
            this.props.allowClassicFlow(allowClassicFlow);
            return this;
        }
        /**
         * Enables the Basic (Classic) authentication flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowclassicflow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowclassicflow</a>
         * @param allowClassicFlow Enables the Basic (Classic) authentication flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowClassicFlow(final software.amazon.awscdk.IResolvable allowClassicFlow) {
            this.props.allowClassicFlow(allowClassicFlow);
            return this;
        }

        /**
         * The events to configure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoevents</a>
         * @param cognitoEvents The events to configure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoEvents(final java.lang.Object cognitoEvents) {
            this.props.cognitoEvents(cognitoEvents);
            return this;
        }

        /**
         * The Amazon Cognito user pools and their client IDs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoidentityproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoidentityproviders</a>
         * @param cognitoIdentityProviders The Amazon Cognito user pools and their client IDs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoIdentityProviders(final software.amazon.awscdk.IResolvable cognitoIdentityProviders) {
            this.props.cognitoIdentityProviders(cognitoIdentityProviders);
            return this;
        }
        /**
         * The Amazon Cognito user pools and their client IDs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoidentityproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoidentityproviders</a>
         * @param cognitoIdentityProviders The Amazon Cognito user pools and their client IDs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoIdentityProviders(final java.util.List<? extends java.lang.Object> cognitoIdentityProviders) {
            this.props.cognitoIdentityProviders(cognitoIdentityProviders);
            return this;
        }

        /**
         * Configuration options for configuring Amazon Cognito streams.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitostreams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitostreams</a>
         * @param cognitoStreams Configuration options for configuring Amazon Cognito streams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoStreams(final software.amazon.awscdk.IResolvable cognitoStreams) {
            this.props.cognitoStreams(cognitoStreams);
            return this;
        }
        /**
         * Configuration options for configuring Amazon Cognito streams.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitostreams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitostreams</a>
         * @param cognitoStreams Configuration options for configuring Amazon Cognito streams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoStreams(final software.amazon.awscdk.services.cognito.CfnIdentityPool.CognitoStreamsProperty cognitoStreams) {
            this.props.cognitoStreams(cognitoStreams);
            return this;
        }

        /**
         * The "domain" Amazon Cognito uses when referencing your users.
         * <p>
         * This name acts as a placeholder that allows your backend and the Amazon Cognito service to communicate about the developer provider. For the <code>DeveloperProviderName</code> , you can use letters and periods (.), underscores (_), and dashes (-).
         * <p>
         * <em>Minimum length</em> : 1
         * <p>
         * <em>Maximum length</em> : 100
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-developerprovidername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-developerprovidername</a>
         * @param developerProviderName The "domain" Amazon Cognito uses when referencing your users. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder developerProviderName(final java.lang.String developerProviderName) {
            this.props.developerProviderName(developerProviderName);
            return this;
        }

        /**
         * The name of your Amazon Cognito identity pool.
         * <p>
         * <em>Minimum length</em> : 1
         * <p>
         * <em>Maximum length</em> : 128
         * <p>
         * <em>Pattern</em> : <code>[\w\s+=,.&#64;-]+</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-identitypoolname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-identitypoolname</a>
         * @param identityPoolName The name of your Amazon Cognito identity pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityPoolName(final java.lang.String identityPoolName) {
            this.props.identityPoolName(identityPoolName);
            return this;
        }

        /**
         * Tags to assign to the identity pool.
         * <p>
         * A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-identitypooltags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-identitypooltags</a>
         * @param identityPoolTags Tags to assign to the identity pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityPoolTags(final java.util.List<? extends software.amazon.awscdk.CfnTag> identityPoolTags) {
            this.props.identityPoolTags(identityPoolTags);
            return this;
        }

        /**
         * The Amazon Resource Names (ARNs) of the OpenID connect providers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-openidconnectproviderarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-openidconnectproviderarns</a>
         * @param openIdConnectProviderArns The Amazon Resource Names (ARNs) of the OpenID connect providers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectProviderArns(final java.util.List<java.lang.String> openIdConnectProviderArns) {
            this.props.openIdConnectProviderArns(openIdConnectProviderArns);
            return this;
        }

        /**
         * The configuration options to be applied to the identity pool.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-pushsync">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-pushsync</a>
         * @param pushSync The configuration options to be applied to the identity pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pushSync(final software.amazon.awscdk.IResolvable pushSync) {
            this.props.pushSync(pushSync);
            return this;
        }
        /**
         * The configuration options to be applied to the identity pool.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-pushsync">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-pushsync</a>
         * @param pushSync The configuration options to be applied to the identity pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pushSync(final software.amazon.awscdk.services.cognito.CfnIdentityPool.PushSyncProperty pushSync) {
            this.props.pushSync(pushSync);
            return this;
        }

        /**
         * The Amazon Resource Names (ARNs) of the Security Assertion Markup Language (SAML) providers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-samlproviderarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-samlproviderarns</a>
         * @param samlProviderArns The Amazon Resource Names (ARNs) of the Security Assertion Markup Language (SAML) providers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samlProviderArns(final java.util.List<java.lang.String> samlProviderArns) {
            this.props.samlProviderArns(samlProviderArns);
            return this;
        }

        /**
         * Key-value pairs that map provider names to provider app IDs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-supportedloginproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-supportedloginproviders</a>
         * @param supportedLoginProviders Key-value pairs that map provider names to provider app IDs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportedLoginProviders(final java.lang.Object supportedLoginProviders) {
            this.props.supportedLoginProviders(supportedLoginProviders);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cognito.CfnIdentityPool}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.CfnIdentityPool build() {
            return new software.amazon.awscdk.services.cognito.CfnIdentityPool(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
