package software.amazon.awscdk.services.cognito;

/**
 * The different ways in which a user pool's MFA enforcement can be configured.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         .mfa(Mfa.REQUIRED)
 *         .mfaSecondFactor(MfaSecondFactor.builder()
 *                 .sms(true)
 *                 .otp(true)
 *                 .email(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:12.755Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.Mfa")
public enum Mfa {
    /**
     * Users are not required to use MFA for sign in, and cannot configure one.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OFF,
    /**
     * Users are not required to use MFA for sign in, but can configure one if they so choose to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPTIONAL,
    /**
     * Users are required to configure an MFA, and have to use it to sign in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUIRED,
}
