package software.amazon.awscdk.services.connect;

/**
 * Properties for defining a <code>CfnQueue</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * CfnQueueProps cfnQueueProps = CfnQueueProps.builder()
 *         .hoursOfOperationArn("hoursOfOperationArn")
 *         .instanceArn("instanceArn")
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .maxContacts(123)
 *         .outboundCallerConfig(OutboundCallerConfigProperty.builder()
 *                 .outboundCallerIdName("outboundCallerIdName")
 *                 .outboundCallerIdNumberArn("outboundCallerIdNumberArn")
 *                 .outboundFlowArn("outboundFlowArn")
 *                 .build())
 *         .outboundEmailConfig(OutboundEmailConfigProperty.builder()
 *                 .outboundEmailAddressId("outboundEmailAddressId")
 *                 .build())
 *         .quickConnectArns(List.of("quickConnectArns"))
 *         .status("status")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:12.994Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnQueueProps")
@software.amazon.jsii.Jsii.Proxy(CfnQueueProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnQueueProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the hours of operation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-hoursofoperationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-hoursofoperationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHoursOfOperationArn();

    /**
     * The identifier of the Amazon Connect instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-instancearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn();

    /**
     * The name of the queue.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The description of the queue.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The maximum number of contacts that can be in the queue before it is considered full.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-maxcontacts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-maxcontacts</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxContacts() {
        return null;
    }

    /**
     * The outbound caller ID name, number, and outbound whisper flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-outboundcallerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-outboundcallerconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOutboundCallerConfig() {
        return null;
    }

    /**
     * The outbound email address ID for a specified queue.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-outboundemailconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-outboundemailconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOutboundEmailConfig() {
        return null;
    }

    /**
     * The Amazon Resource Names (ARN) of the of the quick connects available to agents who are working the queue.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-quickconnectarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-quickconnectarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getQuickConnectArns() {
        return null;
    }

    /**
     * The status of the queue.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-status</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-queue.html#cfn-connect-queue-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnQueueProps> {
        java.lang.String hoursOfOperationArn;
        java.lang.String instanceArn;
        java.lang.String name;
        java.lang.String description;
        java.lang.Number maxContacts;
        java.lang.Object outboundCallerConfig;
        java.lang.Object outboundEmailConfig;
        java.util.List<java.lang.String> quickConnectArns;
        java.lang.String status;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnQueueProps#getHoursOfOperationArn}
         * @param hoursOfOperationArn The Amazon Resource Name (ARN) of the hours of operation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hoursOfOperationArn(java.lang.String hoursOfOperationArn) {
            this.hoursOfOperationArn = hoursOfOperationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getInstanceArn}
         * @param instanceArn The identifier of the Amazon Connect instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(java.lang.String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getName}
         * @param name The name of the queue. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getDescription}
         * @param description The description of the queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getMaxContacts}
         * @param maxContacts The maximum number of contacts that can be in the queue before it is considered full.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxContacts(java.lang.Number maxContacts) {
            this.maxContacts = maxContacts;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getOutboundCallerConfig}
         * @param outboundCallerConfig The outbound caller ID name, number, and outbound whisper flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outboundCallerConfig(software.amazon.awscdk.IResolvable outboundCallerConfig) {
            this.outboundCallerConfig = outboundCallerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getOutboundCallerConfig}
         * @param outboundCallerConfig The outbound caller ID name, number, and outbound whisper flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outboundCallerConfig(software.amazon.awscdk.services.connect.CfnQueue.OutboundCallerConfigProperty outboundCallerConfig) {
            this.outboundCallerConfig = outboundCallerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getOutboundEmailConfig}
         * @param outboundEmailConfig The outbound email address ID for a specified queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outboundEmailConfig(software.amazon.awscdk.IResolvable outboundEmailConfig) {
            this.outboundEmailConfig = outboundEmailConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getOutboundEmailConfig}
         * @param outboundEmailConfig The outbound email address ID for a specified queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outboundEmailConfig(software.amazon.awscdk.services.connect.CfnQueue.OutboundEmailConfigProperty outboundEmailConfig) {
            this.outboundEmailConfig = outboundEmailConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getQuickConnectArns}
         * @param quickConnectArns The Amazon Resource Names (ARN) of the of the quick connects available to agents who are working the queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quickConnectArns(java.util.List<java.lang.String> quickConnectArns) {
            this.quickConnectArns = quickConnectArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getStatus}
         * @param status The status of the queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         *             For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnQueueProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnQueueProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnQueueProps {
        private final java.lang.String hoursOfOperationArn;
        private final java.lang.String instanceArn;
        private final java.lang.String name;
        private final java.lang.String description;
        private final java.lang.Number maxContacts;
        private final java.lang.Object outboundCallerConfig;
        private final java.lang.Object outboundEmailConfig;
        private final java.util.List<java.lang.String> quickConnectArns;
        private final java.lang.String status;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hoursOfOperationArn = software.amazon.jsii.Kernel.get(this, "hoursOfOperationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceArn = software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxContacts = software.amazon.jsii.Kernel.get(this, "maxContacts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.outboundCallerConfig = software.amazon.jsii.Kernel.get(this, "outboundCallerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.outboundEmailConfig = software.amazon.jsii.Kernel.get(this, "outboundEmailConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.quickConnectArns = software.amazon.jsii.Kernel.get(this, "quickConnectArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hoursOfOperationArn = java.util.Objects.requireNonNull(builder.hoursOfOperationArn, "hoursOfOperationArn is required");
            this.instanceArn = java.util.Objects.requireNonNull(builder.instanceArn, "instanceArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.description = builder.description;
            this.maxContacts = builder.maxContacts;
            this.outboundCallerConfig = builder.outboundCallerConfig;
            this.outboundEmailConfig = builder.outboundEmailConfig;
            this.quickConnectArns = builder.quickConnectArns;
            this.status = builder.status;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getHoursOfOperationArn() {
            return this.hoursOfOperationArn;
        }

        @Override
        public final java.lang.String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getMaxContacts() {
            return this.maxContacts;
        }

        @Override
        public final java.lang.Object getOutboundCallerConfig() {
            return this.outboundCallerConfig;
        }

        @Override
        public final java.lang.Object getOutboundEmailConfig() {
            return this.outboundEmailConfig;
        }

        @Override
        public final java.util.List<java.lang.String> getQuickConnectArns() {
            return this.quickConnectArns;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hoursOfOperationArn", om.valueToTree(this.getHoursOfOperationArn()));
            data.set("instanceArn", om.valueToTree(this.getInstanceArn()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getMaxContacts() != null) {
                data.set("maxContacts", om.valueToTree(this.getMaxContacts()));
            }
            if (this.getOutboundCallerConfig() != null) {
                data.set("outboundCallerConfig", om.valueToTree(this.getOutboundCallerConfig()));
            }
            if (this.getOutboundEmailConfig() != null) {
                data.set("outboundEmailConfig", om.valueToTree(this.getOutboundEmailConfig()));
            }
            if (this.getQuickConnectArns() != null) {
                data.set("quickConnectArns", om.valueToTree(this.getQuickConnectArns()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnQueueProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnQueueProps.Jsii$Proxy that = (CfnQueueProps.Jsii$Proxy) o;

            if (!hoursOfOperationArn.equals(that.hoursOfOperationArn)) return false;
            if (!instanceArn.equals(that.instanceArn)) return false;
            if (!name.equals(that.name)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.maxContacts != null ? !this.maxContacts.equals(that.maxContacts) : that.maxContacts != null) return false;
            if (this.outboundCallerConfig != null ? !this.outboundCallerConfig.equals(that.outboundCallerConfig) : that.outboundCallerConfig != null) return false;
            if (this.outboundEmailConfig != null ? !this.outboundEmailConfig.equals(that.outboundEmailConfig) : that.outboundEmailConfig != null) return false;
            if (this.quickConnectArns != null ? !this.quickConnectArns.equals(that.quickConnectArns) : that.quickConnectArns != null) return false;
            if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.hoursOfOperationArn.hashCode();
            result = 31 * result + (this.instanceArn.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.maxContacts != null ? this.maxContacts.hashCode() : 0);
            result = 31 * result + (this.outboundCallerConfig != null ? this.outboundCallerConfig.hashCode() : 0);
            result = 31 * result + (this.outboundEmailConfig != null ? this.outboundEmailConfig.hashCode() : 0);
            result = 31 * result + (this.quickConnectArns != null ? this.quickConnectArns.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
