package software.amazon.awscdk.services.datasync;

/**
 * Properties for defining a <code>CfnLocationAzureBlob</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnLocationAzureBlobProps cfnLocationAzureBlobProps = CfnLocationAzureBlobProps.builder()
 *         .azureBlobAuthenticationType("azureBlobAuthenticationType")
 *         // the properties below are optional
 *         .agentArns(List.of("agentArns"))
 *         .azureAccessTier("azureAccessTier")
 *         .azureBlobContainerUrl("azureBlobContainerUrl")
 *         .azureBlobSasConfiguration(AzureBlobSasConfigurationProperty.builder()
 *                 .azureBlobSasToken("azureBlobSasToken")
 *                 .build())
 *         .azureBlobType("azureBlobType")
 *         .cmkSecretConfig(CmkSecretConfigProperty.builder()
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .secretArn("secretArn")
 *                 .build())
 *         .customSecretConfig(CustomSecretConfigProperty.builder()
 *                 .secretAccessRoleArn("secretAccessRoleArn")
 *                 .secretArn("secretArn")
 *                 .build())
 *         .subdirectory("subdirectory")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:13.234Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnLocationAzureBlobProps")
@software.amazon.jsii.Jsii.Proxy(CfnLocationAzureBlobProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLocationAzureBlobProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the authentication method DataSync uses to access your Azure Blob Storage.
     * <p>
     * DataSync can access blob storage using a shared access signature (SAS).
     * <p>
     * Default: - "SAS"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-azureblobauthenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-azureblobauthenticationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAzureBlobAuthenticationType();

    /**
     * (Optional) Specifies the Amazon Resource Name (ARN) of the DataSync agent that can connect with your Azure Blob Storage container.
     * <p>
     * If you are setting up an agentless cross-cloud transfer, you do not need to specify a value for this parameter.
     * <p>
     * You can specify more than one agent. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/multiple-agents.html">Using multiple agents for your transfer</a> .
     * <p>
     * <blockquote>
     * <p>
     * Make sure you configure this parameter correctly when you first create your storage location. You cannot add or remove agents from a storage location after you create it.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-agentarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-agentarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAgentArns() {
        return null;
    }

    /**
     * Specifies the access tier that you want your objects or files transferred into.
     * <p>
     * This only applies when using the location as a transfer destination. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers">Access tiers</a> .
     * <p>
     * Default: - "HOT"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-azureaccesstier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-azureaccesstier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAzureAccessTier() {
        return null;
    }

    /**
     * Specifies the URL of the Azure Blob Storage container involved in your transfer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-azureblobcontainerurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-azureblobcontainerurl</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAzureBlobContainerUrl() {
        return null;
    }

    /**
     * Specifies the SAS configuration that allows DataSync to access your Azure Blob Storage.
     * <p>
     * <blockquote>
     * <p>
     * If you provide an authentication token using <code>SasConfiguration</code> , but do not provide secret configuration details using <code>CmkSecretConfig</code> or <code>CustomSecretConfig</code> , then DataSync stores the token using your AWS account's secrets manager secret.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-azureblobsasconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-azureblobsasconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAzureBlobSasConfiguration() {
        return null;
    }

    /**
     * Specifies the type of blob that you want your objects or files to be when transferring them into Azure Blob Storage.
     * <p>
     * Currently, DataSync only supports moving data into Azure Blob Storage as block blobs. For more information on blob types, see the <a href="https://docs.aws.amazon.com/https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs">Azure Blob Storage documentation</a> .
     * <p>
     * Default: - "BLOCK"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-azureblobtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-azureblobtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAzureBlobType() {
        return null;
    }

    /**
     * Specifies configuration information for a DataSync-managed secret, such as an authentication token or secret key that DataSync uses to access a specific storage location, with a customer-managed AWS KMS key .
     * <p>
     * <blockquote>
     * <p>
     * You can use either <code>CmkSecretConfig</code> or <code>CustomSecretConfig</code> to provide credentials for a <code>CreateLocation</code> request. Do not provide both parameters for the same request.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-cmksecretconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-cmksecretconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCmkSecretConfig() {
        return null;
    }

    /**
     * Specifies configuration information for a customer-managed Secrets Manager secret where a storage location authentication token or secret key is stored in plain text.
     * <p>
     * This configuration includes the secret ARN, and the ARN for an IAM role that provides access to the secret.
     * <p>
     * <blockquote>
     * <p>
     * You can use either <code>CmkSecretConfig</code> or <code>CustomSecretConfig</code> to provide credentials for a <code>CreateLocation</code> request. Do not provide both parameters for the same request.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-customsecretconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-customsecretconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomSecretConfig() {
        return null;
    }

    /**
     * Specifies path segments if you want to limit your transfer to a virtual directory in your container (for example, <code>/my/images</code> ).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-subdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-subdirectory</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubdirectory() {
        return null;
    }

    /**
     * Specifies labels that help you categorize, filter, and search for your AWS resources.
     * <p>
     * We recommend creating at least a name tag for your transfer location.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationazureblob.html#cfn-datasync-locationazureblob-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLocationAzureBlobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLocationAzureBlobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLocationAzureBlobProps> {
        java.lang.String azureBlobAuthenticationType;
        java.util.List<java.lang.String> agentArns;
        java.lang.String azureAccessTier;
        java.lang.String azureBlobContainerUrl;
        java.lang.Object azureBlobSasConfiguration;
        java.lang.String azureBlobType;
        java.lang.Object cmkSecretConfig;
        java.lang.Object customSecretConfig;
        java.lang.String subdirectory;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLocationAzureBlobProps#getAzureBlobAuthenticationType}
         * @param azureBlobAuthenticationType Specifies the authentication method DataSync uses to access your Azure Blob Storage. This parameter is required.
         *                                    DataSync can access blob storage using a shared access signature (SAS).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder azureBlobAuthenticationType(java.lang.String azureBlobAuthenticationType) {
            this.azureBlobAuthenticationType = azureBlobAuthenticationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationAzureBlobProps#getAgentArns}
         * @param agentArns (Optional) Specifies the Amazon Resource Name (ARN) of the DataSync agent that can connect with your Azure Blob Storage container.
         *                  If you are setting up an agentless cross-cloud transfer, you do not need to specify a value for this parameter.
         *                  <p>
         *                  You can specify more than one agent. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/multiple-agents.html">Using multiple agents for your transfer</a> .
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  Make sure you configure this parameter correctly when you first create your storage location. You cannot add or remove agents from a storage location after you create it.
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentArns(java.util.List<java.lang.String> agentArns) {
            this.agentArns = agentArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationAzureBlobProps#getAzureAccessTier}
         * @param azureAccessTier Specifies the access tier that you want your objects or files transferred into.
         *                        This only applies when using the location as a transfer destination. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers">Access tiers</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder azureAccessTier(java.lang.String azureAccessTier) {
            this.azureAccessTier = azureAccessTier;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationAzureBlobProps#getAzureBlobContainerUrl}
         * @param azureBlobContainerUrl Specifies the URL of the Azure Blob Storage container involved in your transfer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder azureBlobContainerUrl(java.lang.String azureBlobContainerUrl) {
            this.azureBlobContainerUrl = azureBlobContainerUrl;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationAzureBlobProps#getAzureBlobSasConfiguration}
         * @param azureBlobSasConfiguration Specifies the SAS configuration that allows DataSync to access your Azure Blob Storage.
         *                                  <blockquote>
         *                                  <p>
         *                                  If you provide an authentication token using <code>SasConfiguration</code> , but do not provide secret configuration details using <code>CmkSecretConfig</code> or <code>CustomSecretConfig</code> , then DataSync stores the token using your AWS account's secrets manager secret.
         *                                  <p>
         *                                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder azureBlobSasConfiguration(software.amazon.awscdk.IResolvable azureBlobSasConfiguration) {
            this.azureBlobSasConfiguration = azureBlobSasConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationAzureBlobProps#getAzureBlobSasConfiguration}
         * @param azureBlobSasConfiguration Specifies the SAS configuration that allows DataSync to access your Azure Blob Storage.
         *                                  <blockquote>
         *                                  <p>
         *                                  If you provide an authentication token using <code>SasConfiguration</code> , but do not provide secret configuration details using <code>CmkSecretConfig</code> or <code>CustomSecretConfig</code> , then DataSync stores the token using your AWS account's secrets manager secret.
         *                                  <p>
         *                                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder azureBlobSasConfiguration(software.amazon.awscdk.services.datasync.CfnLocationAzureBlob.AzureBlobSasConfigurationProperty azureBlobSasConfiguration) {
            this.azureBlobSasConfiguration = azureBlobSasConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationAzureBlobProps#getAzureBlobType}
         * @param azureBlobType Specifies the type of blob that you want your objects or files to be when transferring them into Azure Blob Storage.
         *                      Currently, DataSync only supports moving data into Azure Blob Storage as block blobs. For more information on blob types, see the <a href="https://docs.aws.amazon.com/https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs">Azure Blob Storage documentation</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder azureBlobType(java.lang.String azureBlobType) {
            this.azureBlobType = azureBlobType;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationAzureBlobProps#getCmkSecretConfig}
         * @param cmkSecretConfig Specifies configuration information for a DataSync-managed secret, such as an authentication token or secret key that DataSync uses to access a specific storage location, with a customer-managed AWS KMS key .
         *                        <blockquote>
         *                        <p>
         *                        You can use either <code>CmkSecretConfig</code> or <code>CustomSecretConfig</code> to provide credentials for a <code>CreateLocation</code> request. Do not provide both parameters for the same request.
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cmkSecretConfig(software.amazon.awscdk.IResolvable cmkSecretConfig) {
            this.cmkSecretConfig = cmkSecretConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationAzureBlobProps#getCmkSecretConfig}
         * @param cmkSecretConfig Specifies configuration information for a DataSync-managed secret, such as an authentication token or secret key that DataSync uses to access a specific storage location, with a customer-managed AWS KMS key .
         *                        <blockquote>
         *                        <p>
         *                        You can use either <code>CmkSecretConfig</code> or <code>CustomSecretConfig</code> to provide credentials for a <code>CreateLocation</code> request. Do not provide both parameters for the same request.
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cmkSecretConfig(software.amazon.awscdk.services.datasync.CfnLocationAzureBlob.CmkSecretConfigProperty cmkSecretConfig) {
            this.cmkSecretConfig = cmkSecretConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationAzureBlobProps#getCustomSecretConfig}
         * @param customSecretConfig Specifies configuration information for a customer-managed Secrets Manager secret where a storage location authentication token or secret key is stored in plain text.
         *                           This configuration includes the secret ARN, and the ARN for an IAM role that provides access to the secret.
         *                           <p>
         *                           <blockquote>
         *                           <p>
         *                           You can use either <code>CmkSecretConfig</code> or <code>CustomSecretConfig</code> to provide credentials for a <code>CreateLocation</code> request. Do not provide both parameters for the same request.
         *                           <p>
         *                           </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customSecretConfig(software.amazon.awscdk.IResolvable customSecretConfig) {
            this.customSecretConfig = customSecretConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationAzureBlobProps#getCustomSecretConfig}
         * @param customSecretConfig Specifies configuration information for a customer-managed Secrets Manager secret where a storage location authentication token or secret key is stored in plain text.
         *                           This configuration includes the secret ARN, and the ARN for an IAM role that provides access to the secret.
         *                           <p>
         *                           <blockquote>
         *                           <p>
         *                           You can use either <code>CmkSecretConfig</code> or <code>CustomSecretConfig</code> to provide credentials for a <code>CreateLocation</code> request. Do not provide both parameters for the same request.
         *                           <p>
         *                           </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customSecretConfig(software.amazon.awscdk.services.datasync.CfnLocationAzureBlob.CustomSecretConfigProperty customSecretConfig) {
            this.customSecretConfig = customSecretConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationAzureBlobProps#getSubdirectory}
         * @param subdirectory Specifies path segments if you want to limit your transfer to a virtual directory in your container (for example, <code>/my/images</code> ).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdirectory(java.lang.String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationAzureBlobProps#getTags}
         * @param tags Specifies labels that help you categorize, filter, and search for your AWS resources.
         *             We recommend creating at least a name tag for your transfer location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLocationAzureBlobProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLocationAzureBlobProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLocationAzureBlobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLocationAzureBlobProps {
        private final java.lang.String azureBlobAuthenticationType;
        private final java.util.List<java.lang.String> agentArns;
        private final java.lang.String azureAccessTier;
        private final java.lang.String azureBlobContainerUrl;
        private final java.lang.Object azureBlobSasConfiguration;
        private final java.lang.String azureBlobType;
        private final java.lang.Object cmkSecretConfig;
        private final java.lang.Object customSecretConfig;
        private final java.lang.String subdirectory;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.azureBlobAuthenticationType = software.amazon.jsii.Kernel.get(this, "azureBlobAuthenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.agentArns = software.amazon.jsii.Kernel.get(this, "agentArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.azureAccessTier = software.amazon.jsii.Kernel.get(this, "azureAccessTier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.azureBlobContainerUrl = software.amazon.jsii.Kernel.get(this, "azureBlobContainerUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.azureBlobSasConfiguration = software.amazon.jsii.Kernel.get(this, "azureBlobSasConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.azureBlobType = software.amazon.jsii.Kernel.get(this, "azureBlobType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cmkSecretConfig = software.amazon.jsii.Kernel.get(this, "cmkSecretConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customSecretConfig = software.amazon.jsii.Kernel.get(this, "customSecretConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subdirectory = software.amazon.jsii.Kernel.get(this, "subdirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.azureBlobAuthenticationType = java.util.Objects.requireNonNull(builder.azureBlobAuthenticationType, "azureBlobAuthenticationType is required");
            this.agentArns = builder.agentArns;
            this.azureAccessTier = builder.azureAccessTier;
            this.azureBlobContainerUrl = builder.azureBlobContainerUrl;
            this.azureBlobSasConfiguration = builder.azureBlobSasConfiguration;
            this.azureBlobType = builder.azureBlobType;
            this.cmkSecretConfig = builder.cmkSecretConfig;
            this.customSecretConfig = builder.customSecretConfig;
            this.subdirectory = builder.subdirectory;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAzureBlobAuthenticationType() {
            return this.azureBlobAuthenticationType;
        }

        @Override
        public final java.util.List<java.lang.String> getAgentArns() {
            return this.agentArns;
        }

        @Override
        public final java.lang.String getAzureAccessTier() {
            return this.azureAccessTier;
        }

        @Override
        public final java.lang.String getAzureBlobContainerUrl() {
            return this.azureBlobContainerUrl;
        }

        @Override
        public final java.lang.Object getAzureBlobSasConfiguration() {
            return this.azureBlobSasConfiguration;
        }

        @Override
        public final java.lang.String getAzureBlobType() {
            return this.azureBlobType;
        }

        @Override
        public final java.lang.Object getCmkSecretConfig() {
            return this.cmkSecretConfig;
        }

        @Override
        public final java.lang.Object getCustomSecretConfig() {
            return this.customSecretConfig;
        }

        @Override
        public final java.lang.String getSubdirectory() {
            return this.subdirectory;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("azureBlobAuthenticationType", om.valueToTree(this.getAzureBlobAuthenticationType()));
            if (this.getAgentArns() != null) {
                data.set("agentArns", om.valueToTree(this.getAgentArns()));
            }
            if (this.getAzureAccessTier() != null) {
                data.set("azureAccessTier", om.valueToTree(this.getAzureAccessTier()));
            }
            if (this.getAzureBlobContainerUrl() != null) {
                data.set("azureBlobContainerUrl", om.valueToTree(this.getAzureBlobContainerUrl()));
            }
            if (this.getAzureBlobSasConfiguration() != null) {
                data.set("azureBlobSasConfiguration", om.valueToTree(this.getAzureBlobSasConfiguration()));
            }
            if (this.getAzureBlobType() != null) {
                data.set("azureBlobType", om.valueToTree(this.getAzureBlobType()));
            }
            if (this.getCmkSecretConfig() != null) {
                data.set("cmkSecretConfig", om.valueToTree(this.getCmkSecretConfig()));
            }
            if (this.getCustomSecretConfig() != null) {
                data.set("customSecretConfig", om.valueToTree(this.getCustomSecretConfig()));
            }
            if (this.getSubdirectory() != null) {
                data.set("subdirectory", om.valueToTree(this.getSubdirectory()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnLocationAzureBlobProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLocationAzureBlobProps.Jsii$Proxy that = (CfnLocationAzureBlobProps.Jsii$Proxy) o;

            if (!azureBlobAuthenticationType.equals(that.azureBlobAuthenticationType)) return false;
            if (this.agentArns != null ? !this.agentArns.equals(that.agentArns) : that.agentArns != null) return false;
            if (this.azureAccessTier != null ? !this.azureAccessTier.equals(that.azureAccessTier) : that.azureAccessTier != null) return false;
            if (this.azureBlobContainerUrl != null ? !this.azureBlobContainerUrl.equals(that.azureBlobContainerUrl) : that.azureBlobContainerUrl != null) return false;
            if (this.azureBlobSasConfiguration != null ? !this.azureBlobSasConfiguration.equals(that.azureBlobSasConfiguration) : that.azureBlobSasConfiguration != null) return false;
            if (this.azureBlobType != null ? !this.azureBlobType.equals(that.azureBlobType) : that.azureBlobType != null) return false;
            if (this.cmkSecretConfig != null ? !this.cmkSecretConfig.equals(that.cmkSecretConfig) : that.cmkSecretConfig != null) return false;
            if (this.customSecretConfig != null ? !this.customSecretConfig.equals(that.customSecretConfig) : that.customSecretConfig != null) return false;
            if (this.subdirectory != null ? !this.subdirectory.equals(that.subdirectory) : that.subdirectory != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.azureBlobAuthenticationType.hashCode();
            result = 31 * result + (this.agentArns != null ? this.agentArns.hashCode() : 0);
            result = 31 * result + (this.azureAccessTier != null ? this.azureAccessTier.hashCode() : 0);
            result = 31 * result + (this.azureBlobContainerUrl != null ? this.azureBlobContainerUrl.hashCode() : 0);
            result = 31 * result + (this.azureBlobSasConfiguration != null ? this.azureBlobSasConfiguration.hashCode() : 0);
            result = 31 * result + (this.azureBlobType != null ? this.azureBlobType.hashCode() : 0);
            result = 31 * result + (this.cmkSecretConfig != null ? this.cmkSecretConfig.hashCode() : 0);
            result = 31 * result + (this.customSecretConfig != null ? this.customSecretConfig.hashCode() : 0);
            result = 31 * result + (this.subdirectory != null ? this.subdirectory.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
