package software.amazon.awscdk.services.datazone;

/**
 * Properties for defining a <code>CfnProjectMembership</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * CfnProjectMembershipProps cfnProjectMembershipProps = CfnProjectMembershipProps.builder()
 *         .designation("designation")
 *         .domainIdentifier("domainIdentifier")
 *         .member(MemberProperty.builder()
 *                 .groupIdentifier("groupIdentifier")
 *                 .userIdentifier("userIdentifier")
 *                 .build())
 *         .projectIdentifier("projectIdentifier")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectmembership.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectmembership.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:13.356Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnProjectMembershipProps")
@software.amazon.jsii.Jsii.Proxy(CfnProjectMembershipProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnProjectMembershipProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The designated role of a project member.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectmembership.html#cfn-datazone-projectmembership-designation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectmembership.html#cfn-datazone-projectmembership-designation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDesignation();

    /**
     * The ID of the Amazon DataZone domain in which project membership is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectmembership.html#cfn-datazone-projectmembership-domainidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectmembership.html#cfn-datazone-projectmembership-domainidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainIdentifier();

    /**
     * The details about a project member.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectmembership.html#cfn-datazone-projectmembership-member">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectmembership.html#cfn-datazone-projectmembership-member</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getMember();

    /**
     * The ID of the project for which this project membership was created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectmembership.html#cfn-datazone-projectmembership-projectidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-projectmembership.html#cfn-datazone-projectmembership-projectidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProjectIdentifier();

    /**
     * @return a {@link Builder} of {@link CfnProjectMembershipProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnProjectMembershipProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnProjectMembershipProps> {
        java.lang.String designation;
        java.lang.String domainIdentifier;
        java.lang.Object member;
        java.lang.String projectIdentifier;

        /**
         * Sets the value of {@link CfnProjectMembershipProps#getDesignation}
         * @param designation The designated role of a project member. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder designation(java.lang.String designation) {
            this.designation = designation;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectMembershipProps#getDomainIdentifier}
         * @param domainIdentifier The ID of the Amazon DataZone domain in which project membership is created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(java.lang.String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectMembershipProps#getMember}
         * @param member The details about a project member. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder member(software.amazon.awscdk.IResolvable member) {
            this.member = member;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectMembershipProps#getMember}
         * @param member The details about a project member. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder member(software.amazon.awscdk.services.datazone.CfnProjectMembership.MemberProperty member) {
            this.member = member;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectMembershipProps#getProjectIdentifier}
         * @param projectIdentifier The ID of the project for which this project membership was created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectIdentifier(java.lang.String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnProjectMembershipProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnProjectMembershipProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnProjectMembershipProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnProjectMembershipProps {
        private final java.lang.String designation;
        private final java.lang.String domainIdentifier;
        private final java.lang.Object member;
        private final java.lang.String projectIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.designation = software.amazon.jsii.Kernel.get(this, "designation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainIdentifier = software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.member = software.amazon.jsii.Kernel.get(this, "member", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.projectIdentifier = software.amazon.jsii.Kernel.get(this, "projectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.designation = java.util.Objects.requireNonNull(builder.designation, "designation is required");
            this.domainIdentifier = java.util.Objects.requireNonNull(builder.domainIdentifier, "domainIdentifier is required");
            this.member = java.util.Objects.requireNonNull(builder.member, "member is required");
            this.projectIdentifier = java.util.Objects.requireNonNull(builder.projectIdentifier, "projectIdentifier is required");
        }

        @Override
        public final java.lang.String getDesignation() {
            return this.designation;
        }

        @Override
        public final java.lang.String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        @Override
        public final java.lang.Object getMember() {
            return this.member;
        }

        @Override
        public final java.lang.String getProjectIdentifier() {
            return this.projectIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("designation", om.valueToTree(this.getDesignation()));
            data.set("domainIdentifier", om.valueToTree(this.getDomainIdentifier()));
            data.set("member", om.valueToTree(this.getMember()));
            data.set("projectIdentifier", om.valueToTree(this.getProjectIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnProjectMembershipProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnProjectMembershipProps.Jsii$Proxy that = (CfnProjectMembershipProps.Jsii$Proxy) o;

            if (!designation.equals(that.designation)) return false;
            if (!domainIdentifier.equals(that.domainIdentifier)) return false;
            if (!member.equals(that.member)) return false;
            return this.projectIdentifier.equals(that.projectIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.designation.hashCode();
            result = 31 * result + (this.domainIdentifier.hashCode());
            result = 31 * result + (this.member.hashCode());
            result = 31 * result + (this.projectIdentifier.hashCode());
            return result;
        }
    }
}
