package software.amazon.awscdk.services.devopsguru;

/**
 * Properties for defining a <code>CfnResourceCollection</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.devopsguru.*;
 * CfnResourceCollectionProps cfnResourceCollectionProps = CfnResourceCollectionProps.builder()
 *         .resourceCollectionFilter(ResourceCollectionFilterProperty.builder()
 *                 .cloudFormation(CloudFormationCollectionFilterProperty.builder()
 *                         .stackNames(List.of("stackNames"))
 *                         .build())
 *                 .tags(List.of(TagCollectionProperty.builder()
 *                         .appBoundaryKey("appBoundaryKey")
 *                         .tagValues(List.of("tagValues"))
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:13.463Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_devopsguru.CfnResourceCollectionProps")
@software.amazon.jsii.Jsii.Proxy(CfnResourceCollectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResourceCollectionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResourceCollectionFilter();

    /**
     * @return a {@link Builder} of {@link CfnResourceCollectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResourceCollectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResourceCollectionProps> {
        java.lang.Object resourceCollectionFilter;

        /**
         * Sets the value of {@link CfnResourceCollectionProps#getResourceCollectionFilter}
         * @param resourceCollectionFilter Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceCollectionFilter(software.amazon.awscdk.IResolvable resourceCollectionFilter) {
            this.resourceCollectionFilter = resourceCollectionFilter;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceCollectionProps#getResourceCollectionFilter}
         * @param resourceCollectionFilter Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceCollectionFilter(software.amazon.awscdk.services.devopsguru.CfnResourceCollection.ResourceCollectionFilterProperty resourceCollectionFilter) {
            this.resourceCollectionFilter = resourceCollectionFilter;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourceCollectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResourceCollectionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResourceCollectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResourceCollectionProps {
        private final java.lang.Object resourceCollectionFilter;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceCollectionFilter = software.amazon.jsii.Kernel.get(this, "resourceCollectionFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceCollectionFilter = java.util.Objects.requireNonNull(builder.resourceCollectionFilter, "resourceCollectionFilter is required");
        }

        @Override
        public final java.lang.Object getResourceCollectionFilter() {
            return this.resourceCollectionFilter;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceCollectionFilter", om.valueToTree(this.getResourceCollectionFilter()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_devopsguru.CfnResourceCollectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResourceCollectionProps.Jsii$Proxy that = (CfnResourceCollectionProps.Jsii$Proxy) o;

            return this.resourceCollectionFilter.equals(that.resourceCollectionFilter);
        }

        @Override
        public final int hashCode() {
            int result = this.resourceCollectionFilter.hashCode();
            return result;
        }
    }
}
