package software.amazon.awscdk.services.docdb;

/**
 * The storage type of the DocDB cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .masterUser(Login.builder()
 *                 .username("myuser")
 *                 .build())
 *         .instanceType(InstanceType.of(InstanceClass.MEMORY5, InstanceSize.LARGE))
 *         .vpc(vpc)
 *         .storageType(StorageType.IOPT1)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:13.650Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.StorageType")
public enum StorageType {
    /**
     * Standard storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * I/O-optimized storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IOPT1,
}
