package software.amazon.awscdk.services.dynamodb;

/**
 * Properties used to configure a replica table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = Stack.Builder.create(app, "Stack").env(Environment.builder().region("us-west-2").build()).build();
 * TableV2 globalTable = TableV2.Builder.create(stack, "GlobalTable")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         .replicas(List.of(ReplicaTableProps.builder().region("us-east-1").build()))
 *         .build();
 * globalTable.addReplica(ReplicaTableProps.builder().region("us-east-2").deletionProtection(true).build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:13.753Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.ReplicaTableProps")
@software.amazon.jsii.Jsii.Proxy(ReplicaTableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ReplicaTableProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.dynamodb.TableOptionsV2 {

    /**
     * The region that the replica table will be created in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRegion();

    /**
     * Options used to configure global secondary index properties.
     * <p>
     * Default: - inherited from the primary table
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.dynamodb.ReplicaGlobalSecondaryIndexOptions> getGlobalSecondaryIndexOptions() {
        return null;
    }

    /**
     * The maximum read request units.
     * <p>
     * Note: This can only be configured if the primary table billing is PAY_PER_REQUEST.
     * <p>
     * Default: - inherited from the primary table
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxReadRequestUnits() {
        return null;
    }

    /**
     * The read capacity.
     * <p>
     * Note: This can only be configured if the primary table billing is provisioned.
     * <p>
     * Default: - inherited from the primary table
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.Capacity getReadCapacity() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ReplicaTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ReplicaTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ReplicaTableProps> {
        java.lang.String region;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.dynamodb.ReplicaGlobalSecondaryIndexOptions> globalSecondaryIndexOptions;
        java.lang.Number maxReadRequestUnits;
        software.amazon.awscdk.services.dynamodb.Capacity readCapacity;
        java.lang.Boolean contributorInsights;
        java.lang.Boolean deletionProtection;
        software.amazon.awscdk.services.kinesis.IStream kinesisStream;
        java.lang.Boolean pointInTimeRecovery;
        software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification pointInTimeRecoverySpecification;
        software.amazon.awscdk.services.iam.PolicyDocument resourcePolicy;
        software.amazon.awscdk.services.dynamodb.TableClass tableClass;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link ReplicaTableProps#getRegion}
         * @param region The region that the replica table will be created in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link ReplicaTableProps#getGlobalSecondaryIndexOptions}
         * @param globalSecondaryIndexOptions Options used to configure global secondary index properties.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder globalSecondaryIndexOptions(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.dynamodb.ReplicaGlobalSecondaryIndexOptions> globalSecondaryIndexOptions) {
            this.globalSecondaryIndexOptions = (java.util.Map<java.lang.String, software.amazon.awscdk.services.dynamodb.ReplicaGlobalSecondaryIndexOptions>)globalSecondaryIndexOptions;
            return this;
        }

        /**
         * Sets the value of {@link ReplicaTableProps#getMaxReadRequestUnits}
         * @param maxReadRequestUnits The maximum read request units.
         *                            Note: This can only be configured if the primary table billing is PAY_PER_REQUEST.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxReadRequestUnits(java.lang.Number maxReadRequestUnits) {
            this.maxReadRequestUnits = maxReadRequestUnits;
            return this;
        }

        /**
         * Sets the value of {@link ReplicaTableProps#getReadCapacity}
         * @param readCapacity The read capacity.
         *                     Note: This can only be configured if the primary table billing is provisioned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readCapacity(software.amazon.awscdk.services.dynamodb.Capacity readCapacity) {
            this.readCapacity = readCapacity;
            return this;
        }

        /**
         * Sets the value of {@link ReplicaTableProps#getContributorInsights}
         * @param contributorInsights Whether CloudWatch contributor insights is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contributorInsights(java.lang.Boolean contributorInsights) {
            this.contributorInsights = contributorInsights;
            return this;
        }

        /**
         * Sets the value of {@link ReplicaTableProps#getDeletionProtection}
         * @param deletionProtection Whether deletion protection is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link ReplicaTableProps#getKinesisStream}
         * @param kinesisStream Kinesis Data Stream to capture item level changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStream(software.amazon.awscdk.services.kinesis.IStream kinesisStream) {
            this.kinesisStream = kinesisStream;
            return this;
        }

        /**
         * Sets the value of {@link ReplicaTableProps#getPointInTimeRecovery}
         * @param pointInTimeRecovery Whether point-in-time recovery is enabled.
         * @return {@code this}
         * @deprecated use `pointInTimeRecoverySpecification` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pointInTimeRecovery(java.lang.Boolean pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        /**
         * Sets the value of {@link ReplicaTableProps#getPointInTimeRecoverySpecification}
         * @param pointInTimeRecoverySpecification Whether point-in-time recovery is enabled and recoveryPeriodInDays is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoverySpecification(software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification pointInTimeRecoverySpecification) {
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
            return this;
        }

        /**
         * Sets the value of {@link ReplicaTableProps#getResourcePolicy}
         * @param resourcePolicy Resource policy to assign to DynamoDB Table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePolicy(software.amazon.awscdk.services.iam.PolicyDocument resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        /**
         * Sets the value of {@link ReplicaTableProps#getTableClass}
         * @param tableClass The table class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableClass(software.amazon.awscdk.services.dynamodb.TableClass tableClass) {
            this.tableClass = tableClass;
            return this;
        }

        /**
         * Sets the value of {@link ReplicaTableProps#getTags}
         * @param tags Tags to be applied to the primary table (default replica table).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ReplicaTableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ReplicaTableProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ReplicaTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicaTableProps {
        private final java.lang.String region;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.dynamodb.ReplicaGlobalSecondaryIndexOptions> globalSecondaryIndexOptions;
        private final java.lang.Number maxReadRequestUnits;
        private final software.amazon.awscdk.services.dynamodb.Capacity readCapacity;
        private final java.lang.Boolean contributorInsights;
        private final java.lang.Boolean deletionProtection;
        private final software.amazon.awscdk.services.kinesis.IStream kinesisStream;
        private final java.lang.Boolean pointInTimeRecovery;
        private final software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification pointInTimeRecoverySpecification;
        private final software.amazon.awscdk.services.iam.PolicyDocument resourcePolicy;
        private final software.amazon.awscdk.services.dynamodb.TableClass tableClass;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.globalSecondaryIndexOptions = software.amazon.jsii.Kernel.get(this, "globalSecondaryIndexOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ReplicaGlobalSecondaryIndexOptions.class)));
            this.maxReadRequestUnits = software.amazon.jsii.Kernel.get(this, "maxReadRequestUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.readCapacity = software.amazon.jsii.Kernel.get(this, "readCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Capacity.class));
            this.contributorInsights = software.amazon.jsii.Kernel.get(this, "contributorInsights", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.kinesisStream = software.amazon.jsii.Kernel.get(this, "kinesisStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.IStream.class));
            this.pointInTimeRecovery = software.amazon.jsii.Kernel.get(this, "pointInTimeRecovery", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.pointInTimeRecoverySpecification = software.amazon.jsii.Kernel.get(this, "pointInTimeRecoverySpecification", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification.class));
            this.resourcePolicy = software.amazon.jsii.Kernel.get(this, "resourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
            this.tableClass = software.amazon.jsii.Kernel.get(this, "tableClass", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.TableClass.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
            this.globalSecondaryIndexOptions = (java.util.Map<java.lang.String, software.amazon.awscdk.services.dynamodb.ReplicaGlobalSecondaryIndexOptions>)builder.globalSecondaryIndexOptions;
            this.maxReadRequestUnits = builder.maxReadRequestUnits;
            this.readCapacity = builder.readCapacity;
            this.contributorInsights = builder.contributorInsights;
            this.deletionProtection = builder.deletionProtection;
            this.kinesisStream = builder.kinesisStream;
            this.pointInTimeRecovery = builder.pointInTimeRecovery;
            this.pointInTimeRecoverySpecification = builder.pointInTimeRecoverySpecification;
            this.resourcePolicy = builder.resourcePolicy;
            this.tableClass = builder.tableClass;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.dynamodb.ReplicaGlobalSecondaryIndexOptions> getGlobalSecondaryIndexOptions() {
            return this.globalSecondaryIndexOptions;
        }

        @Override
        public final java.lang.Number getMaxReadRequestUnits() {
            return this.maxReadRequestUnits;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Capacity getReadCapacity() {
            return this.readCapacity;
        }

        @Override
        public final java.lang.Boolean getContributorInsights() {
            return this.contributorInsights;
        }

        @Override
        public final java.lang.Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.IStream getKinesisStream() {
            return this.kinesisStream;
        }

        @Override
        public final java.lang.Boolean getPointInTimeRecovery() {
            return this.pointInTimeRecovery;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification getPointInTimeRecoverySpecification() {
            return this.pointInTimeRecoverySpecification;
        }

        @Override
        public final software.amazon.awscdk.services.iam.PolicyDocument getResourcePolicy() {
            return this.resourcePolicy;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.TableClass getTableClass() {
            return this.tableClass;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("region", om.valueToTree(this.getRegion()));
            if (this.getGlobalSecondaryIndexOptions() != null) {
                data.set("globalSecondaryIndexOptions", om.valueToTree(this.getGlobalSecondaryIndexOptions()));
            }
            if (this.getMaxReadRequestUnits() != null) {
                data.set("maxReadRequestUnits", om.valueToTree(this.getMaxReadRequestUnits()));
            }
            if (this.getReadCapacity() != null) {
                data.set("readCapacity", om.valueToTree(this.getReadCapacity()));
            }
            if (this.getContributorInsights() != null) {
                data.set("contributorInsights", om.valueToTree(this.getContributorInsights()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getKinesisStream() != null) {
                data.set("kinesisStream", om.valueToTree(this.getKinesisStream()));
            }
            if (this.getPointInTimeRecovery() != null) {
                data.set("pointInTimeRecovery", om.valueToTree(this.getPointInTimeRecovery()));
            }
            if (this.getPointInTimeRecoverySpecification() != null) {
                data.set("pointInTimeRecoverySpecification", om.valueToTree(this.getPointInTimeRecoverySpecification()));
            }
            if (this.getResourcePolicy() != null) {
                data.set("resourcePolicy", om.valueToTree(this.getResourcePolicy()));
            }
            if (this.getTableClass() != null) {
                data.set("tableClass", om.valueToTree(this.getTableClass()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.ReplicaTableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ReplicaTableProps.Jsii$Proxy that = (ReplicaTableProps.Jsii$Proxy) o;

            if (!region.equals(that.region)) return false;
            if (this.globalSecondaryIndexOptions != null ? !this.globalSecondaryIndexOptions.equals(that.globalSecondaryIndexOptions) : that.globalSecondaryIndexOptions != null) return false;
            if (this.maxReadRequestUnits != null ? !this.maxReadRequestUnits.equals(that.maxReadRequestUnits) : that.maxReadRequestUnits != null) return false;
            if (this.readCapacity != null ? !this.readCapacity.equals(that.readCapacity) : that.readCapacity != null) return false;
            if (this.contributorInsights != null ? !this.contributorInsights.equals(that.contributorInsights) : that.contributorInsights != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.kinesisStream != null ? !this.kinesisStream.equals(that.kinesisStream) : that.kinesisStream != null) return false;
            if (this.pointInTimeRecovery != null ? !this.pointInTimeRecovery.equals(that.pointInTimeRecovery) : that.pointInTimeRecovery != null) return false;
            if (this.pointInTimeRecoverySpecification != null ? !this.pointInTimeRecoverySpecification.equals(that.pointInTimeRecoverySpecification) : that.pointInTimeRecoverySpecification != null) return false;
            if (this.resourcePolicy != null ? !this.resourcePolicy.equals(that.resourcePolicy) : that.resourcePolicy != null) return false;
            if (this.tableClass != null ? !this.tableClass.equals(that.tableClass) : that.tableClass != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.region.hashCode();
            result = 31 * result + (this.globalSecondaryIndexOptions != null ? this.globalSecondaryIndexOptions.hashCode() : 0);
            result = 31 * result + (this.maxReadRequestUnits != null ? this.maxReadRequestUnits.hashCode() : 0);
            result = 31 * result + (this.readCapacity != null ? this.readCapacity.hashCode() : 0);
            result = 31 * result + (this.contributorInsights != null ? this.contributorInsights.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.kinesisStream != null ? this.kinesisStream.hashCode() : 0);
            result = 31 * result + (this.pointInTimeRecovery != null ? this.pointInTimeRecovery.hashCode() : 0);
            result = 31 * result + (this.pointInTimeRecoverySpecification != null ? this.pointInTimeRecoverySpecification.hashCode() : 0);
            result = 31 * result + (this.resourcePolicy != null ? this.resourcePolicy.hashCode() : 0);
            result = 31 * result + (this.tableClass != null ? this.tableClass.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
