package software.amazon.awscdk.services.ec2;

/**
 * What generation of Amazon Linux to use.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.T3, InstanceSize.NANO))
 *         .machineImage(AmazonLinuxImage.Builder.create().generation(AmazonLinuxGeneration.AMAZON_LINUX_2).build())
 *         .instanceInitiatedShutdownBehavior(InstanceInitiatedShutdownBehavior.TERMINATE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:13.835Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AmazonLinuxGeneration")
public enum AmazonLinuxGeneration {
    /**
     * Amazon Linux.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AMAZON_LINUX,
    /**
     * Amazon Linux 2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AMAZON_LINUX_2,
    /**
     * Amazon Linux 2022.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AMAZON_LINUX_2022,
    /**
     * Amazon Linux 2023.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AMAZON_LINUX_2023,
}
