package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnTransitGatewayConnectPeer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnTransitGatewayConnectPeerProps cfnTransitGatewayConnectPeerProps = CfnTransitGatewayConnectPeerProps.builder()
 *         .connectPeerConfiguration(TransitGatewayConnectPeerConfigurationProperty.builder()
 *                 .insideCidrBlocks(List.of("insideCidrBlocks"))
 *                 .peerAddress("peerAddress")
 *                 // the properties below are optional
 *                 .bgpConfigurations(List.of(TransitGatewayAttachmentBgpConfigurationProperty.builder()
 *                         .bgpStatus("bgpStatus")
 *                         .peerAddress("peerAddress")
 *                         .peerAsn(123)
 *                         .transitGatewayAddress("transitGatewayAddress")
 *                         .transitGatewayAsn(123)
 *                         .build()))
 *                 .protocol("protocol")
 *                 .transitGatewayAddress("transitGatewayAddress")
 *                 .build())
 *         .transitGatewayAttachmentId("transitGatewayAttachmentId")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:14.241Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnTransitGatewayConnectPeerProps")
@software.amazon.jsii.Jsii.Proxy(CfnTransitGatewayConnectPeerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTransitGatewayConnectPeerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Connect peer details.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html#cfn-ec2-transitgatewayconnectpeer-connectpeerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html#cfn-ec2-transitgatewayconnectpeer-connectpeerconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConnectPeerConfiguration();

    /**
     * The ID of the Connect attachment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayattachmentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayattachmentid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTransitGatewayAttachmentId();

    /**
     * The tags for the Connect peer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html#cfn-ec2-transitgatewayconnectpeer-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html#cfn-ec2-transitgatewayconnectpeer-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTransitGatewayConnectPeerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTransitGatewayConnectPeerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTransitGatewayConnectPeerProps> {
        java.lang.Object connectPeerConfiguration;
        java.lang.String transitGatewayAttachmentId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnTransitGatewayConnectPeerProps#getConnectPeerConfiguration}
         * @param connectPeerConfiguration The Connect peer details. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectPeerConfiguration(software.amazon.awscdk.IResolvable connectPeerConfiguration) {
            this.connectPeerConfiguration = connectPeerConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayConnectPeerProps#getConnectPeerConfiguration}
         * @param connectPeerConfiguration The Connect peer details. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectPeerConfiguration(software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeer.TransitGatewayConnectPeerConfigurationProperty connectPeerConfiguration) {
            this.connectPeerConfiguration = connectPeerConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayConnectPeerProps#getTransitGatewayAttachmentId}
         * @param transitGatewayAttachmentId The ID of the Connect attachment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayAttachmentId(java.lang.String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayConnectPeerProps#getTags}
         * @param tags The tags for the Connect peer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTransitGatewayConnectPeerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTransitGatewayConnectPeerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTransitGatewayConnectPeerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTransitGatewayConnectPeerProps {
        private final java.lang.Object connectPeerConfiguration;
        private final java.lang.String transitGatewayAttachmentId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectPeerConfiguration = software.amazon.jsii.Kernel.get(this, "connectPeerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.transitGatewayAttachmentId = software.amazon.jsii.Kernel.get(this, "transitGatewayAttachmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectPeerConfiguration = java.util.Objects.requireNonNull(builder.connectPeerConfiguration, "connectPeerConfiguration is required");
            this.transitGatewayAttachmentId = java.util.Objects.requireNonNull(builder.transitGatewayAttachmentId, "transitGatewayAttachmentId is required");
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getConnectPeerConfiguration() {
            return this.connectPeerConfiguration;
        }

        @Override
        public final java.lang.String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectPeerConfiguration", om.valueToTree(this.getConnectPeerConfiguration()));
            data.set("transitGatewayAttachmentId", om.valueToTree(this.getTransitGatewayAttachmentId()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnTransitGatewayConnectPeerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTransitGatewayConnectPeerProps.Jsii$Proxy that = (CfnTransitGatewayConnectPeerProps.Jsii$Proxy) o;

            if (!connectPeerConfiguration.equals(that.connectPeerConfiguration)) return false;
            if (!transitGatewayAttachmentId.equals(that.transitGatewayAttachmentId)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connectPeerConfiguration.hashCode();
            result = 31 * result + (this.transitGatewayAttachmentId.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
