package software.amazon.awscdk.services.ec2;

/**
 * Options passed by the VPC when NAT needs to be configured.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * PrivateSubnet privateSubnet;
 * PublicSubnet publicSubnet;
 * Vpc vpc;
 * ConfigureNatOptions configureNatOptions = ConfigureNatOptions.builder()
 *         .natSubnets(List.of(publicSubnet))
 *         .privateSubnets(List.of(privateSubnet))
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:14.356Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.ConfigureNatOptions")
@software.amazon.jsii.Jsii.Proxy(ConfigureNatOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConfigureNatOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The public subnets where the NAT providers need to be placed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.PublicSubnet> getNatSubnets();

    /**
     * The private subnets that need to route through the NAT providers.
     * <p>
     * There may be more private subnets than public subnets with NAT providers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.PrivateSubnet> getPrivateSubnets();

    /**
     * The VPC we're configuring NAT for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Vpc getVpc();

    /**
     * @return a {@link Builder} of {@link ConfigureNatOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConfigureNatOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConfigureNatOptions> {
        java.util.List<software.amazon.awscdk.services.ec2.PublicSubnet> natSubnets;
        java.util.List<software.amazon.awscdk.services.ec2.PrivateSubnet> privateSubnets;
        software.amazon.awscdk.services.ec2.Vpc vpc;

        /**
         * Sets the value of {@link ConfigureNatOptions#getNatSubnets}
         * @param natSubnets The public subnets where the NAT providers need to be placed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder natSubnets(java.util.List<? extends software.amazon.awscdk.services.ec2.PublicSubnet> natSubnets) {
            this.natSubnets = (java.util.List<software.amazon.awscdk.services.ec2.PublicSubnet>)natSubnets;
            return this;
        }

        /**
         * Sets the value of {@link ConfigureNatOptions#getPrivateSubnets}
         * @param privateSubnets The private subnets that need to route through the NAT providers. This parameter is required.
         *                       There may be more private subnets than public subnets with NAT providers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder privateSubnets(java.util.List<? extends software.amazon.awscdk.services.ec2.PrivateSubnet> privateSubnets) {
            this.privateSubnets = (java.util.List<software.amazon.awscdk.services.ec2.PrivateSubnet>)privateSubnets;
            return this;
        }

        /**
         * Sets the value of {@link ConfigureNatOptions#getVpc}
         * @param vpc The VPC we're configuring NAT for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.Vpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConfigureNatOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConfigureNatOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConfigureNatOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigureNatOptions {
        private final java.util.List<software.amazon.awscdk.services.ec2.PublicSubnet> natSubnets;
        private final java.util.List<software.amazon.awscdk.services.ec2.PrivateSubnet> privateSubnets;
        private final software.amazon.awscdk.services.ec2.Vpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.natSubnets = software.amazon.jsii.Kernel.get(this, "natSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.PublicSubnet.class)));
            this.privateSubnets = software.amazon.jsii.Kernel.get(this, "privateSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.PrivateSubnet.class)));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Vpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.natSubnets = (java.util.List<software.amazon.awscdk.services.ec2.PublicSubnet>)java.util.Objects.requireNonNull(builder.natSubnets, "natSubnets is required");
            this.privateSubnets = (java.util.List<software.amazon.awscdk.services.ec2.PrivateSubnet>)java.util.Objects.requireNonNull(builder.privateSubnets, "privateSubnets is required");
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.PublicSubnet> getNatSubnets() {
            return this.natSubnets;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.PrivateSubnet> getPrivateSubnets() {
            return this.privateSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.Vpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("natSubnets", om.valueToTree(this.getNatSubnets()));
            data.set("privateSubnets", om.valueToTree(this.getPrivateSubnets()));
            data.set("vpc", om.valueToTree(this.getVpc()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.ConfigureNatOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConfigureNatOptions.Jsii$Proxy that = (ConfigureNatOptions.Jsii$Proxy) o;

            if (!natSubnets.equals(that.natSubnets)) return false;
            if (!privateSubnets.equals(that.privateSubnets)) return false;
            return this.vpc.equals(that.vpc);
        }

        @Override
        public final int hashCode() {
            int result = this.natSubnets.hashCode();
            result = 31 * result + (this.privateSubnets.hashCode());
            result = 31 * result + (this.vpc.hashCode());
            return result;
        }
    }
}
