package software.amazon.awscdk.services.ec2;

/**
 * What size of instance to use.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Creates a distribution from an EC2 instance
 * Vpc vpc;
 * // Create an EC2 instance in a VPC. 'subnetType' can be private.
 * Instance instance = Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE3, InstanceSize.MICRO))
 *         .machineImage(MachineImage.latestAmazonLinux2023())
 *         .vpcSubnets(SubnetSelection.builder().subnetType(SubnetType.PRIVATE_WITH_EGRESS).build())
 *         .build();
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder().origin(VpcOrigin.withEc2Instance(instance)).build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:14.434Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InstanceSize")
public enum InstanceSize {
    /**
     * Instance size NANO (nano).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NANO,
    /**
     * Instance size MICRO (micro).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MICRO,
    /**
     * Instance size SMALL (small).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SMALL,
    /**
     * Instance size MEDIUM (medium).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEDIUM,
    /**
     * Instance size LARGE (large).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LARGE,
    /**
     * Instance size XLARGE (xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE,
    /**
     * Instance size XLARGE2 (2xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE2,
    /**
     * Instance size XLARGE3 (3xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE3,
    /**
     * Instance size XLARGE4 (4xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE4,
    /**
     * Instance size XLARGE6 (6xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE6,
    /**
     * Instance size XLARGE8 (8xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE8,
    /**
     * Instance size XLARGE9 (9xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE9,
    /**
     * Instance size XLARGE10 (10xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE10,
    /**
     * Instance size XLARGE12 (12xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE12,
    /**
     * Instance size XLARGE16 (16xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE16,
    /**
     * Instance size XLARGE18 (18xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE18,
    /**
     * Instance size XLARGE24 (24xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE24,
    /**
     * Instance size XLARGE32 (32xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE32,
    /**
     * Instance size XLARGE48 (48xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE48,
    /**
     * Instance size XLARGE56 (56xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE56,
    /**
     * Instance size XLARGE96 (96xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE96,
    /**
     * Instance size XLARGE112 (112xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE112,
    /**
     * Instance size XLARGE224 (224xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE224,
    /**
     * Instance size XLARGE480 (480xlarge).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE480,
    /**
     * Instance size METAL (metal).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    METAL,
    /**
     * Instance size XLARGE16METAL (metal-16xl).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE16METAL,
    /**
     * Instance size XLARGE24METAL (metal-24xl).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE24METAL,
    /**
     * Instance size XLARGE32METAL (metal-32xl).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE32METAL,
    /**
     * Instance size XLARGE48METAL (metal-48xl).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XLARGE48METAL,
}
