package software.amazon.awscdk.services.ecr;

/**
 * Properties for looking up an existing Repository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // import using repository name
 * IRepository repositoryFromName = Repository.fromRepositoryName(this, "ImportedRepoByName", "my-repo-name");
 * // import using repository ARN
 * IRepository repositoryFromArn = Repository.fromRepositoryArn(this, "ImportedRepoByArn", "arn:aws:ecr:us-east-1:123456789012:repository/my-repo-name");
 * // import using repository lookup
 * // You have to provide either `repositoryArn` or `repositoryName` to lookup the repository
 * IRepository repositoryFromLookup = Repository.fromLookup(this, "ImportedRepoByLookup", RepositoryLookupOptions.builder()
 *         .repositoryArn("arn:aws:ecr:us-east-1:123456789012:repository/my-repo-name")
 *         .repositoryName("my-repo-name")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:14.600Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr.RepositoryLookupOptions")
@software.amazon.jsii.Jsii.Proxy(RepositoryLookupOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RepositoryLookupOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the repository.
     * <p>
     * Default: - Do not filter on repository ARN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRepositoryArn() {
        return null;
    }

    /**
     * The name of the repository.
     * <p>
     * Default: - Do not filter on repository name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRepositoryName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RepositoryLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RepositoryLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RepositoryLookupOptions> {
        java.lang.String repositoryArn;
        java.lang.String repositoryName;

        /**
         * Sets the value of {@link RepositoryLookupOptions#getRepositoryArn}
         * @param repositoryArn The ARN of the repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryArn(java.lang.String repositoryArn) {
            this.repositoryArn = repositoryArn;
            return this;
        }

        /**
         * Sets the value of {@link RepositoryLookupOptions#getRepositoryName}
         * @param repositoryName The name of the repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RepositoryLookupOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RepositoryLookupOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RepositoryLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RepositoryLookupOptions {
        private final java.lang.String repositoryArn;
        private final java.lang.String repositoryName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.repositoryArn = software.amazon.jsii.Kernel.get(this, "repositoryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.repositoryArn = builder.repositoryArn;
            this.repositoryName = builder.repositoryName;
        }

        @Override
        public final java.lang.String getRepositoryArn() {
            return this.repositoryArn;
        }

        @Override
        public final java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getRepositoryArn() != null) {
                data.set("repositoryArn", om.valueToTree(this.getRepositoryArn()));
            }
            if (this.getRepositoryName() != null) {
                data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecr.RepositoryLookupOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RepositoryLookupOptions.Jsii$Proxy that = (RepositoryLookupOptions.Jsii$Proxy) o;

            if (this.repositoryArn != null ? !this.repositoryArn.equals(that.repositoryArn) : that.repositoryArn != null) return false;
            return this.repositoryName != null ? this.repositoryName.equals(that.repositoryName) : that.repositoryName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.repositoryArn != null ? this.repositoryArn.hashCode() : 0;
            result = 31 * result + (this.repositoryName != null ? this.repositoryName.hashCode() : 0);
            return result;
        }
    }
}
