package software.amazon.awscdk.services.ecs;

/**
 * Configuration for a deployment lifecycle hook target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.iam.*;
 * Role role;
 * DeploymentLifecycleHookTargetConfig deploymentLifecycleHookTargetConfig = DeploymentLifecycleHookTargetConfig.builder()
 *         .lifecycleStages(List.of(DeploymentLifecycleStage.RECONCILE_SERVICE))
 *         .targetArn("targetArn")
 *         // the properties below are optional
 *         .role(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:14.839Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.DeploymentLifecycleHookTargetConfig")
@software.amazon.jsii.Jsii.Proxy(DeploymentLifecycleHookTargetConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeploymentLifecycleHookTargetConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The lifecycle stages when this hook should be executed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.DeploymentLifecycleStage> getLifecycleStages();

    /**
     * The ARN of the target resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetArn();

    /**
     * The IAM role that grants permissions to invoke the target.
     * <p>
     * Default: - a role will be created automatically
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DeploymentLifecycleHookTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeploymentLifecycleHookTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeploymentLifecycleHookTargetConfig> {
        java.util.List<software.amazon.awscdk.services.ecs.DeploymentLifecycleStage> lifecycleStages;
        java.lang.String targetArn;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link DeploymentLifecycleHookTargetConfig#getLifecycleStages}
         * @param lifecycleStages The lifecycle stages when this hook should be executed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder lifecycleStages(java.util.List<? extends software.amazon.awscdk.services.ecs.DeploymentLifecycleStage> lifecycleStages) {
            this.lifecycleStages = (java.util.List<software.amazon.awscdk.services.ecs.DeploymentLifecycleStage>)lifecycleStages;
            return this;
        }

        /**
         * Sets the value of {@link DeploymentLifecycleHookTargetConfig#getTargetArn}
         * @param targetArn The ARN of the target resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetArn(java.lang.String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        /**
         * Sets the value of {@link DeploymentLifecycleHookTargetConfig#getRole}
         * @param role The IAM role that grants permissions to invoke the target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeploymentLifecycleHookTargetConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeploymentLifecycleHookTargetConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeploymentLifecycleHookTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentLifecycleHookTargetConfig {
        private final java.util.List<software.amazon.awscdk.services.ecs.DeploymentLifecycleStage> lifecycleStages;
        private final java.lang.String targetArn;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.lifecycleStages = software.amazon.jsii.Kernel.get(this, "lifecycleStages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DeploymentLifecycleStage.class)));
            this.targetArn = software.amazon.jsii.Kernel.get(this, "targetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.lifecycleStages = (java.util.List<software.amazon.awscdk.services.ecs.DeploymentLifecycleStage>)java.util.Objects.requireNonNull(builder.lifecycleStages, "lifecycleStages is required");
            this.targetArn = java.util.Objects.requireNonNull(builder.targetArn, "targetArn is required");
            this.role = builder.role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.DeploymentLifecycleStage> getLifecycleStages() {
            return this.lifecycleStages;
        }

        @Override
        public final java.lang.String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("lifecycleStages", om.valueToTree(this.getLifecycleStages()));
            data.set("targetArn", om.valueToTree(this.getTargetArn()));
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.DeploymentLifecycleHookTargetConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeploymentLifecycleHookTargetConfig.Jsii$Proxy that = (DeploymentLifecycleHookTargetConfig.Jsii$Proxy) o;

            if (!lifecycleStages.equals(that.lifecycleStages)) return false;
            if (!targetArn.equals(that.targetArn)) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.lifecycleStages.hashCode();
            result = 31 * result + (this.targetArn.hashCode());
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
