package software.amazon.awscdk.services.ecs;

/**
 * Use an AWS Lambda function as a deployment lifecycle hook target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * Function lambdaHook;
 * ApplicationTargetGroup blueTargetGroup;
 * ApplicationTargetGroup greenTargetGroup;
 * ApplicationListenerRule prodListenerRule;
 * FargateService service = FargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .deploymentStrategy(DeploymentStrategy.BLUE_GREEN)
 *         .build();
 * service.addLifecycleHook(DeploymentLifecycleLambdaTarget.Builder.create(lambdaHook, "PreScaleHook")
 *         .lifecycleStages(List.of(DeploymentLifecycleStage.PRE_SCALE_UP))
 *         .build());
 * IEcsLoadBalancerTarget target = service.loadBalancerTarget(LoadBalancerTargetOptions.builder()
 *         .containerName("nginx")
 *         .containerPort(80)
 *         .protocol(Protocol.TCP)
 *         .alternateTarget(AlternateTarget.Builder.create("AlternateTarget")
 *                 .alternateTargetGroup(greenTargetGroup)
 *                 .productionListener(ListenerRuleConfiguration.applicationListenerRule(prodListenerRule))
 *                 .build())
 *         .build());
 * target.attachToApplicationTargetGroup(blueTargetGroup);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:14.839Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.DeploymentLifecycleLambdaTarget")
public class DeploymentLifecycleLambdaTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ecs.IDeploymentLifecycleHookTarget {

    protected DeploymentLifecycleLambdaTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DeploymentLifecycleLambdaTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param handler This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DeploymentLifecycleLambdaTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction handler, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.DeploymentLifecycleLambdaTargetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(handler, "handler is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Bind this target to a deployment lifecycle hook.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.DeploymentLifecycleHookTargetConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct scope) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DeploymentLifecycleHookTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * The IAM role for the deployment lifecycle hook target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.DeploymentLifecycleLambdaTarget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.DeploymentLifecycleLambdaTarget> {
        /**
         * @return a new instance of {@link Builder}.
         * @param handler This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.lambda.IFunction handler, final java.lang.String id) {
            return new Builder(handler, id);
        }

        private final software.amazon.awscdk.services.lambda.IFunction handler;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.DeploymentLifecycleLambdaTargetProps.Builder props;

        private Builder(final software.amazon.awscdk.services.lambda.IFunction handler, final java.lang.String id) {
            this.handler = handler;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.DeploymentLifecycleLambdaTargetProps.Builder();
        }

        /**
         * The lifecycle stages when this hook should be executed.
         * <p>
         * @return {@code this}
         * @param lifecycleStages The lifecycle stages when this hook should be executed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleStages(final java.util.List<? extends software.amazon.awscdk.services.ecs.DeploymentLifecycleStage> lifecycleStages) {
            this.props.lifecycleStages(lifecycleStages);
            return this;
        }

        /**
         * The IAM role that grants permissions to invoke the lambda target.
         * <p>
         * Default: - A unique role will be generated for this lambda function.
         * <p>
         * @return {@code this}
         * @param role The IAM role that grants permissions to invoke the lambda target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.DeploymentLifecycleLambdaTarget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.DeploymentLifecycleLambdaTarget build() {
            return new software.amazon.awscdk.services.ecs.DeploymentLifecycleLambdaTarget(
                this.handler,
                this.id,
                this.props.build()
            );
        }
    }
}
