package software.amazon.awscdk.services.ecs;

/**
 * Specifies the firelens log driver configuration options.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a Task Definition for the container to start
 * Ec2TaskDefinition taskDefinition = new Ec2TaskDefinition(this, "TaskDef");
 * taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("example-image"))
 *         .memoryLimitMiB(256)
 *         .logging(LogDrivers.firelens(FireLensLogDriverProps.builder()
 *                 .options(Map.of(
 *                         "Name", "firehose",
 *                         "region", "us-west-2",
 *                         "delivery_stream", "my-stream"))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:14.880Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.FireLensLogDriverProps")
@software.amazon.jsii.Jsii.Proxy(FireLensLogDriverProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FireLensLogDriverProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.BaseLogDriverProps {

    /**
     * The configuration options to send to the log driver.
     * <p>
     * Default: - the log driver options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getOptions() {
        return null;
    }

    /**
     * The secrets to pass to the log configuration.
     * <p>
     * Default: - No secret options provided.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecretOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FireLensLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FireLensLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FireLensLogDriverProps> {
        java.util.Map<java.lang.String, java.lang.String> options;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secretOptions;
        java.util.List<java.lang.String> env;
        java.lang.String envRegex;
        java.util.List<java.lang.String> labels;
        java.lang.String tag;

        /**
         * Sets the value of {@link FireLensLogDriverProps#getOptions}
         * @param options The configuration options to send to the log driver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(java.util.Map<java.lang.String, java.lang.String> options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link FireLensLogDriverProps#getSecretOptions}
         * @param secretOptions The secrets to pass to the log configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder secretOptions(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ecs.Secret> secretOptions) {
            this.secretOptions = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret>)secretOptions;
            return this;
        }

        /**
         * Sets the value of {@link FireLensLogDriverProps#getEnv}
         * @param env The env option takes an array of keys.
         *            If there is collision between
         *            label and env keys, the value of the env takes precedence. Adds additional fields
         *            to the extra attributes of a logging message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(java.util.List<java.lang.String> env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link FireLensLogDriverProps#getEnvRegex}
         * @param envRegex The env-regex option is similar to and compatible with env.
         *                 Its value is a regular
         *                 expression to match logging-related environment variables. It is used for advanced
         *                 log tag options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder envRegex(java.lang.String envRegex) {
            this.envRegex = envRegex;
            return this;
        }

        /**
         * Sets the value of {@link FireLensLogDriverProps#getLabels}
         * @param labels The labels option takes an array of keys.
         *               If there is collision
         *               between label and env keys, the value of the env takes precedence. Adds additional
         *               fields to the extra attributes of a logging message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.List<java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link FireLensLogDriverProps#getTag}
         * @param tag By default, Docker uses the first 12 characters of the container ID to tag log messages.
         *            Refer to the log tag option documentation for customizing the
         *            log tag format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tag(java.lang.String tag) {
            this.tag = tag;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FireLensLogDriverProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FireLensLogDriverProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FireLensLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FireLensLogDriverProps {
        private final java.util.Map<java.lang.String, java.lang.String> options;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secretOptions;
        private final java.util.List<java.lang.String> env;
        private final java.lang.String envRegex;
        private final java.util.List<java.lang.String> labels;
        private final java.lang.String tag;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.secretOptions = software.amazon.jsii.Kernel.get(this, "secretOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class)));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.envRegex = software.amazon.jsii.Kernel.get(this, "envRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tag = software.amazon.jsii.Kernel.get(this, "tag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.options = builder.options;
            this.secretOptions = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret>)builder.secretOptions;
            this.env = builder.env;
            this.envRegex = builder.envRegex;
            this.labels = builder.labels;
            this.tag = builder.tag;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getOptions() {
            return this.options;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecretOptions() {
            return this.secretOptions;
        }

        @Override
        public final java.util.List<java.lang.String> getEnv() {
            return this.env;
        }

        @Override
        public final java.lang.String getEnvRegex() {
            return this.envRegex;
        }

        @Override
        public final java.util.List<java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        public final java.lang.String getTag() {
            return this.tag;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getSecretOptions() != null) {
                data.set("secretOptions", om.valueToTree(this.getSecretOptions()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getEnvRegex() != null) {
                data.set("envRegex", om.valueToTree(this.getEnvRegex()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getTag() != null) {
                data.set("tag", om.valueToTree(this.getTag()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.FireLensLogDriverProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FireLensLogDriverProps.Jsii$Proxy that = (FireLensLogDriverProps.Jsii$Proxy) o;

            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            if (this.secretOptions != null ? !this.secretOptions.equals(that.secretOptions) : that.secretOptions != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.envRegex != null ? !this.envRegex.equals(that.envRegex) : that.envRegex != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            return this.tag != null ? this.tag.equals(that.tag) : that.tag == null;
        }

        @Override
        public final int hashCode() {
            int result = this.options != null ? this.options.hashCode() : 0;
            result = 31 * result + (this.secretOptions != null ? this.secretOptions.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.envRegex != null ? this.envRegex.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
            return result;
        }
    }
}
