package software.amazon.awscdk.services.ecs;

/**
 * Elastic Inference Accelerator.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/elastic-inference/latest/developerguide/basics.html">Elastic Inference Basics</a>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * InferenceAccelerator inferenceAccelerator = InferenceAccelerator.builder()
 *         .deviceName("deviceName")
 *         .deviceType("deviceType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:14.913Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.InferenceAccelerator")
@software.amazon.jsii.Jsii.Proxy(InferenceAccelerator.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InferenceAccelerator extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Elastic Inference accelerator device name.
     * <p>
     * Default: - empty
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeviceName() {
        return null;
    }

    /**
     * The Elastic Inference accelerator type to use.
     * <p>
     * The allowed values are: eia2.medium, eia2.large and eia2.xlarge.
     * <p>
     * Default: - empty
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeviceType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InferenceAccelerator}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InferenceAccelerator}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InferenceAccelerator> {
        java.lang.String deviceName;
        java.lang.String deviceType;

        /**
         * Sets the value of {@link InferenceAccelerator#getDeviceName}
         * @param deviceName The Elastic Inference accelerator device name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceName(java.lang.String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        /**
         * Sets the value of {@link InferenceAccelerator#getDeviceType}
         * @param deviceType The Elastic Inference accelerator type to use.
         *                   The allowed values are: eia2.medium, eia2.large and eia2.xlarge.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceType(java.lang.String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InferenceAccelerator}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InferenceAccelerator build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InferenceAccelerator}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InferenceAccelerator {
        private final java.lang.String deviceName;
        private final java.lang.String deviceType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deviceName = software.amazon.jsii.Kernel.get(this, "deviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deviceType = software.amazon.jsii.Kernel.get(this, "deviceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deviceName = builder.deviceName;
            this.deviceType = builder.deviceType;
        }

        @Override
        public final java.lang.String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final java.lang.String getDeviceType() {
            return this.deviceType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDeviceName() != null) {
                data.set("deviceName", om.valueToTree(this.getDeviceName()));
            }
            if (this.getDeviceType() != null) {
                data.set("deviceType", om.valueToTree(this.getDeviceType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.InferenceAccelerator"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InferenceAccelerator.Jsii$Proxy that = (InferenceAccelerator.Jsii$Proxy) o;

            if (this.deviceName != null ? !this.deviceName.equals(that.deviceName) : that.deviceName != null) return false;
            return this.deviceType != null ? this.deviceType.equals(that.deviceType) : that.deviceType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deviceName != null ? this.deviceName.hashCode() : 0;
            result = 31 * result + (this.deviceType != null ? this.deviceType.hashCode() : 0);
            return result;
        }
    }
}
