package software.amazon.awscdk.services.ecs;

/**
 * The machine image type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * LaunchTemplate launchTemplate = LaunchTemplate.Builder.create(this, "ASG-LaunchTemplate")
 *         .instanceType(new InstanceType("t3.medium"))
 *         .machineImage(EcsOptimizedImage.amazonLinux2())
 *         .userData(UserData.forLinux())
 *         .build();
 * AutoScalingGroup autoScalingGroup = AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .mixedInstancesPolicy(MixedInstancesPolicy.builder()
 *                 .instancesDistribution(InstancesDistribution.builder()
 *                         .onDemandPercentageAboveBaseCapacity(50)
 *                         .build())
 *                 .launchTemplate(launchTemplate)
 *                 .build())
 *         .build();
 * Cluster cluster = Cluster.Builder.create(this, "Cluster").vpc(vpc).build();
 * AsgCapacityProvider capacityProvider = AsgCapacityProvider.Builder.create(this, "AsgCapacityProvider")
 *         .autoScalingGroup(autoScalingGroup)
 *         .machineImageType(MachineImageType.AMAZON_LINUX_2)
 *         .build();
 * cluster.addAsgCapacityProvider(capacityProvider);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:14.933Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.MachineImageType")
public enum MachineImageType {
    /**
     * Amazon ECS-optimized Amazon Linux 2 AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AMAZON_LINUX_2,
    /**
     * Bottlerocket AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOTTLEROCKET,
}
