package software.amazon.awscdk.services.eks;

/**
 * Controller version.
 * <p>
 * Corresponds to the image tag of 'amazon/aws-load-balancer-controller' image.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.cdk.lambdalayer.kubectl.v33.KubectlV33Layer;
 * Cluster.Builder.create(this, "HelloEKS")
 *         .version(KubernetesVersion.V1_33)
 *         .albController(AlbControllerOptions.builder()
 *                 .version(AlbControllerVersion.V2_8_2)
 *                 .build())
 *         .kubectlLayer(new KubectlV33Layer(this, "kubectl"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:15.168Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AlbControllerVersion")
public class AlbControllerVersion extends software.amazon.jsii.JsiiObject {

    protected AlbControllerVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AlbControllerVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        V2_0_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_0_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_0_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_0_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_1_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_1_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_1_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_1_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_1_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_1_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_2_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_2_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_2_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_2_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_2_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_2_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_2_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_2_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_3_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_3_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_3_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_3_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_4_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_4_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_4_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_4_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_4_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_4_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_4_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_4_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_4_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_4_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_4_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_4_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_4_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_4_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_5_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_5_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_5_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_5_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_5_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_5_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_5_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_5_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_5_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_5_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_6_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_6_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_6_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_6_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_6_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_6_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_7_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_7_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_7_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_7_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_7_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_7_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_8_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_8_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_8_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_8_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_8_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_8_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
    }

    /**
     * Specify a custom version and an associated helm chart version.
     * <p>
     * Use this if the version you need is not available in one of the predefined versions.
     * Note that in this case, you will also need to provide an IAM policy in the controller options.
     * <p>
     * ALB controller version and helm chart version compatibility information can be found
     * here: https://github.com/aws/eks-charts/blob/v0.0.133/stable/aws-load-balancer-controller/Chart.yaml
     * <p>
     * @param version The version number. This parameter is required.
     * @param helmChartVersion The version of the helm chart.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AlbControllerVersion of(final @org.jetbrains.annotations.NotNull java.lang.String version, final @org.jetbrains.annotations.Nullable java.lang.String helmChartVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required"), helmChartVersion });
    }

    /**
     * Specify a custom version and an associated helm chart version.
     * <p>
     * Use this if the version you need is not available in one of the predefined versions.
     * Note that in this case, you will also need to provide an IAM policy in the controller options.
     * <p>
     * ALB controller version and helm chart version compatibility information can be found
     * here: https://github.com/aws/eks-charts/blob/v0.0.133/stable/aws-load-balancer-controller/Chart.yaml
     * <p>
     * @param version The version number. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AlbControllerVersion of(final @org.jetbrains.annotations.NotNull java.lang.String version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * v2.0.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_0_0;

    /**
     * v2.0.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_0_1;

    /**
     * v2.1.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_1_0;

    /**
     * v2.1.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_1_1;

    /**
     * v2.1.2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_1_2;

    /**
     * v2.1.3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_1_3;

    /**
     * v2.0.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_2_0;

    /**
     * v2.2.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_2_1;

    /**
     * v2.2.2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_2_2;

    /**
     * v2.2.3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_2_3;

    /**
     * v2.2.4.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_2_4;

    /**
     * v2.3.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_3_0;

    /**
     * v2.3.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_3_1;

    /**
     * v2.4.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_4_1;

    /**
     * v2.4.2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_4_2;

    /**
     * v2.4.3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_4_3;

    /**
     * v2.4.4.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_4_4;

    /**
     * v2.4.5.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_4_5;

    /**
     * v2.4.6.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_4_6;

    /**
     * v2.4.7.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_4_7;

    /**
     * v2.5.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_5_0;

    /**
     * v2.5.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_5_1;

    /**
     * v2.5.2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_5_2;

    /**
     * v2.5.3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_5_3;

    /**
     * v2.5.4.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_5_4;

    /**
     * v2.6.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_6_0;

    /**
     * v2.6.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_6_1;

    /**
     * v2.6.2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_6_2;

    /**
     * v2.7.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_7_0;

    /**
     * v2.7.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_7_1;

    /**
     * v2.7.2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_7_2;

    /**
     * v2.8.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_8_0;

    /**
     * v2.8.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_8_1;

    /**
     * v2.8.2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_8_2;

    /**
     * Whether or not its a custom version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getCustom() {
        return software.amazon.jsii.Kernel.get(this, "custom", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The version of the helm chart to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getHelmChartVersion() {
        return software.amazon.jsii.Kernel.get(this, "helmChartVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
