package software.amazon.awscdk.services.eks;

/**
 * The default capacity type for the cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.cdk.lambdalayer.kubectl.v33.KubectlV33Layer;
 * Cluster cluster = Cluster.Builder.create(this, "HelloEKS")
 *         .version(KubernetesVersion.V1_33)
 *         .defaultCapacityType(DefaultCapacityType.EC2)
 *         .kubectlLayer(new KubectlV33Layer(this, "kubectl"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:15.246Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.DefaultCapacityType")
public enum DefaultCapacityType {
    /**
     * managed node group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NODEGROUP,
    /**
     * EC2 autoscaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EC2,
}
