package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Count of HTTP status originating from the targets.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudwatch.*;
 * FargateService service;
 * ApplicationTargetGroup blueTargetGroup;
 * ApplicationTargetGroup greenTargetGroup;
 * IApplicationListener listener;
 * // Alarm on the number of unhealthy ECS tasks in each target group
 * Alarm blueUnhealthyHosts = Alarm.Builder.create(this, "BlueUnhealthyHosts")
 *         .alarmName(Stack.of(this).getStackName() + "-Unhealthy-Hosts-Blue")
 *         .metric(blueTargetGroup.metricUnhealthyHostCount())
 *         .threshold(1)
 *         .evaluationPeriods(2)
 *         .build();
 * Alarm greenUnhealthyHosts = Alarm.Builder.create(this, "GreenUnhealthyHosts")
 *         .alarmName(Stack.of(this).getStackName() + "-Unhealthy-Hosts-Green")
 *         .metric(greenTargetGroup.metricUnhealthyHostCount())
 *         .threshold(1)
 *         .evaluationPeriods(2)
 *         .build();
 * // Alarm on the number of HTTP 5xx responses returned by each target group
 * Alarm blueApiFailure = Alarm.Builder.create(this, "Blue5xx")
 *         .alarmName(Stack.of(this).getStackName() + "-Http-5xx-Blue")
 *         .metric(blueTargetGroup.metricHttpCodeTarget(HttpCodeTarget.TARGET_5XX_COUNT, MetricOptions.builder().period(Duration.minutes(1)).build()))
 *         .threshold(1)
 *         .evaluationPeriods(1)
 *         .build();
 * Alarm greenApiFailure = Alarm.Builder.create(this, "Green5xx")
 *         .alarmName(Stack.of(this).getStackName() + "-Http-5xx-Green")
 *         .metric(greenTargetGroup.metricHttpCodeTarget(HttpCodeTarget.TARGET_5XX_COUNT, MetricOptions.builder().period(Duration.minutes(1)).build()))
 *         .threshold(1)
 *         .evaluationPeriods(1)
 *         .build();
 * EcsDeploymentGroup.Builder.create(this, "BlueGreenDG")
 *         // CodeDeploy will monitor these alarms during a deployment and automatically roll back
 *         .alarms(List.of(blueUnhealthyHosts, greenUnhealthyHosts, blueApiFailure, greenApiFailure))
 *         .autoRollback(AutoRollbackConfig.builder()
 *                 // CodeDeploy will automatically roll back if a deployment is stopped
 *                 .stoppedDeployment(true)
 *                 .build())
 *         .service(service)
 *         .blueGreenDeploymentConfig(EcsBlueGreenDeploymentConfig.builder()
 *                 .blueTargetGroup(blueTargetGroup)
 *                 .greenTargetGroup(greenTargetGroup)
 *                 .listener(listener)
 *                 .build())
 *         .deploymentConfig(EcsDeploymentConfig.CANARY_10PERCENT_5MINUTES)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-08-12T14:44:15.520Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.HttpCodeTarget")
public enum HttpCodeTarget {
    /**
     * The number of 2xx response codes from targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TARGET_2XX_COUNT,
    /**
     * The number of 3xx response codes from targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TARGET_3XX_COUNT,
    /**
     * The number of 4xx response codes from targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TARGET_4XX_COUNT,
    /**
     * The number of 5xx response codes from targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TARGET_5XX_COUNT,
}
